/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.highlighting.support;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PositionsBag
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(PositionsBag.class.getName());
    private Document document;
    private boolean mergeHighlights;
    private GapList<Position> marks = new GapList();
    private GapList<AttributeSet> attributes = new GapList();
    private long version = 0L;

    public PositionsBag(Document document) {
        this(document, false);
    }

    public PositionsBag(Document document, boolean bl) {
        this.document = document;
        this.mergeHighlights = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlight(Position position, Position position2, AttributeSet attributeSet) {
        int[] nArray;
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            nArray = this.addHighlightImpl(position, position2, attributeSet);
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllHighlights(PositionsBag positionsBag) {
        int[] nArray;
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            nArray = this.addAllHighlightsImpl(positionsBag);
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighlights(PositionsBag positionsBag) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            int[] nArray = this.clearImpl();
            int[] nArray2 = null;
            GapList<Position> gapList2 = positionsBag.getMarks();
            GapList<AttributeSet> gapList3 = positionsBag.getAttributes();
            GapList<Position> gapList4 = gapList2;
            synchronized (gapList4) {
                for (Object object : gapList2) {
                    this.marks.add(this.marks.size(), object);
                }
                for (Object object : gapList3) {
                    this.attributes.add(this.attributes.size(), object);
                }
                if (this.marks.size() > 0) {
                    nArray2 = new int[]{((Position)this.marks.get(0)).getOffset(), ((Position)this.marks.get(this.marks.size() - 1)).getOffset()};
                }
            }
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            }
            if (nArray2 != null) {
                if (n == Integer.MAX_VALUE || n > nArray2[0]) {
                    n = nArray2[0];
                }
                if (n2 == Integer.MIN_VALUE || n2 < nArray2[1]) {
                    n2 = nArray2[1];
                }
            }
            if (n < n2) {
                ++this.version;
            }
        }
        if (n < n2) {
            this.fireHighlightsChange(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlights(Position position, Position position2, boolean bl) {
        if (!bl) {
            this.removeHighlights(position.getOffset(), position2.getOffset());
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        if (position.getOffset() == position2.getOffset()) {
            return;
        }
        assert (position.getOffset() < position2.getOffset()) : "Start position must be before the end position";
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            int n3;
            if (this.marks.isEmpty()) {
                return;
            }
            int n4 = this.indexBeforeOffset(position.getOffset());
            if (n4 == (n3 = this.indexBeforeOffset(position2.getOffset(), n4 < 0 ? 0 : n4, this.marks.size() - 1))) {
                if (n4 != -1 && this.attributes.get(n4) != null) {
                    AttributeSet attributeSet = (AttributeSet)this.attributes.get(n4);
                    if (((Position)this.marks.get(n4)).getOffset() == position.getOffset()) {
                        this.marks.set(n4, (Object)position2);
                        this.attributes.set(n4, (Object)attributeSet);
                    } else {
                        this.marks.add(n4 + 1, (Object)position);
                        this.attributes.add(n4 + 1, null);
                        this.marks.add(n4 + 2, (Object)position2);
                        this.attributes.add(n4 + 2, (Object)attributeSet);
                    }
                    n = position.getOffset();
                    n2 = position2.getOffset();
                }
            } else {
                assert (n3 != -1) : "Invalid range: startIdx = " + n4 + " endIdx = " + n3;
                if (this.attributes.get(n3) != null) {
                    this.marks.set(n3, (Object)position2);
                    n2 = position2.getOffset();
                    --n3;
                }
                if (n4 != -1 && this.attributes.get(n4) != null) {
                    if (++n4 <= n3) {
                        this.marks.set(n4, (Object)position);
                        this.attributes.set(n4, null);
                    } else {
                        this.marks.add(n4, (Object)position);
                        this.attributes.add(n4, null);
                    }
                    n = position.getOffset();
                }
                if (++n4 <= n3) {
                    if (n == Integer.MAX_VALUE) {
                        n = ((Position)this.marks.get(n4)).getOffset();
                    }
                    if (n2 == Integer.MIN_VALUE) {
                        n2 = ((Position)this.marks.get(n3)).getOffset();
                    }
                    this.marks.remove(n4, n3 - n4 + 1);
                    this.attributes.remove(n4, n3 - n4 + 1);
                }
            }
            if (n < n2) {
                ++this.version;
            }
        }
        if (n < n2) {
            this.fireHighlightsChange(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighlights(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        if (n == n2) {
            return;
        }
        assert (n < n2) : "Start position must be before the end position";
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            if (this.marks.isEmpty()) {
                return;
            }
            int n5 = this.indexBeforeOffset(n);
            int n6 = this.indexBeforeOffset(n2, n5 < 0 ? 0 : n5, this.marks.size() - 1);
            if (n5 == -1 || this.attributes.get(n5) == null) {
                ++n5;
            }
            if (n6 != -1 && this.attributes.get(n6) != null) {
                ++n6;
            }
            if (n5 < n6) {
                if (n3 == Integer.MAX_VALUE) {
                    n3 = ((Position)this.marks.get(n5)).getOffset();
                }
                if (n4 == Integer.MIN_VALUE) {
                    n4 = ((Position)this.marks.get(n6)).getOffset();
                }
                this.marks.remove(n5, n6 - n5 + 1);
            }
            if (n3 < n4) {
                ++this.version;
            }
        }
        if (n3 < n4) {
            this.fireHighlightsChange(n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int n, int n2) {
        if (LOG.isLoggable(Level.FINE) && n >= n2) {
            LOG.fine("startOffset must be less than endOffset: startOffset = " + n + " endOffset = " + n2);
        }
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            return new Seq(this.version, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int[] nArray;
        GapList<Position> gapList = this.marks;
        synchronized (gapList) {
            nArray = this.clearImpl();
            if (nArray != null) {
                ++this.version;
            }
        }
        if (nArray != null) {
            this.fireHighlightsChange(nArray[0], nArray[1]);
        }
    }

    GapList<Position> getMarks() {
        return this.marks;
    }

    GapList<AttributeSet> getAttributes() {
        return this.attributes;
    }

    private int[] addHighlightImpl(Position position, Position position2, AttributeSet attributeSet) {
        if (position.getOffset() == position2.getOffset()) {
            return null;
        }
        assert (position.getOffset() < position2.getOffset()) : "Start position must be before the end position.";
        assert (attributeSet != null) : "Highlight attributes must not be null.";
        if (this.mergeHighlights) {
            this.merge(position, position2, attributeSet);
        } else {
            this.trim(position, position2, attributeSet);
        }
        return new int[]{position.getOffset(), position2.getOffset()};
    }

    private void merge(Position position, Position position2, AttributeSet attributeSet) {
        Object object;
        AttributeSet attributeSet2 = null;
        int n = this.indexBeforeOffset(position.getOffset());
        if (n < 0) {
            n = 0;
            this.marks.add(n, (Object)position);
            this.attributes.add(n, (Object)attributeSet);
        } else {
            Position position3 = (Position)this.marks.get(n);
            object = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, (AttributeSet)this.attributes.get(n)});
            attributeSet2 = (AttributeSet)this.attributes.get(n);
            if (position3.getOffset() == position.getOffset()) {
                this.attributes.set(n, object);
            } else {
                this.marks.add(++n, (Object)position);
                this.attributes.add(n, object);
            }
        }
        int n2 = n + 1;
        while (true) {
            if (n2 < this.marks.size()) {
                object = (Position)this.marks.get(n2);
                if (object.getOffset() >= position2.getOffset()) {
                    if (object.getOffset() <= position2.getOffset()) break;
                    this.marks.add(n2, (Object)position2);
                    this.attributes.add(n2, (Object)attributeSet2);
                    break;
                }
            } else {
                this.marks.add(n2, (Object)position2);
                this.attributes.add(n2, (Object)attributeSet2);
                break;
            }
            attributeSet2 = (AttributeSet)this.attributes.get(n2);
            this.attributes.set(n2, (Object)AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, attributeSet2}));
            ++n2;
        }
    }

    private void trim(Position position, Position position2, AttributeSet attributeSet) {
        int n;
        int n2 = this.indexBeforeOffset(position.getOffset());
        if (n2 == (n = this.indexBeforeOffset(position2.getOffset(), n2 < 0 ? 0 : n2, this.marks.size() - 1))) {
            AttributeSet attributeSet2 = null;
            if (n2 != -1 && this.attributes.get(n2) != null) {
                attributeSet2 = (AttributeSet)this.attributes.get(n2);
            }
            if (n2 != -1 && ((Position)this.marks.get(n2)).getOffset() == position.getOffset()) {
                this.attributes.set(n2, (Object)attributeSet);
            } else {
                this.marks.add(++n2, (Object)position);
                this.attributes.add(n2, (Object)attributeSet);
            }
            this.marks.add(++n2, (Object)position2);
            this.attributes.add(n2, (Object)attributeSet2);
        } else {
            assert (n != -1) : "Invalid range: startIdx = " + n2 + " endIdx = " + n;
            this.marks.set(n, (Object)position2);
            this.attributes.set(n, this.attributes.get(n));
            if (++n2 <= --n) {
                this.marks.set(n2, (Object)position);
                this.attributes.set(n2, (Object)attributeSet);
            } else {
                this.marks.add(n2, (Object)position);
                this.attributes.add(n2, (Object)attributeSet);
            }
            if (++n2 <= n) {
                this.marks.remove(n2, n - n2 + 1);
                this.attributes.remove(n2, n - n2 + 1);
            }
        }
    }

    private int[] addAllHighlightsImpl(PositionsBag positionsBag) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        GapList<Position> gapList = positionsBag.getMarks();
        GapList<AttributeSet> gapList2 = positionsBag.getAttributes();
        int n3 = 0;
        while (n3 + 1 < gapList.size()) {
            Position position = (Position)gapList.get(n3);
            Position position2 = (Position)gapList.get(n3 + 1);
            AttributeSet attributeSet = (AttributeSet)gapList2.get(n3);
            if (attributeSet != null) {
                this.addHighlightImpl(position, position2, attributeSet);
                if (n == Integer.MAX_VALUE) {
                    n = position.getOffset();
                }
                n2 = position2.getOffset();
            }
            ++n3;
        }
        if (n != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE) {
            return new int[]{n, n2};
        }
        return null;
    }

    private int[] clearImpl() {
        if (!this.marks.isEmpty()) {
            int n = ((Position)this.marks.get(0)).getOffset();
            int n2 = ((Position)this.marks.get(this.marks.size() - 1)).getOffset();
            this.marks.clear();
            this.attributes.clear();
            return new int[]{n, n2};
        }
        return null;
    }

    private int indexBeforeOffset(int n, int n2, int n3) {
        int n4 = this.findElementIndex(n, n2, n3);
        if (n4 < 0) {
            n4 = -n4 - 1;
            return n4 - 1;
        }
        return n4;
    }

    private int indexBeforeOffset(int n) {
        return this.indexBeforeOffset(n, 0, this.marks.size() - 1);
    }

    private int findElementIndex(int n, int n2, int n3) {
        if (n2 < 0 || n3 > this.marks.size() - 1) {
            throw new IndexOutOfBoundsException("lowIdx = " + n2 + ", highIdx = " + n3 + ", size = " + this.marks.size());
        }
        int n4 = n2;
        int n5 = n3;
        while (n4 <= n5) {
            int n6 = n4 + n5 >> 1;
            int n7 = ((Position)this.marks.get(n6)).getOffset();
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            while (n6 > 0) {
                if (((Position)this.marks.get(--n6)).getOffset() >= n) continue;
                ++n6;
                break;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    private final class Seq
    implements HighlightsSequence {
        private long version;
        private int startOffset;
        private int endOffset;
        private int idx = -1;

        public Seq(long l, int n, int n2) {
            this.version = l;
            this.startOffset = n;
            this.endOffset = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean moveNext() {
            GapList gapList = PositionsBag.this.marks;
            synchronized (gapList) {
                this.checkVersion();
                if (this.idx == -1) {
                    this.idx = PositionsBag.this.indexBeforeOffset(this.startOffset);
                    if (this.idx == -1 && PositionsBag.this.marks.size() > 0) {
                        this.idx = 0;
                    }
                } else {
                    ++this.idx;
                }
                while (this.isIndexValid(this.idx)) {
                    if (PositionsBag.this.attributes.get(this.idx) != null) {
                        return true;
                    }
                    ++this.idx;
                }
                return false;
            }
        }

        public int getStartOffset() {
            GapList gapList = PositionsBag.this.marks;
            synchronized (gapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.max(((Position)PositionsBag.this.marks.get(this.idx)).getOffset(), this.startOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public int getEndOffset() {
            GapList gapList = PositionsBag.this.marks;
            synchronized (gapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return Math.min(((Position)PositionsBag.this.marks.get(this.idx + 1)).getOffset(), this.endOffset);
                }
                throw new NoSuchElementException();
            }
        }

        public AttributeSet getAttributes() {
            GapList gapList = PositionsBag.this.marks;
            synchronized (gapList) {
                assert (this.idx != -1) : "Sequence not initialized, call moveNext() first.";
                this.checkVersion();
                if (this.isIndexValid(this.idx)) {
                    return (AttributeSet)PositionsBag.this.attributes.get(this.idx);
                }
                throw new NoSuchElementException();
            }
        }

        private boolean isIndexValid(int n) {
            return n >= 0 && n + 1 < PositionsBag.this.marks.size() && ((Position)PositionsBag.this.marks.get(n)).getOffset() < this.endOffset && ((Position)PositionsBag.this.marks.get(n + 1)).getOffset() > this.startOffset;
        }

        private void checkVersion() {
            if (PositionsBag.this.version != this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

