/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ModuleUpdate {
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private String codenamebase = null;
    private String specification_version = null;
    private boolean pError = false;
    private boolean l10n = false;
    private boolean fromInstall = false;

    ModuleUpdate(File file, boolean bl) {
        this.fromInstall = bl;
        this.createFromDistribution(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromDistribution(File file) {
        Object object;
        Document document = null;
        Element element = null;
        Element element2 = null;
        JarFile jarFile = null;
        InputStream inputStream = null;
        boolean bl = false;
        String string = null;
        try {
            jarFile = new JarFile(file);
            inputStream = jarFile.getInputStream(jarFile.getEntry("Info/info.xml"));
            object = new InputSource(inputStream);
            document = XMLUtil.parse((InputSource)object, false, false, new ErrorCatcher(), XMLUtil.createAUResolver());
            element = element2 = document.getDocumentElement();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (SAXException sAXException) {
            string = "Bad info : " + file.getAbsolutePath();
            System.out.println(string);
            sAXException.printStackTrace();
            bl = true;
        }
        catch (IOException iOException) {
            string = "Missing info : " + file.getAbsolutePath();
            System.out.println(string);
            iOException.printStackTrace();
            bl = true;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = true;
            }
        }
        if (bl) {
            throw new RuntimeException(string);
        }
        this.setCodenamebase(this.getAttribute(element, ATTR_CODENAMEBASE));
        object = element.getElementsByTagName("l10n");
        if (object.getLength() > 0) {
            this.l10n = true;
            Node node = object.item(0);
            this.setSpecification_version(this.getAttribute(node, "module_spec_version"));
        } else {
            object = element.getElementsByTagName("manifest");
            for (int i = 0; i < object.getLength() && object.item(i).getNodeType() == 1 && object.item(i) instanceof Element; ++i) {
                NamedNodeMap namedNodeMap = object.item(i).getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Attr attr = (Attr)namedNodeMap.item(j);
                    if (attr.getName().equals("OpenIDE-Module")) {
                        this.setCodenamebase(attr.getValue());
                        continue;
                    }
                    if (!attr.getName().equals("OpenIDE-Module-Specification-Version")) continue;
                    this.setSpecification_version(attr.getValue());
                }
            }
        }
    }

    private String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    String getCodenamebase() {
        return this.codenamebase;
    }

    void setCodenamebase(String string) {
        this.codenamebase = string;
    }

    String getSpecification_version() {
        return this.specification_version;
    }

    void setSpecification_version(String string) {
        this.specification_version = string;
    }

    public boolean isL10n() {
        return this.l10n;
    }

    public boolean isFromInstall() {
        return this.fromInstall;
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            ModuleUpdate.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            ModuleUpdate.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            ModuleUpdate.this.pError = true;
        }
    }
}

