/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.beans.PropertyEditor;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.openide.nodes.PropertySupport;

public class Column
extends PropertySupport.ReadWrite {
    private PropertyEditor propertyEditor;
    private ColumnModel columnModel;
    private TreeTable treeTable;

    Column(ColumnModel columnModel, TreeTable treeTable) {
        Character c;
        Class clazz = columnModel.getType() == null ? String.class : columnModel.getType();
        super(columnModel.getID(), clazz, columnModel.getDisplayName(), columnModel.getShortDescription());
        this.columnModel = columnModel;
        this.treeTable = treeTable;
        this.setValue("ComparableColumnTTV", columnModel.isSortable());
        if (columnModel.getType() == null) {
            this.setValue("TreeColumnTTV", Boolean.TRUE);
        }
        if ((c = columnModel.getDisplayedMnemonic()) != null) {
            this.setValue("ColumnMnemonicCharTTV", c);
        }
        this.propertyEditor = columnModel.getPropertyEditor();
    }

    int getColumnWidth() {
        return this.columnModel.getColumnWidth();
    }

    void setColumnWidth(int n) {
        this.columnModel.setColumnWidth(n);
    }

    int getOrderNumber() {
        Object object = this.getValue("OrderNumberTTV");
        if (object == null) {
            return -1;
        }
        return (Integer)object;
    }

    boolean isDefault() {
        return this.columnModel.getType() == null;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object object) {
    }

    public Object getValue(String string) {
        int n;
        if ("OrderNumberTTV".equals(string) && (n = this.columnModel.getCurrentOrderNumber()) != -1) {
            return new Integer(n);
        }
        if ("InvisibleInTreeTableView".equals(string)) {
            return !this.columnModel.isVisible();
        }
        if ("SortingColumnTTV".equals(string)) {
            return this.columnModel.isSorted();
        }
        if ("DescendingOrderTTV".equals(string)) {
            return this.columnModel.isSortedDescending();
        }
        return super.getValue(string);
    }

    public void setValue(String string, Object object) {
        if ("OrderNumberTTV".equals(string)) {
            int n = (Integer)object;
            if (this.treeTable.isCustomizedColumnIndex(this, n)) {
                this.columnModel.setCurrentOrderNumber(n);
            } else if (n != -1 && this.columnModel.getCurrentOrderNumber() != -1) {
                this.columnModel.setCurrentOrderNumber(-1);
            }
        } else if ("InvisibleInTreeTableView".equals(string)) {
            this.columnModel.setVisible((Boolean)object == false);
            this.treeTable.updateColumnWidths();
        } else if ("SortingColumnTTV".equals(string)) {
            this.columnModel.setSorted((Boolean)object);
        } else if ("DescendingOrderTTV".equals(string)) {
            this.columnModel.setSortedDescending((Boolean)object);
        } else {
            super.setValue(string, object);
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }
}

