/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.Column;
import org.netbeans.modules.viewmodel.DefaultColumn;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.windows.TopComponent;

public class TreeTable
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener {
    private ExplorerManager explorerManager;
    private MyTreeTable treeTable;
    Node.Property[] columns;
    private List expandedPaths = new ArrayList();
    private TreeModelRoot currentTreeModelRoot;
    private Models.CompoundModel model;

    public TreeTable() {
        this.setLayout(new BorderLayout());
        this.treeTable = new MyTreeTable();
        this.treeTable.setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)this.treeTable), "Center");
        this.treeTable.getTree().addTreeExpansionListener(this);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)false));
    }

    public void setModel(Models.CompoundModel compoundModel) {
        this.model = compoundModel;
        if (this.currentTreeModelRoot != null) {
            this.currentTreeModelRoot.destroy();
        }
        List list = this.treeTable.getExpandedPaths();
        this.saveWidths();
        if (compoundModel == null) {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
            return;
        }
        this.columns = this.createColumns(compoundModel);
        this.currentTreeModelRoot = new TreeModelRoot(compoundModel, this);
        TreeModelNode treeModelNode = this.currentTreeModelRoot.getRootNode();
        this.getExplorerManager().setRootContext((Node)treeModelNode);
        this.treeTable.setProperties(this.columns);
        this.updateColumnWidths();
        if (list.size() > 0) {
            this.expandedPaths = list;
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (topComponent == null) {
            return;
        }
        if (string.equals("currentNodes")) {
            ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)this.equalNodes());
        } else if (string.equals("selectedNodes")) {
            topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = Visualizer.findNode((Object)treeExpansionEvent.getPath().getLastPathComponent()).getLookup().lookup(Object.class);
        this.model.nodeExpanded(object);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        Object object = Visualizer.findNode((Object)treeExpansionEvent.getPath().getLastPathComponent()).getLookup().lookup(Object.class);
        this.model.nodeCollapsed(object);
    }

    private boolean equalNodes() {
        Node[] nodeArray;
        Node[] nodeArray2 = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray2 == (nodeArray = this.getExplorerManager().getSelectedNodes())) {
            return true;
        }
        if (nodeArray2 == null || nodeArray == null) {
            return false;
        }
        if (nodeArray2.length != nodeArray.length) {
            return false;
        }
        int n = nodeArray2.length;
        for (int i = 0; i < n; ++i) {
            if (nodeArray2[i].equals((Object)nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    private Node.Property[] createColumns(Models.CompoundModel compoundModel) {
        ColumnModel[] columnModelArray = compoundModel.getColumns();
        int n = columnModelArray.length;
        Column[] columnArray = new Column[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            columnArray[i] = new Column(columnModelArray[i], this);
            if (columnModelArray[i].getType() != null) continue;
            bl = false;
        }
        if (!bl) {
            return columnArray;
        }
        PropertySupport.ReadWrite[] readWriteArray = new PropertySupport.ReadWrite[columnArray.length + 1];
        System.arraycopy(columnArray, 0, readWriteArray, 1, columnArray.length);
        readWriteArray[0] = new DefaultColumn();
        return readWriteArray;
    }

    boolean isCustomizedColumnIndex(Column column, int n) {
        if (n == -1) {
            return false;
        }
        int n2 = 0;
        int n3 = this.columns.length;
        int n4 = 0;
        while (n4 < n3 && (Boolean.TRUE.equals(this.columns[n4].getValue("InvisibleInTreeTableView")) || column != this.columns[n4])) {
            ++n4;
            ++n2;
        }
        return n2 != n;
    }

    void updateColumnWidths() {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                n2 = column.getColumnWidth();
                this.treeTable.setTreePreferredWidth(n2);
                continue;
            }
            n2 = column.getOrderNumber();
            if (n2 == -1) continue;
            int n3 = column.getColumnWidth();
            this.treeTable.setTableColumnPreferredWidth(n2, n3);
        }
    }

    private void saveWidths() {
        if (this.columns == null) {
            return;
        }
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn;
            if (Boolean.TRUE.equals(this.columns[i].getValue("InvisibleInTreeTableView")) || !(this.columns[i] instanceof Column)) continue;
            Column column = (Column)this.columns[i];
            if (column.isDefault()) {
                TableColumn tableColumn2 = this.treeTable.getTable().getColumnModel().getColumn(0);
                if (tableColumn2 == null) continue;
                int n2 = tableColumn2.getWidth();
                column.setColumnWidth(n2);
                continue;
            }
            int n3 = column.getOrderNumber();
            if (n3 == -1 || (tableColumn = this.treeTable.getTable().getColumnModel().getColumn(n3 + 1)) == null) continue;
            int n4 = tableColumn.getWidth();
            column.setColumnWidth(n4);
        }
    }

    private void expandDefault(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (!this.model.isExpanded(objectArray[i])) continue;
                this.expandNode(objectArray[i]);
                continue;
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeTable.requestFocusInWindow();
    }

    public void addNotify() {
        super.addNotify();
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeNotify() {
        super.removeNotify();
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public boolean isExpanded(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        if (treeModelNode == null) {
            return false;
        }
        return this.treeTable.isExpanded((Node)treeModelNode);
    }

    public void expandNode(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        if (this.treeTable != null && treeModelNode != null) {
            this.treeTable.expandNode((Node)treeModelNode);
        }
    }

    public void collapseNode(Object object) {
        TreeModelNode treeModelNode = this.currentTreeModelRoot.findNode(object);
        this.treeTable.collapseNode((Node)treeModelNode);
    }

    private static class MyTreeTable
    extends TreeTableView {
        MyTreeTable() {
            this.treeTable.setShowHorizontalLines(true);
            this.treeTable.setShowVerticalLines(false);
        }

        JTable getTable() {
            return this.treeTable;
        }

        JTree getTree() {
            return this.tree;
        }

        public List getExpandedPaths() {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
            TreeNode treeNode = Visualizer.findVisualizer((Node)explorerManager.getRootContext());
            TreePath treePath = new TreePath(treeNode);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
            if (enumeration == null) {
                return arrayList;
            }
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = enumeration.nextElement();
                Node node = Visualizer.findNode((Object)treePath2.getLastPathComponent());
                String[] stringArray = NodeOp.createPath((Node)node, (Node)explorerManager.getRootContext());
                arrayList.add(stringArray);
            }
            return arrayList;
        }

        public void expandNodes(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                TreePath treePath = this.stringPath2TreePath(stringArray);
                if (treePath == null) continue;
                this.showPath(treePath);
            }
        }

        private TreePath stringPath2TreePath(String[] stringArray) {
            ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
            try {
                Node node = NodeOp.findPath((Node)explorerManager.getRootContext(), (String[])stringArray);
                Object[] objectArray = new TreeNode[stringArray.length + 1];
                for (int i = stringArray.length; i >= 0; --i) {
                    objectArray[i] = Visualizer.findVisualizer((Node)node);
                    node = node.getParentNode();
                }
                return new TreePath(objectArray);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                return null;
            }
        }
    }
}

