/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.nbbridge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LanguageManager;
import org.netbeans.modules.lexer.nbbridge.LanguagesEmbeddingMap;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.openide.filesystems.FileObject;

public class MimeLookupFolderInfo
implements Class2LayerFolder,
InstanceProvider {
    private static final Logger LOG = Logger.getLogger(MimeLookupFolderInfo.class.getName());

    public Class getClazz() {
        return LanguagesEmbeddingMap.class;
    }

    public String getLayerFolderName() {
        return "languagesEmbeddingMap";
    }

    public InstanceProvider getInstanceProvider() {
        return this;
    }

    public Object createInstance(List list) {
        HashMap<String, LanguageEmbedding<? extends TokenId>> hashMap = new HashMap<String, LanguageEmbedding<? extends TokenId>>();
        for (Object e : list) {
            assert (e instanceof FileObject) : "fileObjectList should contain FileObjects and not " + e;
            FileObject fileObject = (FileObject)e;
            try {
                Object[] objectArray = this.parseFile(fileObject);
                String string = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                int n2 = (Integer)objectArray[2];
                if (this.isMimeTypeValid(string)) {
                    Language language = LanguageManager.getInstance().findLanguage(string);
                    if (language != null) {
                        hashMap.put(fileObject.getName(), (LanguageEmbedding<? extends TokenId>)LanguageEmbedding.create((Language)language, (int)n, (int)n2));
                        continue;
                    }
                    LOG.warning("Can't find Language for mime type '" + string + "', ignoring.");
                    continue;
                }
                LOG.log(Level.WARNING, "Ignoring invalid mime type '" + string + "' from: " + fileObject.getPath());
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't read language embedding definition from: " + fileObject.getPath());
            }
        }
        return new LanguagesEmbeddingMap(hashMap);
    }

    private boolean isMimeTypeValid(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return false;
        }
        return string.indexOf(47, n + 1) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] parseFile(FileObject fileObject) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream()));
        try {
            String string;
            while (null != (string = bufferedReader.readLine())) {
                string.trim();
                if (string.length() == 0) continue;
                String[] stringArray = string.split(",");
                Object[] objectArray = new Object[]{stringArray[0], stringArray.length > 1 ? this.toInt(stringArray[1], "Ignoring invalid start-skip-length '{0}' in " + fileObject.getPath()) : 0, stringArray.length > 2 ? this.toInt(stringArray[2], "Ignoring invalid end-skip-length '{0}' in " + fileObject.getPath()) : 0};
                return objectArray;
            }
            Object[] objectArray = null;
            return objectArray;
        }
        finally {
            bufferedReader.close();
        }
    }

    private int toInt(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, MessageFormat.format(string2, string), numberFormatException);
            return 0;
        }
    }
}

