/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import org.netbeans.modules.openide.explorer.ExternalDragAndDrop;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExplorerActionsImpl {
    private final CopyCutActionPerformer copyActionPerformer = new CopyCutActionPerformer(true);
    private final CopyCutActionPerformer cutActionPerformer = new CopyCutActionPerformer(false);
    private final DeleteActionPerformer deleteActionPerformerConfirm = new DeleteActionPerformer(true);
    private final DeleteActionPerformer deleteActionPerformerNoConfirm = new DeleteActionPerformer(false);
    private final OwnPaste pasteActionPerformer = new OwnPaste();
    private ActionStateUpdater actionStateUpdater;
    private ExplorerManager manager;

    ExplorerActionsImpl() {
    }

    final Action copyAction() {
        return this.copyActionPerformer;
    }

    final Action cutAction() {
        return this.cutActionPerformer;
    }

    final Action deleteAction(boolean bl) {
        return bl ? this.deleteActionPerformerConfirm : this.deleteActionPerformerNoConfirm;
    }

    final Action pasteAction() {
        return this.pasteActionPerformer;
    }

    public synchronized void attach(ExplorerManager explorerManager) {
        if (this.manager != null) {
            this.detach();
        }
        this.manager = explorerManager;
        this.actionStateUpdater = new ActionStateUpdater();
        this.manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.actionStateUpdater, (Object)this.manager));
        Clipboard clipboard = ExplorerActionsImpl.getClipboard();
        if (clipboard instanceof ExClipboard) {
            ExClipboard exClipboard = (ExClipboard)clipboard;
            exClipboard.addClipboardListener((ClipboardListener)WeakListeners.create(ClipboardListener.class, (EventListener)this.actionStateUpdater, (Object)exClipboard));
        }
        this.updateActions();
    }

    public synchronized void detach() {
        if (this.manager == null) {
            return;
        }
        this.actionStateUpdater = null;
        this.stopActions();
        this.manager = null;
    }

    private void stopActions() {
        if (this.copyActionPerformer != null) {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformerConfirm.setEnabled(false);
            this.deleteActionPerformerNoConfirm.setEnabled(false);
            this.pasteActionPerformer.setEnabled(false);
        }
    }

    private void updateActions() {
        int n;
        if (this.manager == null) {
            return;
        }
        Node[] nodeArray = this.manager.getSelectedNodes();
        int n2 = n = nodeArray != null ? nodeArray.length : 0;
        if (n > 0) {
            int n3;
            boolean bl = false;
            if (n > 1) {
                HashMap<Node, Object> hashMap = new HashMap<Node, Object>(101);
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.checkParents(nodeArray[n3], hashMap)) continue;
                    bl = true;
                    break;
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canCopy()) continue;
                this.copyActionPerformer.setEnabled(false);
                break;
            }
            if (n3 == n) {
                this.copyActionPerformer.setEnabled(true);
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canCut()) continue;
                this.cutActionPerformer.setEnabled(false);
                break;
            }
            if (n3 == n) {
                this.cutActionPerformer.setEnabled(true);
            }
            for (n3 = 0; n3 < n; ++n3) {
                if (!bl && nodeArray[n3].canDestroy()) continue;
                this.deleteActionPerformerConfirm.setEnabled(false);
                this.deleteActionPerformerNoConfirm.setEnabled(false);
                break;
            }
            if (n3 == n) {
                this.deleteActionPerformerConfirm.setEnabled(true);
                this.deleteActionPerformerNoConfirm.setEnabled(true);
            }
        } else {
            this.copyActionPerformer.setEnabled(false);
            this.cutActionPerformer.setEnabled(false);
            this.deleteActionPerformerConfirm.setEnabled(false);
            this.deleteActionPerformerNoConfirm.setEnabled(false);
        }
        this.updatePasteAction(nodeArray);
    }

    private boolean checkParents(Node node, HashMap<Node, Object> hashMap) {
        if (hashMap.get(node) != null) {
            return false;
        }
        hashMap.put(node, this);
        do {
            if ((node = node.getParentNode()) != null) continue;
            return true;
        } while (hashMap.put(node, node) != this);
        return false;
    }

    private void updatePasteAction(Node[] nodeArray) {
        ExplorerManager explorerManager = this.manager;
        if (explorerManager == null) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        if (nodeArray != null && nodeArray.length > 1) {
            this.pasteActionPerformer.setPasteTypes(null);
            return;
        }
        Node node = explorerManager.getExploredContext();
        Node[] nodeArray2 = explorerManager.getSelectedNodes();
        if (nodeArray2 != null && nodeArray2.length == 1) {
            node = nodeArray2[0];
        }
        if (node != null) {
            Transferable transferable = ExplorerActionsImpl.getClipboard().getContents(this);
            this.updatePasteTypes(transferable, node);
        }
    }

    private void updatePasteTypes(Transferable transferable, Node node) {
        if (transferable != null) {
            PasteType[] pasteTypeArray;
            PasteType[] pasteTypeArray2 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferable);
            if (pasteTypeArray.length != 0) {
                this.pasteActionPerformer.setPasteTypes(pasteTypeArray);
                return;
            }
            if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
                try {
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                    int n = multiTransferObject.getCount();
                    boolean bl = true;
                    Transferable[] transferableArray = new Transferable[n];
                    PasteType[] pasteTypeArray3 = new PasteType[n];
                    for (int i = 0; i < n; ++i) {
                        transferableArray[i] = multiTransferObject.getTransferableAt(i);
                        PasteType[] pasteTypeArray4 = pasteTypeArray = node == null ? new PasteType[]{} : node.getPasteTypes(transferableArray[i]);
                        if (pasteTypeArray.length == 0) {
                            bl = false;
                            break;
                        }
                        pasteTypeArray3[i] = pasteTypeArray[0];
                    }
                    if (bl) {
                        PasteType[] pasteTypeArray5 = new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray3)};
                        this.pasteActionPerformer.setPasteTypes(pasteTypeArray5);
                        return;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.pasteActionPerformer.setPasteTypes(null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionsState() {
        ActionStateUpdater actionStateUpdater;
        ExplorerActionsImpl explorerActionsImpl = this;
        synchronized (explorerActionsImpl) {
            actionStateUpdater = this.actionStateUpdater;
        }
        if (actionStateUpdater != null) {
            actionStateUpdater.update();
        }
    }

    private class ActionStateUpdater
    implements PropertyChangeListener,
    ClipboardListener,
    ActionListener,
    Runnable {
        private final Timer timer = new FixIssue29405Timer(150, this);
        private boolean planned;

        ActionStateUpdater() {
            this.timer.setCoalesce(true);
            this.timer.setRepeats(false);
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.timer.restart();
            this.planned = true;
        }

        public void clipboardChanged(ClipboardEvent clipboardEvent) {
            if (!clipboardEvent.isConsumed()) {
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        public void run() {
            ExplorerManager explorerManager = ExplorerActionsImpl.this.manager;
            if (explorerManager != null) {
                ExplorerActionsImpl.this.updatePasteAction(explorerManager.getSelectedNodes());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ExplorerActionsImpl.this.updateActions();
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                this.timer.stop();
                this.planned = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            boolean bl;
            ActionStateUpdater actionStateUpdater = this;
            synchronized (actionStateUpdater) {
                bl = this.planned;
            }
            if (bl) {
                this.timer.stop();
                ExplorerActionsImpl.this.updateActions();
            }
        }
    }

    private class CopyCutActionPerformer
    extends AbstractAction {
        private boolean copyCut;

        public CopyCutActionPerformer(boolean bl) {
            this.copyCut = bl;
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Transferable[] transferableArray;
            Transferable transferable = null;
            Node[] nodeArray = ExplorerActionsImpl.this.manager.getSelectedNodes();
            if (nodeArray.length != 1) {
                transferableArray = new Transferable[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    transferableArray[i] = this.getTransferableOwner(nodeArray[i]);
                    if (transferableArray[i] != null) continue;
                    return;
                }
                transferable = ExternalDragAndDrop.maybeAddExternalFileDnd(new ExTransferable.Multi(transferableArray));
            } else {
                transferable = this.getTransferableOwner(nodeArray[0]);
            }
            if (transferable != null) {
                transferableArray = ExplorerActionsImpl.getClipboard();
                transferableArray.setContents(transferable, new StringSelection(""));
            }
        }

        private Transferable getTransferableOwner(Node node) {
            try {
                return this.copyCut ? node.clipboardCopy() : node.clipboardCut();
            }
            catch (IOException iOException) {
                Logger.getLogger(ExplorerActionsImpl.class.getName()).log(Level.WARNING, null, iOException);
                return null;
            }
        }
    }

    private class DeleteActionPerformer
    extends AbstractAction
    implements Runnable {
        private boolean confirmDelete;

        DeleteActionPerformer(boolean bl) {
            this.confirmDelete = bl;
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = ExplorerActionsImpl.this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            if (!this.confirmDelete || this.doConfirm(nodeArray)) {
                try {
                    if (ExplorerActionsImpl.this.manager != null) {
                        ExplorerActionsImpl.this.manager.setSelectedNodes(new Node[0]);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.doDestroy(nodeArray);
                Mutex.EVENT.readAccess((Runnable)this);
            }
        }

        public void run() {
            this.setEnabled(false);
        }

        private boolean doConfirm(Node[] nodeArray) {
            String string;
            String string2;
            boolean bl = true;
            for (int i = 0; i < nodeArray.length; ++i) {
                if (Boolean.TRUE.equals(nodeArray[i].getValue("customDelete"))) continue;
                bl = false;
                break;
            }
            if (bl) {
                return true;
            }
            if (nodeArray.length == 1) {
                string2 = NbBundle.getMessage(ExplorerActionsImpl.class, (String)"MSG_ConfirmDeleteObject", (Object)nodeArray[0].getDisplayName());
                string = NbBundle.getMessage(ExplorerActionsImpl.class, (String)"MSG_ConfirmDeleteObjectTitle");
            } else {
                string2 = NbBundle.getMessage(ExplorerActionsImpl.class, (String)"MSG_ConfirmDeleteObjects", (Object)nodeArray.length);
                string = NbBundle.getMessage(ExplorerActionsImpl.class, (String)"MSG_ConfirmDeleteObjectsTitle");
            }
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, string, 0);
            return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation));
        }

        private void doDestroy(Node[] nodeArray) {
            for (int i = 0; i < nodeArray.length; ++i) {
                try {
                    nodeArray[i].destroy();
                    continue;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static class FixIssue29405Timer
    extends Timer {
        private boolean running;

        public FixIssue29405Timer(int n, ActionListener actionListener) {
            super(n, actionListener);
        }

        public void restart() {
            super.restart();
            this.running = true;
        }

        public void stop() {
            this.running = false;
            super.stop();
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    private static class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            for (int i = 0; i < n; ++i) {
                Transferable transferable = this.p[i].paste();
                transferableArray[i] = transferable != null ? transferable : this.t[i];
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }

    private class OwnPaste
    extends AbstractAction {
        private PasteType[] pasteTypes;

        OwnPaste() {
        }

        public boolean isEnabled() {
            ExplorerActionsImpl.this.updateActionsState();
            return super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPasteTypes(PasteType[] pasteTypeArray) {
            OwnPaste ownPaste = this;
            synchronized (ownPaste) {
                this.pasteTypes = pasteTypeArray;
            }
            this.setEnabled(pasteTypeArray != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PasteType[] pasteTypeArray = this.pasteTypes;
            throw new IllegalStateException("Should not be invoked at all. Paste types: " + (pasteTypeArray == null ? null : Arrays.asList(pasteTypeArray)));
        }

        public Object getValue(String string) {
            ExplorerActionsImpl.this.updateActionsState();
            if ("delegates".equals(string)) {
                return this.pasteTypes;
            }
            return super.getValue(string);
        }
    }
}

