/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

class CopySupport {
    private static final String flavorMimeType = "application/x-form-metacomponent;class=java.lang.Object";
    private static DataFlavor copyFlavor;
    private static DataFlavor cutFlavor;

    CopySupport() {
    }

    static DataFlavor getComponentCopyFlavor() {
        if (copyFlavor == null) {
            copyFlavor = new DataFlavor(flavorMimeType, "COMPONENT_COPY_FLAVOR");
        }
        return copyFlavor;
    }

    static DataFlavor getComponentCutFlavor() {
        if (cutFlavor == null) {
            cutFlavor = new DataFlavor(flavorMimeType, "COMPONENT_CUT_FLAVOR");
        }
        return cutFlavor;
    }

    public static boolean canPasteCut(RADComponent rADComponent, FormModel formModel, RADComponent rADComponent2) {
        if (!rADComponent.isInModel()) {
            return false;
        }
        if (rADComponent.getFormModel() != formModel) {
            return true;
        }
        if (rADComponent2 == null) {
            return formModel.getModelContainer().getIndexOf(rADComponent) < 0;
        }
        return rADComponent != rADComponent2 && rADComponent.getParentComponent() != rADComponent2 && !rADComponent.isParentComponent(rADComponent2);
    }

    static String getCopiedBeanClassName(FileObject fileObject) {
        return BeanInstaller.findJavaBeanName(fileObject);
    }

    static ClassSource getCopiedBeanClassSource(Transferable transferable) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)NodeTransfer.cookie((Transferable)transferable, (int)1, DataObject.class);
        FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
        if (fileObject == null) {
            return null;
        }
        String string = CopySupport.getCopiedBeanClassName(fileObject);
        if (string == null) {
            return null;
        }
        return ClassPathUtils.getProjectClassSource(fileObject, string);
    }

    static class ClassPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private ClassSource classSource;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public ClassPaste(Transferable transferable, ClassSource classSource, FormModel formModel, RADComponent rADComponent) {
            this.transferable = transferable;
            this.classSource = classSource;
            this.targetForm = formModel;
            this.targetComponent = rADComponent;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return this.transferable;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            if (this.classSource.getClassName().indexOf(46) == -1 && !FormJavaSource.isInDefaultPackage(this.targetForm)) {
                String string = FormUtils.getBundleString("MSG_DefaultPackageBean");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                this.targetForm.getComponentCreator().createComponent(this.classSource, this.targetComponent, null);
            }
            return this.transferable;
        }
    }

    static class RADPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public RADPaste(Transferable transferable, FormModel formModel, RADComponent rADComponent) {
            this.transferable = transferable;
            this.targetForm = formModel;
            this.targetComponent = rADComponent;
        }

        public String getName() {
            return FormUtils.getBundleString(this.isComponentCut() ? "CTL_CutPaste" : "CTL_CopyPaste");
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException mutexException) {
                Exception exception = mutexException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Transferable doPaste() throws IOException {
            Object object;
            Object object2;
            boolean bl = this.isComponentCut();
            RADComponent rADComponent = this.getSourceComponent(bl);
            if (rADComponent == null) {
                return null;
            }
            if (!bl || rADComponent.getCodeExpression() == null) {
                this.targetForm.getComponentCreator().copyComponent(rADComponent, this.targetComponent);
                return null;
            }
            FormModel formModel = rADComponent.getFormModel();
            if (formModel != this.targetForm || this.targetComponent != null && !rADComponent.getClass().isAssignableFrom(this.targetComponent.getClass())) {
                if (this.targetForm.getComponentCreator().copyComponent(rADComponent, this.targetComponent) == null) return null;
                RADComponentNode rADComponentNode = rADComponent.getNodeReference();
                if (rADComponentNode == null) throw new IllegalStateException();
                rADComponentNode.destroy();
                return ExTransferable.EMPTY;
            }
            if (!CopySupport.canPasteCut(rADComponent, this.targetForm, this.targetComponent) || !MetaComponentCreator.canAddComponent(rADComponent.getBeanClass(), this.targetComponent)) {
                return null;
            }
            formModel.startCompoundEdit(true);
            boolean bl2 = false;
            LayoutModel layoutModel = formModel.getLayoutModel();
            LayoutComponent layoutComponent = null;
            if (layoutModel != null && (layoutComponent = layoutModel.getLayoutComponent(rADComponent.getId())) != null) {
                bl2 = true;
                object2 = layoutModel.getChangeMark();
                object = layoutModel.getUndoableEdit();
                boolean bl3 = true;
                boolean bl4 = (!(this.targetComponent instanceof RADVisualContainer) || ((RADVisualContainer)this.targetComponent).getLayoutSupport() != null) && !layoutComponent.isLayoutContainer();
                try {
                    layoutModel.removeComponent(rADComponent.getId(), bl4);
                    bl3 = false;
                }
                finally {
                    if (!object2.equals(layoutModel.getChangeMark())) {
                        formModel.addUndoableEdit((UndoableEdit)object);
                    }
                    if (bl3) {
                        formModel.forceUndoOfCompoundEdit();
                    }
                }
            }
            formModel.removeComponent(rADComponent, false);
            if (rADComponent instanceof RADVisualComponent && this.targetComponent instanceof RADVisualContainer) {
                object2 = (RADVisualComponent)rADComponent;
                object = (RADVisualContainer)this.targetComponent;
                if (((RADVisualContainer)object).getLayoutSupport() == null) {
                    this.targetForm.addComponent((RADComponent)object2, (ComponentContainer)object, false);
                    LayoutComponent layoutComponent2 = layoutModel.getLayoutComponent(((RADComponent)object).getId());
                    Object object3 = layoutModel.getChangeMark();
                    UndoableEdit undoableEdit = layoutModel.getUndoableEdit();
                    boolean bl5 = true;
                    if (layoutComponent == null) {
                        layoutComponent = new LayoutComponent(((RADComponent)object2).getId(), MetaComponentCreator.shouldBeLayoutContainer((RADComponent)object2));
                    }
                    bl2 = true;
                    try {
                        layoutModel.addNewComponent(layoutComponent, layoutComponent2, null);
                        bl5 = false;
                    }
                    finally {
                        if (!object3.equals(layoutModel.getChangeMark())) {
                            formModel.addUndoableEdit(undoableEdit);
                        }
                        if (bl5) {
                            formModel.forceUndoOfCompoundEdit();
                        }
                    }
                } else {
                    try {
                        this.targetForm.addVisualComponent((RADVisualComponent)object2, (RADVisualContainer)object, ((RADVisualContainer)object).getLayoutSupport().getStoredConstraints((RADVisualComponent)object2), false);
                    }
                    catch (RuntimeException runtimeException) {
                        ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
                        return this.transferable;
                    }
                }
            } else {
                object2 = this.targetComponent instanceof ComponentContainer ? (ComponentContainer)((Object)this.targetComponent) : null;
                this.targetForm.addComponent(rADComponent, (ComponentContainer)object2, false);
            }
            if (!bl2) return ExTransferable.EMPTY;
            ((RADVisualComponent)rADComponent).resetConstraintsProperties();
            return ExTransferable.EMPTY;
        }

        boolean isComponentCut() {
            return this.transferable.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        }

        RADComponent getSourceComponent(boolean bl) throws IOException {
            RADComponent rADComponent = null;
            try {
                Object object = this.transferable.getTransferData(bl ? CopySupport.getComponentCutFlavor() : CopySupport.getComponentCopyFlavor());
                if (object instanceof RADComponent) {
                    rADComponent = (RADComponent)object;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return rADComponent;
        }
    }

    static class RADTransferable
    implements Transferable {
        private RADComponent radComponent;
        private DataFlavor[] flavors;

        RADTransferable(DataFlavor dataFlavor, RADComponent rADComponent) {
            this(new DataFlavor[]{dataFlavor}, rADComponent);
        }

        RADTransferable(DataFlavor[] dataFlavorArray, RADComponent rADComponent) {
            this.flavors = dataFlavorArray;
            this.radComponent = rADComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (this.flavors[i] != dataFlavor) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if ("x-form-metacomponent".equals(dataFlavor.getSubType())) {
                return this.radComponent;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

