/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.CustomCodeData;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomCodeView
extends JPanel {
    private CustomCodeData codeData;
    private int lastLocalModifiers = -1;
    private int lastFieldModifiers = -1;
    private boolean changed;
    private Listener controller;
    private DocumentL docListener;
    private boolean ignoreComboAction;
    private Map<CustomCodeData.CodeCategory, EditBlockInfo[]> editBlockInfos;
    private Map<CustomCodeData.CodeCategory, GuardBlockInfo[]> guardBlockInfos;
    private Object documentContext;
    private JComboBox accessCombo;
    private JComboBox componentCombo;
    private JEditorPane declareCodeEditor;
    private JCheckBox finalCheckBox;
    private JLabel infoLabel;
    private JEditorPane initCodeEditor;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton renameButton;
    private JCheckBox staticCheckBox;
    private JCheckBox transientCheckBox;
    private JComboBox variableCombo;
    private JCheckBox volatileCheckBox;
    private JPanel initGutter;
    private JPanel declareGutter;
    private static final boolean[] variableValues = new boolean[]{false, true};
    private static final String[] variableStrings = new String[]{NbBundle.getMessage(CustomCodeView.class, (String)"CTL_VariableCombo_Field"), NbBundle.getMessage(CustomCodeView.class, (String)"CTL_VariableCombo_Local")};
    private static final int[] accessValues = new int[]{2, 0, 4, 1};
    private static final String[] accessStrings = new String[]{"private", NbBundle.getMessage(CustomCodeView.class, (String)"CTL_AccessCombo_package_private"), "protected", "public"};

    CustomCodeView(Listener listener, Object object) {
        this.controller = listener;
        this.documentContext = object;
        this.initComponents();
        this.variableCombo.setModel(new DefaultComboBoxModel<String>(variableStrings));
        this.accessCombo.setModel(new DefaultComboBoxModel<String>(accessStrings));
        HashMap<Component, Position> hashMap = new HashMap<Component, Position>();
        this.initGutter = new JPanel();
        this.initGutter.setLayout(new GutterLayout(this.initCodeEditor, hashMap));
        this.declareGutter = new JPanel();
        this.declareGutter.setLayout(new GutterLayout(this.declareCodeEditor, hashMap));
        this.jScrollPane1.setRowHeaderView(this.initGutter);
        this.jScrollPane2.setRowHeaderView(this.declareGutter);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initCodeEditor.requestFocusInWindow();
    }

    boolean isChanged() {
        return this.changed;
    }

    void setComponentNames(String[] stringArray) {
        this.componentCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    void setCodeData(String string, CustomCodeData customCodeData) {
        int n;
        if (this.codeData != null) {
            this.initCodeEditor.getDocument().removeDocumentListener(this.docListener);
            this.declareCodeEditor.getDocument().removeDocumentListener(this.docListener);
            this.initCodeEditor.setContentType("text/plain");
            this.declareCodeEditor.setContentType("text/plain");
            this.initGutter.removeAll();
            this.declareGutter.removeAll();
            this.revalidate();
            this.repaint();
        }
        if (this.editBlockInfos != null) {
            this.editBlockInfos.clear();
            this.guardBlockInfos.clear();
        } else {
            this.editBlockInfos = new HashMap<CustomCodeData.CodeCategory, EditBlockInfo[]>();
            this.guardBlockInfos = new HashMap<CustomCodeData.CodeCategory, GuardBlockInfo[]>();
        }
        this.initCodeEditor.setContentType("text/x-java");
        this.declareCodeEditor.setContentType("text/x-java");
        this.codeData = customCodeData;
        this.selectInComboBox(this.componentCombo, string);
        this.buildCodeView(CustomCodeData.CodeCategory.CREATE_AND_INIT);
        this.buildCodeView(CustomCodeData.CodeCategory.DECLARATION);
        CustomCodeData.VariableDeclaration variableDeclaration = customCodeData.getDeclarationData();
        boolean bl = variableDeclaration.local;
        for (n = 0; n < variableValues.length; ++n) {
            if (variableValues[n] != bl) continue;
            this.selectInComboBox(this.variableCombo, variableStrings[n]);
            break;
        }
        n = variableDeclaration.modifiers;
        int n2 = n & 7;
        for (int i = 0; i < accessValues.length; ++i) {
            if (accessValues[i] != n2) continue;
            this.selectInComboBox(this.accessCombo, accessStrings[i]);
            break;
        }
        this.staticCheckBox.setSelected((n & 8) == 8);
        this.finalCheckBox.setSelected((n & 0x10) == 16);
        this.transientCheckBox.setSelected((n & 0x80) == 128);
        this.volatileCheckBox.setSelected((n & 0x40) == 64);
        this.accessCombo.setEnabled(!bl);
        this.staticCheckBox.setEnabled(!bl);
        this.transientCheckBox.setEnabled(!bl);
        this.volatileCheckBox.setEnabled(!bl);
        if (bl) {
            this.lastLocalModifiers = n;
        } else {
            this.lastFieldModifiers = n;
        }
        this.changed = false;
        if (this.docListener == null) {
            this.docListener = new DocumentL();
        }
        this.initCodeEditor.getDocument().addDocumentListener(this.docListener);
        this.declareCodeEditor.getDocument().addDocumentListener(this.docListener);
        this.initCodeEditor.getDocument().putProperty("stream", this.documentContext);
        this.declareCodeEditor.getDocument().putProperty("stream", this.documentContext);
        this.initCodeEditor.setCaretPosition(0);
        this.declareCodeEditor.setCaretPosition(0);
    }

    private void buildCodeView(CustomCodeData.CodeCategory codeCategory) {
        this.editBlockInfos.put(codeCategory, new EditBlockInfo[this.codeData.getEditableBlockCount(codeCategory)]);
        int n = this.codeData.getGuardedBlockCount(codeCategory);
        this.guardBlockInfos.put(codeCategory, new GuardBlockInfo[n]);
        try {
            for (int i = 0; i < n; ++i) {
                this.addEditableCode(codeCategory, i);
                this.addGuardedCode(codeCategory, i);
            }
            if (n > 0) {
                this.addEditableCode(codeCategory, n);
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        this.getEditor(codeCategory).setEnabled(n > 0);
    }

    private void addEditableCode(CustomCodeData.CodeCategory codeCategory, int n) throws BadLocationException {
        Object object;
        int n2;
        Document document = this.getDocument(codeCategory);
        CustomCodeData.EditableBlock editableBlock = this.codeData.getEditableBlock(codeCategory, n);
        boolean bl = n + 1 == this.codeData.getEditableBlockCount(codeCategory);
        LinkedList<EditableLine> linkedList = new LinkedList<EditableLine>();
        int n3 = document.getLength();
        boolean bl2 = false;
        CustomCodeData.CodeEntry[] codeEntryArray = editableBlock.getEntries();
        for (n2 = 0; n2 < codeEntryArray.length; ++n2) {
            object = codeEntryArray[n2];
            String string = ((CustomCodeData.CodeEntry)object).getCode();
            if (string == null) continue;
            int n4 = 0;
            int n5 = string.length();
            for (int i = 0; i < n5; ++i) {
                char c = string.charAt(i);
                if (c != '\n' && i + 1 != n5) continue;
                if (bl2) {
                    document.insertString(document.getLength(), "\n", null);
                }
                boolean bl3 = bl && n2 + 1 == codeEntryArray.length && i + 1 == n5;
                bl2 = c != '\n' && !bl3;
                int n6 = c == '\n' && bl3 ? i : i + 1;
                int n7 = document.getLength();
                document.insertString(n7, string.substring(n4, n6), null);
                Position position = NbDocument.createPosition((Document)document, (int)n7, (Position.Bias)Position.Bias.Backward);
                linkedList.add(new EditableLine(position, editableBlock, n2, linkedList));
                n4 = i + 1;
            }
        }
        if (linkedList.size() > 0) {
            if (bl2) {
                document.insertString(document.getLength(), "\n", null);
            }
        } else {
            n2 = document.getLength();
            if (!bl) {
                document.insertString(n2, "\n", null);
            }
            object = NbDocument.createPosition((Document)document, (int)n2, (Position.Bias)Position.Bias.Backward);
            linkedList.add(new EditableLine((Position)object, editableBlock, editableBlock.getPreferredEntryIndex(), linkedList));
        }
        this.updateGutterComponents(linkedList, document, n3, document.getLength());
        EditBlockInfo editBlockInfo = new EditBlockInfo();
        editBlockInfo.position = ((EditableLine)linkedList.get(0)).getPosition();
        editBlockInfo.lines = linkedList;
        this.getEditInfos((CustomCodeData.CodeCategory)codeCategory)[n] = editBlockInfo;
    }

    private void addGuardedCode(CustomCodeData.CodeCategory codeCategory, int n) throws BadLocationException {
        Object object;
        StyledDocument styledDocument = (StyledDocument)this.getDocument(codeCategory);
        CustomCodeData.GuardedBlock guardedBlock = this.codeData.getGuardedBlock(codeCategory, n);
        GuardBlockInfo guardBlockInfo = new GuardBlockInfo();
        int n2 = styledDocument.getLength();
        if (guardedBlock.isCustomized()) {
            object = guardedBlock.getCustomCode();
            styledDocument.insertString(n2, (String)object, null);
            if (!((String)object).endsWith("\n")) {
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
            }
            int n3 = guardedBlock.getHeaderLength();
            int n4 = guardedBlock.getFooterLength();
            NbDocument.markGuarded((StyledDocument)styledDocument, (int)n2, (int)n3);
            NbDocument.markGuarded((StyledDocument)styledDocument, (int)(styledDocument.getLength() - n4), (int)n4);
            guardBlockInfo.customized = true;
        } else {
            object = guardedBlock.getDefaultCode();
            styledDocument.insertString(n2, (String)object, null);
            if (!((String)object).endsWith("\n")) {
                styledDocument.insertString(styledDocument.getLength(), "\n", null);
            }
            NbDocument.markGuarded((StyledDocument)styledDocument, (int)n2, (int)(styledDocument.getLength() - n2));
        }
        guardBlockInfo.position = object = NbDocument.createPosition((Document)styledDocument, (int)n2, (Position.Bias)Position.Bias.Forward);
        this.getGuardInfos((CustomCodeData.CodeCategory)codeCategory)[n] = guardBlockInfo;
        if (guardedBlock.isCustomizable()) {
            String[] stringArray = new String[]{NbBundle.getMessage(CustomCodeView.class, (String)"CTL_GuardCombo_Default"), guardedBlock.getCustomEntry().getDisplayName()};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            if (guardedBlock.isCustomized()) {
                this.selectInComboBox(jComboBox, stringArray[1]);
                jComboBox.setToolTipText(guardedBlock.getCustomEntry().getToolTipText());
            } else {
                this.selectInComboBox(jComboBox, stringArray[0]);
                jComboBox.setToolTipText(NbBundle.getMessage(CustomCodeView.class, (String)"CTL_GuardCombo_Default_Hint"));
            }
            jComboBox.addActionListener(new GuardSwitchL(codeCategory, n));
            this.getGutter(styledDocument).add(jComboBox, object);
        }
    }

    CustomCodeData retreiveCodeData() {
        int n;
        this.retreiveCodeData(CustomCodeData.CodeCategory.CREATE_AND_INIT);
        this.retreiveCodeData(CustomCodeData.CodeCategory.DECLARATION);
        CustomCodeData.VariableDeclaration variableDeclaration = this.codeData.getDeclarationData();
        boolean bl = variableValues[this.variableCombo.getSelectedIndex()];
        if (bl != variableDeclaration.local) {
            int n2 = n = bl ? this.lastLocalModifiers : this.lastFieldModifiers;
            n = this.finalCheckBox.isSelected() ? (n |= 0x10) : (n &= 0xFFFFFFEF);
        } else {
            n = accessValues[this.accessCombo.getSelectedIndex()];
            if (this.staticCheckBox.isSelected()) {
                n |= 8;
            }
            if (this.finalCheckBox.isSelected()) {
                n |= 0x10;
            }
            if (this.transientCheckBox.isSelected()) {
                n |= 0x80;
            }
            if (this.volatileCheckBox.isSelected()) {
                n |= 0x40;
            }
            if (bl) {
                n &= 0xFFFFFF37;
            }
        }
        variableDeclaration.local = bl;
        variableDeclaration.modifiers = n;
        return this.codeData;
    }

    private void retreiveCodeData(CustomCodeData.CodeCategory codeCategory) {
        int n = this.codeData.getGuardedBlockCount(codeCategory);
        for (int i = 0; i < n; ++i) {
            this.retreiveEditableBlock(codeCategory, i);
            this.retreiveGuardedBlock(codeCategory, i);
        }
        if (n > 0) {
            this.retreiveEditableBlock(codeCategory, n);
        }
    }

    private void retreiveEditableBlock(CustomCodeData.CodeCategory codeCategory, int n) {
        CustomCodeData.CodeEntry[] codeEntryArray;
        for (CustomCodeData.CodeEntry codeEntry : codeEntryArray = this.codeData.getEditableBlock(codeCategory, n).getEntries()) {
            codeEntry.setCode(null);
        }
        int[] nArray = this.getEditBlockBounds(codeCategory, n);
        Document document = this.getDocument(codeCategory);
        try {
            String badLocationException = document.getText(nArray[0], nArray[1] - nArray[0]);
            if (badLocationException.trim().equals("")) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = -1;
            EditableLine editableLine = null;
            Iterator<EditableLine> iterator = this.getEditInfos((CustomCodeData.CodeCategory)codeCategory)[n].lines.iterator();
            while (iterator.hasNext() || editableLine != null) {
                int n3;
                EditableLine editableLine2 = editableLine != null ? editableLine : iterator.next();
                int n4 = editableLine2.getPosition().getOffset();
                if (iterator.hasNext()) {
                    editableLine = iterator.next();
                    n3 = editableLine.getPosition().getOffset();
                } else {
                    editableLine = null;
                    n3 = nArray[1];
                }
                stringBuilder.append(document.getText(n4, n3 - n4));
                if (editableLine != null && editableLine.getSelectedIndex() == editableLine2.getSelectedIndex()) continue;
                String string = stringBuilder.toString().trim();
                if (!string.equals("")) {
                    codeEntryArray[editableLine2.getSelectedIndex()].setCode(string);
                }
                stringBuilder.delete(0, stringBuilder.length());
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
    }

    private void retreiveGuardedBlock(CustomCodeData.CodeCategory codeCategory, int n) {
        CustomCodeData.GuardedBlock guardedBlock = this.codeData.getGuardedBlock(codeCategory, n);
        if (!guardedBlock.isCustomizable()) {
            return;
        }
        if (this.getGuardInfos((CustomCodeData.CodeCategory)codeCategory)[n].customized) {
            Document document = this.getDocument(codeCategory);
            int[] nArray = this.getGuardBlockBounds(codeCategory, n);
            try {
                int n2 = nArray[0] + guardedBlock.getHeaderLength();
                String string = document.getText(n2, nArray[1] - guardedBlock.getFooterLength() - n2);
                guardedBlock.setCustomizedCode(string);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
        } else {
            guardedBlock.setCustomizedCode(null);
        }
    }

    private void selectInComboBox(JComboBox jComboBox, Object object) {
        this.ignoreComboAction = true;
        jComboBox.setSelectedItem(object);
        this.ignoreComboAction = false;
    }

    private JTextComponent getEditor(CustomCodeData.CodeCategory codeCategory) {
        switch (codeCategory) {
            case CREATE_AND_INIT: {
                return this.initCodeEditor;
            }
            case DECLARATION: {
                return this.declareCodeEditor;
            }
        }
        return null;
    }

    private Document getDocument(CustomCodeData.CodeCategory codeCategory) {
        return this.getEditor(codeCategory).getDocument();
    }

    private EditBlockInfo[] getEditInfos(CustomCodeData.CodeCategory codeCategory) {
        return this.editBlockInfos.get((Object)codeCategory);
    }

    private GuardBlockInfo[] getGuardInfos(CustomCodeData.CodeCategory codeCategory) {
        return this.guardBlockInfos.get((Object)codeCategory);
    }

    private JPanel getGutter(Document document) {
        if (document == this.initCodeEditor.getDocument()) {
            return this.initGutter;
        }
        if (document == this.declareCodeEditor.getDocument()) {
            return this.declareGutter;
        }
        return null;
    }

    private CustomCodeData.CodeCategory getCategoryForDocument(Document document) {
        if (document == this.initCodeEditor.getDocument()) {
            return CustomCodeData.CodeCategory.CREATE_AND_INIT;
        }
        if (document == this.declareCodeEditor.getDocument()) {
            return CustomCodeData.CodeCategory.DECLARATION;
        }
        return null;
    }

    private static Element getRootElement(Document document) {
        return document.getRootElements()[0];
    }

    private boolean updateGutterComponents(List<EditableLine> list, Document document, int n, int n2) {
        String string;
        try {
            string = document.getText(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            return false;
        }
        boolean bl = !string.trim().equals("");
        int n3 = 0;
        boolean bl2 = false;
        JPanel jPanel = this.getGutter(document);
        for (EditableLine editableLine : list) {
            if (editableLine.getSelectedIndex() < n3) {
                editableLine.setSelectedIndex(n3);
            } else {
                n3 = editableLine.getSelectedIndex();
            }
            Component component = editableLine.getGutterComponent();
            if (component.getParent() == null) {
                jPanel.add(component, editableLine.getPosition());
            }
            if (bl == editableLine.isVisible()) continue;
            component.setVisible(bl);
            bl2 = true;
        }
        return bl2;
    }

    private void processAddedLines(Element element, int n, List<EditableLine> list, int[] nArray, CustomCodeData.EditableBlock editableBlock) {
        Object object;
        Document document = element.getDocument();
        int n2 = element.getElement(n).getStartOffset();
        int n3 = -1;
        int n4 = -1;
        ListIterator<EditableLine> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            int n5 = ((EditableLine)object).getPosition().getOffset();
            if (n5 > n2) {
                n3 = n5;
                listIterator.previous();
                break;
            }
            n4 = ((EditableLine)object).getSelectedIndex();
            if (n5 != n2) continue;
            n2 = element.getElement(++n).getStartOffset();
        }
        if (n3 < 0) {
            n3 = nArray[1];
        }
        if (n4 < 0) {
            n4 = editableBlock.getPreferredEntryIndex();
        }
        try {
            do {
                object = NbDocument.createPosition((Document)document, (int)n2, (Position.Bias)Position.Bias.Backward);
                listIterator.add(new EditableLine((Position)object, editableBlock, n4, list));
            } while (++n < element.getElementCount() && (n2 = element.getElement(n).getStartOffset()) < n3);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
    }

    private void processRemovedLines(Element element, List<EditableLine> list, int[] nArray) {
        int n;
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        int n3 = element.getEndOffset();
        EditableLine editableLine = null;
        EditableLine editableLine2 = null;
        for (EditableLine editableLine3 : list) {
            n = editableLine3.getPosition().getOffset();
            if (n < n2) continue;
            if (n >= n3) break;
            if (editableLine == null) {
                editableLine = editableLine3;
            }
            editableLine2 = editableLine3;
        }
        if (editableLine == null) {
            return;
        }
        boolean bl = editableLine2.getPosition().getOffset() == n2;
        n = n2 == nArray[1] && n2 != document.getLength() ? 1 : 0;
        Iterator<EditableLine> iterator = list.iterator();
        while (iterator.hasNext() && editableLine2 != null) {
            boolean bl2;
            EditableLine editableLine4 = iterator.next();
            if (editableLine4 == editableLine) {
                bl2 = n != 0 || bl;
                editableLine = null;
            } else if (editableLine4 == editableLine2) {
                bl2 = n != 0 || !bl;
                editableLine2 = null;
            } else {
                boolean bl3 = bl2 = editableLine == null;
            }
            if (!bl2) continue;
            iterator.remove();
            Component component = editableLine4.getGutterComponent();
            component.getParent().remove(component);
        }
    }

    private int[] getEditBlockBounds(CustomCodeData.CodeCategory codeCategory, int n) {
        int n2 = this.getEditInfos((CustomCodeData.CodeCategory)codeCategory)[n].position.getOffset();
        GuardBlockInfo[] guardBlockInfoArray = this.getGuardInfos(codeCategory);
        int n3 = n < guardBlockInfoArray.length ? guardBlockInfoArray[n].position.getOffset() : this.getDocument(codeCategory).getLength();
        return new int[]{n2, n3};
    }

    private int getEditBlockIndex(CustomCodeData.CodeCategory codeCategory, int n) {
        return this.getBlockIndex(codeCategory, n, true);
    }

    private int getGuardBlockIndex(CustomCodeData.CodeCategory codeCategory, int n) {
        return this.getBlockIndex(codeCategory, n, false);
    }

    private int getBlockIndex(CustomCodeData.CodeCategory codeCategory, int n, boolean bl) {
        EditBlockInfo[] editBlockInfoArray = this.getEditInfos(codeCategory);
        GuardBlockInfo[] guardBlockInfoArray = this.getGuardInfos(codeCategory);
        for (int i = 0; i < guardBlockInfoArray.length; ++i) {
            int n2 = editBlockInfoArray[i].position.getOffset();
            if (n2 > n) {
                return bl ? -1 : i - 1;
            }
            if (n2 != n && guardBlockInfoArray[i].position.getOffset() < n) continue;
            return bl ? i : -1;
        }
        return bl ? editBlockInfoArray.length - 1 : -1;
    }

    private int[] getGuardBlockBounds(CustomCodeData.CodeCategory codeCategory, int n) {
        int n2 = this.getGuardInfos((CustomCodeData.CodeCategory)codeCategory)[n].position.getOffset();
        int n3 = this.getEditInfos((CustomCodeData.CodeCategory)codeCategory)[n + 1].position.getOffset();
        return new int[]{n2, n3};
    }

    private static int getLineCount(Document document) {
        return CustomCodeView.getRootElement(document).getElementCount();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.initCodeEditor = new JEditorPane();
        JLabel jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.declareCodeEditor = new JEditorPane();
        JLabel jLabel3 = new JLabel();
        this.componentCombo = new JComboBox();
        this.renameButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.variableCombo = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.accessCombo = new JComboBox();
        this.staticCheckBox = new JCheckBox();
        this.finalCheckBox = new JCheckBox();
        this.transientCheckBox = new JCheckBox();
        this.volatileCheckBox = new JCheckBox();
        this.infoLabel = new JLabel();
        FormListener formListener = new FormListener();
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() | 1));
        jLabel.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.initCodeLabel.text"));
        this.jScrollPane1.setViewportView(this.initCodeEditor);
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getStyle() | 1));
        jLabel2.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.declarationCodeLabel.text"));
        this.jScrollPane2.setViewportView(this.declareCodeEditor);
        jLabel3.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.selectComponentLabel.text"));
        this.componentCombo.addActionListener(formListener);
        this.renameButton.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.renameButton.text"));
        this.renameButton.addActionListener(formListener);
        jLabel4.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.variableScopeLabel.text"));
        this.variableCombo.addActionListener(formListener);
        jLabel5.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.variableAccessLabel.text"));
        this.accessCombo.addActionListener(formListener);
        this.staticCheckBox.setText("static");
        this.staticCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.staticCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.staticCheckBox.addActionListener(formListener);
        this.finalCheckBox.setText("final");
        this.finalCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.finalCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.finalCheckBox.addActionListener(formListener);
        this.transientCheckBox.setText("transient");
        this.transientCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.transientCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.transientCheckBox.addActionListener(formListener);
        this.volatileCheckBox.setText("volatile");
        this.volatileCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.volatileCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.volatileCheckBox.addActionListener(formListener);
        this.infoLabel.setText(NbBundle.getMessage(CustomCodeView.class, (String)"CustomCodeView.infoLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 652, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel4).addPreferredGap(0).add((Component)this.variableCombo, -2, -1, -2).addPreferredGap(0).add((Component)jLabel5).addPreferredGap(0).add((Component)this.accessCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.finalCheckBox).addPreferredGap(0).add((Component)this.staticCheckBox).addPreferredGap(0).add((Component)this.transientCheckBox).addPreferredGap(0).add((Component)this.volatileCheckBox)).add(1, (Component)this.jScrollPane2, -1, 652, Short.MAX_VALUE).add(1, (Component)jLabel2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel3).addPreferredGap(0).add((Component)this.componentCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.renameButton)).add((Component)jLabel)).add(20, 20, 20).add((Component)this.infoLabel, -1, 449, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.accessCombo, this.variableCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel3).add((Component)this.componentCombo, -2, -1, -2).add((Component)this.renameButton)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)jLabel)).add((Component)this.infoLabel)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 348, Short.MAX_VALUE).add(11, 11, 11).add((Component)jLabel2).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 58, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel4).add((Component)this.variableCombo, -2, -1, -2).add((Component)jLabel5).add((Component)this.accessCombo, -2, -1, -2).add((Component)this.staticCheckBox).add((Component)this.finalCheckBox).add((Component)this.transientCheckBox).add((Component)this.volatileCheckBox)).addContainerGap()));
    }

    private void declControlActionPerformed(ActionEvent actionEvent) {
        if (this.ignoreComboAction) {
            return;
        }
        this.changed = true;
        this.controller.declarationChanged();
    }

    private void renameButtonActionPerformed(ActionEvent actionEvent) {
        this.controller.renameInvoked();
    }

    private void componentComboActionPerformed(ActionEvent actionEvent) {
        if (this.ignoreComboAction) {
            return;
        }
        this.controller.componentExchanged((String)this.componentCombo.getSelectedItem());
    }

    private class DocumentL
    implements DocumentListener {
        boolean active = true;

        private DocumentL() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.active) {
                this.contentChange(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.active) {
                this.contentChange(documentEvent);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void contentChange(DocumentEvent documentEvent) {
            Element[] elementArray;
            Object object;
            CustomCodeView.this.changed = true;
            Document document = documentEvent.getDocument();
            CustomCodeData.CodeCategory codeCategory = CustomCodeView.this.getCategoryForDocument(document);
            int n = CustomCodeView.this.getEditBlockIndex(codeCategory, documentEvent.getOffset());
            if (n < 0) {
                return;
            }
            List<EditableLine> list = ((CustomCodeView)CustomCodeView.this).getEditInfos((CustomCodeData.CodeCategory)codeCategory)[n].lines;
            int[] nArray = CustomCodeView.this.getEditBlockBounds(codeCategory, n);
            boolean bl = false;
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(CustomCodeView.getRootElement(document));
            if (elementChange != null && ((Element[])(object = elementChange.getChildrenAdded())).length != (elementArray = elementChange.getChildrenRemoved()).length) {
                Element element = CustomCodeView.getRootElement(document);
                int n2 = element.getElementIndex(documentEvent.getOffset());
                if (((Element[])object).length > elementArray.length) {
                    CustomCodeView.this.processAddedLines(element, n2, list, nArray, CustomCodeView.this.codeData.getEditableBlock(codeCategory, n));
                    bl = true;
                } else if (((Object)object).length < elementArray.length) {
                    CustomCodeView.this.processRemovedLines(element.getElement(n2), list, nArray);
                    if (nArray[0] == nArray[1]) {
                        try {
                            document.insertString(nArray[0], "\n", null);
                            CustomCodeView.this.getEditor(codeCategory).setCaretPosition(nArray[0]);
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                        }
                        return;
                    }
                    bl = true;
                }
            }
            if (bl |= CustomCodeView.this.updateGutterComponents(list, document, nArray[0], nArray[1])) {
                object = CustomCodeView.this.getGutter(document);
                ((JComponent)object).revalidate();
                ((Component)object).repaint();
            }
        }
    }

    private static class EditBlockInfo {
        Position position;
        List<EditableLine> lines;

        private EditBlockInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EditableLine {
        private Position position;
        private JComboBox targetCombo;
        private List<EditableLine> linesInBlock;
        private CustomCodeData.CodeEntry[] codeEntries;

        EditableLine(Position position, CustomCodeData.EditableBlock editableBlock, int n, List<EditableLine> list) {
            this.position = position;
            this.linesInBlock = list;
            this.codeEntries = editableBlock.getEntries();
            this.targetCombo = new JComboBox<CustomCodeData.CodeEntry>(this.codeEntries);
            this.setSelectedIndex(n);
            this.targetCombo.setToolTipText(this.codeEntries[n].getToolTipText());
            this.targetCombo.addActionListener(new EditSwitchL());
        }

        Position getPosition() {
            return this.position;
        }

        Component getGutterComponent() {
            return this.targetCombo;
        }

        boolean isVisible() {
            return this.targetCombo.getParent() != null && this.targetCombo.isVisible();
        }

        int getSelectedIndex() {
            return this.targetCombo.getSelectedIndex();
        }

        void setSelectedIndex(int n) {
            CustomCodeView.this.selectInComboBox(this.targetCombo, this.targetCombo.getItemAt(n));
        }

        class EditSwitchL
        implements ActionListener {
            EditSwitchL() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomCodeView.this.ignoreComboAction) {
                    return;
                }
                CustomCodeView.this.changed = true;
                int n = EditableLine.this.targetCombo.getSelectedIndex();
                boolean bl = true;
                for (EditableLine editableLine : EditableLine.this.linesInBlock) {
                    if (editableLine != EditableLine.this) {
                        if ((!bl || editableLine.getSelectedIndex() <= n) && (bl || editableLine.getSelectedIndex() >= n)) continue;
                        editableLine.setSelectedIndex(n);
                        continue;
                    }
                    bl = false;
                }
                EditableLine.this.targetCombo.setToolTipText(EditableLine.this.codeEntries[n].getToolTipText());
            }
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CustomCodeView.this.componentCombo) {
                CustomCodeView.this.componentComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.renameButton) {
                CustomCodeView.this.renameButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.variableCombo) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.accessCombo) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.staticCheckBox) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.finalCheckBox) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.transientCheckBox) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == CustomCodeView.this.volatileCheckBox) {
                CustomCodeView.this.declControlActionPerformed(actionEvent);
            }
        }
    }

    private static class GuardBlockInfo {
        Position position;
        String customizedCode;
        boolean customized;

        private GuardBlockInfo() {
        }
    }

    private class GuardSwitchL
    implements ActionListener {
        CustomCodeData.CodeCategory category;
        int blockIndex;

        GuardSwitchL(CustomCodeData.CodeCategory codeCategory, int n) {
            this.category = codeCategory;
            this.blockIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CustomCodeView.this.ignoreComboAction) {
                return;
            }
            CustomCodeData.GuardedBlock guardedBlock = CustomCodeView.this.codeData.getGuardedBlock(this.category, this.blockIndex);
            GuardBlockInfo guardBlockInfo = CustomCodeView.this.getGuardInfos(this.category)[this.blockIndex];
            int[] nArray = CustomCodeView.this.getGuardBlockBounds(this.category, this.blockIndex);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = guardedBlock.getHeaderLength();
            int n4 = guardedBlock.getFooterLength();
            JTextComponent jTextComponent = CustomCodeView.this.getEditor(this.category);
            StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
            CustomCodeView.this.changed = true;
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            try {
                ((CustomCodeView)CustomCodeView.this).docListener.active = false;
                if (jComboBox.getSelectedIndex() == 1) {
                    NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)n, (int)(n2 - n));
                    styledDocument.remove(n, n2 - n - 1);
                    String string = guardedBlock.getCustomCode();
                    int n5 = string.length();
                    if (guardBlockInfo.customizedCode != null) {
                        string = string.substring(0, n3) + guardBlockInfo.customizedCode + string.substring(n5 - n4);
                        n5 = string.length();
                    }
                    if (string.endsWith("\n")) {
                        string = string.substring(0, n5 - 1);
                    }
                    styledDocument.insertString(n, string, null);
                    guardBlockInfo.customized = true;
                    NbDocument.markGuarded((StyledDocument)styledDocument, (int)n, (int)n3);
                    NbDocument.markGuarded((StyledDocument)styledDocument, (int)(n + n5 - n4), (int)n4);
                    jTextComponent.setSelectionStart(n + n3);
                    jTextComponent.setSelectionEnd(n + n5 - n4);
                    jTextComponent.requestFocus();
                    jComboBox.setToolTipText(guardedBlock.getCustomEntry().getToolTipText());
                } else {
                    guardBlockInfo.customizedCode = styledDocument.getText(n + n3, n2 - n4 - n3 - n);
                    NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)(n2 - n4), (int)n4);
                    NbDocument.unmarkGuarded((StyledDocument)styledDocument, (int)n, (int)n3);
                    styledDocument.remove(n, n2 - n - 1);
                    String string = guardedBlock.getDefaultCode();
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    styledDocument.insertString(n, string, null);
                    guardBlockInfo.customized = false;
                    NbDocument.markGuarded((StyledDocument)styledDocument, (int)n, (int)(string.length() + 1));
                    if (jTextComponent.getSelectionStart() >= n && jTextComponent.getSelectionEnd() <= n2) {
                        jTextComponent.setCaretPosition(n);
                    }
                    jComboBox.setToolTipText(NbBundle.getMessage(CustomCodeData.class, (String)"CTL_GuardCombo_Default_Hint"));
                }
                guardBlockInfo.position = NbDocument.createPosition((Document)styledDocument, (int)n, (Position.Bias)Position.Bias.Forward);
                ((CustomCodeView)CustomCodeView.this).docListener.active = true;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GutterLayout
    implements LayoutManager2 {
        private JTextComponent editor;
        private Map<Component, Position> positions;
        private int lineHeight = -1;
        private static final int LEFT_GAP = 2;
        private static final int RIGHT_GAP = 4;

        GutterLayout(JTextComponent jTextComponent, Map<Component, Position> map) {
            this.editor = jTextComponent;
            this.positions = map;
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.positions.put(component, (Position)object);
        }

        @Override
        public void layoutContainer(Container container) {
            StyledDocument styledDocument = (StyledDocument)this.editor.getDocument();
            for (Component component : container.getComponents()) {
                Position position = this.positions.get(component);
                int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)position.getOffset());
                Dimension dimension = component.getPreferredSize();
                int n2 = this.lineHeight() - dimension.height;
                n2 = n2 > 0 ? n2 / 2 + 1 : 0;
                component.setBounds(2, n * this.lineHeight() + n2, container.getWidth() - 2 - 4, Math.min(dimension.height, this.lineHeight()));
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.positions.remove(component);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            for (Component component : this.positions.keySet()) {
                Dimension dimension = component.getPreferredSize();
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            return new Dimension(n + 2 + 4, this.editor.getPreferredSize().height);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        private int lineHeight() {
            if (this.lineHeight < 0) {
                int n = CustomCodeView.getLineCount(this.editor.getDocument());
                this.lineHeight = this.editor.getPreferredSize().height / n;
            }
            return this.lineHeight;
        }
    }

    static interface Listener {
        public void componentExchanged(String var1);

        public void renameInvoked();

        public void declarationChanged();
    }
}

