/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.I18nSupport;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.assistant.AssistantModel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.windows.WindowManager;

public class FormEditor {
    static final int LOADING = 1;
    static final int SAVING = 2;
    private FormModel formModel;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private CodeGenerator codeGenerator;
    private FormJavaSource formJavaSource;
    private I18nSupport i18nSupport;
    private List persistenceErrors;
    private PersistenceManager persistenceManager;
    private boolean formLoaded = false;
    private static Map openForms = new Hashtable();
    private static Map formModelToAssistant = new WeakHashMap();
    private List floatingWindows;
    private FormDataObject formDataObject;
    private PropertyChangeListener dataObjectListener;
    private static PreferenceChangeListener settingsListener;
    private PropertyChangeListener paletteListener;
    private FormModelListener formListener;

    FormEditor(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public final FormNode getFormRootNode() {
        return this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    private final FormJavaSource getFormJavaSource() {
        return this.formJavaSource;
    }

    CodeGenerator getCodeGenerator() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    I18nSupport getI18nSupport() {
        if (this.i18nSupport == null && this.formModel != null) {
            this.i18nSupport = new I18nSupport(this.formModel);
        }
        return this.i18nSupport;
    }

    boolean isFormLoaded() {
        return this.formLoaded;
    }

    void loadFormDesigner() {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_OpeningForm", new Object[]{this.formDataObject.getFormFile().getName()}));
        RepaintManager.currentManager(jFrame).paintDirtyRegions();
        jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        jFrame.getGlassPane().setVisible(true);
        try {
            this.loadFormData();
        }
        catch (PersistenceException persistenceException) {
            this.logPersistenceError(persistenceException, 0);
        }
        StatusDisplayer.getDefault().setStatusText("");
        jFrame.getGlassPane().setVisible(false);
        jFrame.getGlassPane().setCursor(null);
        this.reportErrors(1);
        this.postCreationUpdate();
    }

    boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.loadFormData();
            }
            catch (PersistenceException persistenceException) {
                this.logPersistenceError(persistenceException, 0);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            FormEditor.this.loadFormData();
                        }
                        catch (PersistenceException persistenceException) {
                            FormEditor.this.logPersistenceError(persistenceException, 0);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFormData() throws PersistenceException {
        if (this.formLoaded) {
            return;
        }
        this.resetPersistenceErrorLog();
        this.persistenceManager = this.recognizeForm(this.formDataObject);
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        this.formJavaSource = new FormJavaSource(this.formDataObject);
        this.formModel.getCodeStructure().setFormJavaSource(this.formJavaSource);
        openForms.put(this.formModel, this);
        PersistenceManager persistenceManager = this.persistenceManager;
        synchronized (persistenceManager) {
            try {
                FormLAF.executeWithLookAndFeel(new Mutex.ExceptionAction(){

                    public Object run() throws Exception {
                        FormEditor.this.persistenceManager.loadForm(FormEditor.this.formDataObject, FormEditor.this.formModel, FormEditor.this.persistenceErrors);
                        return null;
                    }
                });
            }
            catch (PersistenceException persistenceException) {
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                throw persistenceException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                return;
            }
        }
        this.formLoaded = true;
        this.getCodeGenerator().initialize(this.formModel);
        this.getI18nSupport();
        this.formModel.fireFormLoaded();
        if (this.formModel.wasCorrected()) {
            this.formModel.fireFormChanged(false);
        }
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        this.attachDataObjectListener();
        FormEditor.attachSettingsListener();
        this.attachPaletteListener();
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException persistenceException) {
            this.logPersistenceError(persistenceException, 0);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly() && !this.formModel.isReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            PersistenceManager persistenceManager = this.persistenceManager;
            synchronized (persistenceManager) {
                this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
            }
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList();
        }
    }

    private void logPersistenceError(Throwable throwable, int n) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList();
        }
        if (n < 0) {
            this.persistenceErrors.add(throwable);
        } else {
            this.persistenceErrors.add(n, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManager recognizeForm(FormDataObject formDataObject) throws PersistenceException {
        Object object;
        Object object2;
        Iterator iterator = PersistenceManager.getManagers();
        if (!iterator.hasNext()) {
            PersistenceException persistenceException = new PersistenceException("No persistence manager registered");
            ErrorManager.getDefault().annotate((Throwable)persistenceException, 65536, null, FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"), null, null);
            throw persistenceException;
        }
        do {
            object = object2 = (PersistenceManager)iterator.next();
            synchronized (object) {
                try {
                    if (((PersistenceManager)object2).canLoadForm(formDataObject)) {
                        this.resetPersistenceErrorLog();
                        return object2;
                    }
                }
                catch (PersistenceException persistenceException) {
                    this.logPersistenceError(persistenceException);
                }
            }
        } while (iterator.hasNext());
        if (!this.anyPersistenceError()) {
            object2 = new PersistenceException("Form file format not recognized");
            ErrorManager.getDefault().annotate((Throwable)object2, 65536, null, FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"), null, null);
        } else {
            object = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                object2 = (PersistenceException)this.persistenceErrors.get(0);
                Throwable throwable = ((PersistenceException)object2).getOriginalException();
                object = throwable != null ? throwable : object2;
                n = 0;
            } else {
                object = object2 = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate((Throwable)object, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            for (int i = 0; i < n; ++i) {
                PersistenceException persistenceException = (PersistenceException)this.persistenceErrors.get(i);
                Throwable throwable = persistenceException.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)object2, throwable != null ? throwable : persistenceException);
            }
            this.resetPersistenceErrorLog();
        }
        throw object2;
    }

    private void logPersistenceError(Throwable throwable) {
        this.logPersistenceError(throwable, -1);
    }

    private boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    public void reportErrors(int n) {
        if (!this.anyPersistenceError()) {
            return;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        boolean bl = n == 1 && this.formLoaded;
        boolean bl2 = false;
        for (Throwable throwable : this.persistenceErrors) {
            ErrorManager.Annotation[] annotationArray;
            if (throwable instanceof PersistenceException && (annotationArray = ((PersistenceException)throwable).getOriginalException()) != null) {
                throwable = annotationArray;
            }
            if (bl && !bl2) {
                annotationArray = errorManager.findAnnotations(throwable);
                int n2 = 0;
                if (annotationArray != null && annotationArray.length != 0) {
                    for (int i = 0; i < annotationArray.length; ++i) {
                        int n3 = annotationArray[i].getSeverity();
                        if (n3 == 0) {
                            n3 = 4096;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                } else {
                    n2 = 4096;
                }
                if (n2 > 16) {
                    bl2 = true;
                }
            }
            errorManager.notify(1, throwable);
            errorManager.notify(256, throwable);
        }
        if (bl && bl2) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JButton jButton = new JButton(FormUtils.getBundleString("CTL_ViewOnly"));
                    JButton jButton2 = new JButton(FormUtils.getBundleString("CTL_AllowEditing"));
                    Object object = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_FormLoadedWithErrors"), FormUtils.getBundleString("CTL_FormLoadedWithErrors"), -1, 2, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton));
                    if (object == jButton) {
                        FormEditor.this.setFormReadOnly();
                    } else if (object == jButton2) {
                        FormEditor.this.destroyInvalidComponents();
                    } else {
                        FormEditor.this.getFormDesigner().reset(FormEditor.this);
                        FormEditor.this.closeForm();
                        FormEditor.this.getFormDataObject().getFormEditorSupport().selectJavaEditor();
                    }
                }
            });
        }
        this.resetPersistenceErrorLog();
    }

    private void destroyInvalidComponents() {
        Collection<RADComponent> collection = this.formModel.getAllComponents();
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>(collection.size());
        for (RADComponent rADComponent : collection) {
            if (rADComponent.isValid()) continue;
            arrayList.add(rADComponent);
        }
        for (RADComponent rADComponent : arrayList) {
            try {
                rADComponent.getNodeReference().destroy();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void setFormReadOnly() {
        this.formModel.setReadOnly(true);
        this.getFormDesigner().getHandleLayer().setViewOnly(true);
        this.detachFormListener();
        this.getFormDataObject().getFormEditorSupport().updateMVTCDisplayName();
    }

    boolean needPostCreationUpdate() {
        return Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("justCreatedByNewWizard"));
    }

    private void postCreationUpdate() {
        if (this.formLoaded && this.formModel != null && !this.formModel.isReadOnly() && this.needPostCreationUpdate()) {
            this.formModel.getSettings().getLayoutCodeTarget();
            this.formModel.getSettings().getI18nAutoMode();
            this.formModel.fireFormChanged(true);
            FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
            try {
                if (formEditorSupport.isModified()) {
                    this.saveFormData();
                    formEditorSupport.saveSourceOnly();
                }
                this.formDataObject.getPrimaryFile().setAttribute("justCreatedByNewWizard", null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
    }

    void closeForm() {
        if (this.formLoaded) {
            Object object;
            this.formModel.fireFormToBeClosed();
            openForms.remove(this.formModel);
            formModelToAssistant.remove(this.formModel);
            this.formLoaded = false;
            if (this.formDataObject.isValid()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FormEditor.this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{FormEditor.this.formRootNode});
                        FormEditor.this.formRootNode = null;
                    }
                });
            }
            this.detachFormListener();
            this.detachDataObjectListener();
            this.detachPaletteListener();
            if (openForms.isEmpty()) {
                ComponentInspector.getInstance().focusForm(null);
                FormEditor.detachSettingsListener();
            } else {
                object = (FormEditor)openForms.values().iterator().next();
                ComponentInspector.getInstance().focusForm((FormEditor)object);
            }
            if (this.floatingWindows != null) {
                if (this.floatingWindows.size() > 0) {
                    object = new LinkedList(this.floatingWindows);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Window window = (Window)iterator.next();
                        if (!window.isVisible()) continue;
                        window.setVisible(false);
                    }
                }
                this.floatingWindows = null;
            }
            this.formDesigner = null;
            this.persistenceManager = null;
            this.persistenceErrors = null;
            this.formModel = null;
            this.codeGenerator = null;
            this.formJavaSource = null;
            this.i18nSupport = null;
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly() || this.formModel.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            public void formChanged(FormModelEvent[] formModelEventArray) {
                Object object;
                if (formModelEventArray == null) {
                    return;
                }
                boolean bl = false;
                HashSet<ComponentContainer> hashSet = formModelEventArray.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> hashSet2 = null;
                FormNode formNode = null;
                for (int i = 0; i < formModelEventArray.length; ++i) {
                    int n;
                    object = formModelEventArray[i];
                    if (((FormModelEvent)object).isModifying()) {
                        bl = true;
                    }
                    if ((n = ((FormModelEvent)object).getChangeType()) != 4 && n != 5 && n != 7 && n != 8 && n != 9) continue;
                    ComponentContainer componentContainer = ((FormModelEvent)object).getContainer();
                    if (hashSet == null || !hashSet.contains(componentContainer)) {
                        FormEditor.this.updateNodeChildren(componentContainer);
                        if (hashSet != null) {
                            hashSet.add(componentContainer);
                        }
                    }
                    if (n == 8) {
                        FormNode formNode2 = componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : FormEditor.this.formRootNode.getOthersNode();
                        if (!(formNode instanceof RADComponentNode)) {
                            if (formNode == FormEditor.this.formRootNode) continue;
                            formNode = formNode2;
                            continue;
                        }
                        if (formNode == formNode2) continue;
                        formNode = FormEditor.this.formRootNode;
                        continue;
                    }
                    if (n == 4) {
                        formNode = ((RADVisualContainer)componentContainer).getLayoutNodeReference();
                        continue;
                    }
                    if (n != 7 || !((FormModelEvent)object).getComponent().isInModel()) continue;
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<RADComponent>();
                    }
                    hashSet2.add(((FormModelEvent)object).getComponent());
                    hashSet2.remove(((FormModelEvent)object).getContainer());
                }
                FormDesigner formDesigner = FormEditor.this.getFormDesigner();
                if (formDesigner != null) {
                    if (hashSet2 != null) {
                        formDesigner.clearSelectionImpl();
                        object = hashSet2.iterator();
                        while (object.hasNext()) {
                            formDesigner.addComponentToSelectionImpl((RADComponent)object.next());
                        }
                        formDesigner.updateComponentInspector();
                    } else if (formNode != null) {
                        formDesigner.setSelectedNode(formNode);
                    }
                }
                if (bl) {
                    object = FormEditor.this.getFormDataObject();
                    ((FormDataObject)((Object)object)).getFormEditorSupport().markFormModified();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    void updateNodeChildren(ComponentContainer componentContainer) {
        FormNode formNode = componentContainer == null || componentContainer == this.formModel.getModelContainer() ? (this.formRootNode != null ? this.formRootNode.getOthersNode() : null) : (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : null);
        if (formNode != null) {
            formNode.updateChildren();
        }
    }

    private void attachDataObjectListener() {
        if (this.dataObjectListener != null) {
            return;
        }
        this.dataObjectListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("name".equals(propertyChangeEvent.getPropertyName())) {
                    String string = FormEditor.this.formDataObject.getName();
                    FormEditor.this.formModel.setName(string);
                    FormEditor.this.formRootNode.updateName(string);
                } else if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            Node[] nodeArray = ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
                            for (int i = 0; i < nodeArray.length; ++i) {
                                ((FormNode)nodeArray[i]).updateCookies();
                            }
                        }
                    });
                }
            }
        };
        this.formDataObject.addPropertyChangeListener(this.dataObjectListener);
    }

    private void detachDataObjectListener() {
        if (this.dataObjectListener != null) {
            this.formDataObject.removePropertyChangeListener(this.dataObjectListener);
            this.dataObjectListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                for (FormModel formModel : openForms.keySet()) {
                    FormDesigner formDesigner;
                    String string = preferenceChangeEvent.getKey();
                    if ("useIndentEngine".equals(string)) {
                        formModel.fireSyntheticPropertyChanged(null, string, null, preferenceChangeEvent.getNewValue());
                        continue;
                    }
                    if ("selectionBorderSize".equals(string) || "selectionBorderColor".equals(string) || "connectionBorderColor".equals(string) || "formDesignerBackgroundColor".equals(string) || "formDesignerBorderColor".equals(string)) {
                        formDesigner = FormEditor.getFormDesigner(formModel);
                        if (formDesigner == null) continue;
                        formDesigner.updateVisualSettings();
                        continue;
                    }
                    if (!"toolBarPalette".equals(string) || (formDesigner = FormEditor.getFormDesigner(formModel)) == null) continue;
                    formDesigner.getFormToolBar().showPaletteButton(FormLoaderSettings.getInstance().isPaletteInToolBar());
                }
            }
        };
        FormLoaderSettings.getInstance();
        FormLoaderSettings.getPreferences().addPreferenceChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormLoaderSettings.getInstance();
            FormLoaderSettings.getPreferences().removePreferenceChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private void attachPaletteListener() {
        if (this.paletteListener != null) {
            return;
        }
        this.paletteListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedItem".equals(propertyChangeEvent.getPropertyName())) {
                    for (FormModel formModel : openForms.keySet()) {
                        FormDesigner formDesigner;
                        if (formModel.isReadOnly() || (formDesigner = FormEditor.getFormDesigner(formModel)) == null) continue;
                        if (propertyChangeEvent.getNewValue() == null) {
                            if (formDesigner.getDesignerMode() != 2) continue;
                            formDesigner.setDesignerMode(0);
                            continue;
                        }
                        if (formDesigner.getDesignerMode() == 2) {
                            formDesigner.setDesignerMode(0);
                        }
                        formDesigner.setDesignerMode(2);
                    }
                }
            }
        };
        PaletteUtils.addPaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
    }

    private void detachPaletteListener() {
        if (this.paletteListener != null) {
            PaletteUtils.removePaletteListener(this.paletteListener, this.formDataObject.getPrimaryFile());
            this.paletteListener = null;
        }
    }

    void reinstallListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formModel.addFormModelListener(this.formListener);
        }
    }

    public static JEditorPane createCodeEditorPane(FormModel formModel) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/x-java");
        jEditorPane.getDocument().putProperty("stream", (Object)FormEditor.getFormDataObject(formModel));
        JavaCodeGenerator javaCodeGenerator = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel);
        javaCodeGenerator.regenerateCode();
        return jEditorPane;
    }

    public static synchronized AssistantModel getAssistantModel(FormModel formModel) {
        assert (formModel != null);
        AssistantModel assistantModel = (AssistantModel)formModelToAssistant.get(formModel);
        if (assistantModel == null) {
            assistantModel = new AssistantModel();
            formModelToAssistant.put(formModel, assistantModel);
        }
        return assistantModel;
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditor formEditor = (FormEditor)openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDesigner() : null;
    }

    public static CodeGenerator getCodeGenerator(FormModel formModel) {
        FormEditor formEditor = (FormEditor)openForms.get(formModel);
        return formEditor != null ? formEditor.getCodeGenerator() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditor formEditor = (FormEditor)openForms.get(formModel);
        return formEditor != null ? formEditor.getFormDataObject() : null;
    }

    public static FormJavaSource getFormJavaSource(FormModel formModel) {
        FormEditor formEditor = (FormEditor)openForms.get(formModel);
        return formEditor != null ? formEditor.getFormJavaSource() : null;
    }

    static I18nSupport getI18nSupport(FormModel formModel) {
        FormEditor formEditor = (FormEditor)openForms.get(formModel);
        return formEditor != null ? formEditor.getI18nSupport() : null;
    }

    public static FormEditor getFormEditor(FormModel formModel) {
        return (FormEditor)openForms.get(formModel);
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList();
        } else {
            this.floatingWindows.remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            this.floatingWindows.remove(window);
        }
    }

    public boolean updateProjectForNaturalLayout() {
        if (this.formModel.getSettings().getLayoutCodeTarget() == 1) {
            return false;
        }
        try {
            ClassSource classSource = new ClassSource("org.jdesktop.layout.*", new String[]{"library"}, new String[]{"swing-layout"});
            return ClassPathUtils.updateProject(this.formDataObject.getFormFile(), classSource);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return false;
        }
    }

    public static boolean isNonVisualTrayEnabled() {
        return Boolean.getBoolean("netbeans.form.non_visual_tray");
    }
}

