/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.FormLoaderSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class FormEditorCustomizer
extends JPanel
implements ActionListener,
ChangeListener {
    private JCheckBox cbFold = new JCheckBox();
    private JCheckBox cbAssistant = new JCheckBox();
    private JComboBox cbModifier = new JComboBox();
    private JRadioButton rbGenerateLocals = new JRadioButton();
    private JRadioButton rbGenerateFields = new JRadioButton();
    private JComboBox cbListenerStyle = new JComboBox();
    private JComboBox cbAutoI18n = new JComboBox();
    private boolean changed = false;
    private boolean listen = false;

    public FormEditorCustomizer() {
        ButtonGroup buttonGroup = new ButtonGroup();
        FormEditorCustomizer.loc(this.cbFold, "Fold");
        this.cbFold.setBackground(Color.white);
        FormEditorCustomizer.loc(this.cbAssistant, "Assistant");
        this.cbAssistant.setBackground(Color.white);
        FormEditorCustomizer.loc(this.rbGenerateLocals, "Generate_Locals");
        this.rbGenerateLocals.setBackground(Color.white);
        buttonGroup.add(this.rbGenerateLocals);
        FormEditorCustomizer.loc(this.rbGenerateFields, "Generate_Fields");
        this.rbGenerateFields.setBackground(Color.white);
        buttonGroup.add(this.rbGenerateFields);
        this.cbModifier.addItem(FormEditorCustomizer.loc("Public_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Default_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Protected_Modifier"));
        this.cbModifier.addItem(FormEditorCustomizer.loc("Private_Modifier"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("Anonymous"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("InnerClass"));
        this.cbListenerStyle.addItem(FormEditorCustomizer.loc("MainClass"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_I18N_DEFAULT"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_I18N_ON"));
        this.cbAutoI18n.addItem(FormEditorCustomizer.loc("CTL_AUTO_I18N_OFF"));
        JLabel jLabel = new JLabel(FormEditorCustomizer.loc("Generate_Components"));
        JLabel jLabel2 = new JLabel(FormEditorCustomizer.loc("Variable_Modifier"));
        JLabel jLabel3 = new JLabel(FormEditorCustomizer.loc("Listener_Style"));
        JLabel jLabel4 = new JLabel(FormEditorCustomizer.loc("Auto_I18n"));
        jLabel.setToolTipText(FormEditorCustomizer.loc("Generate_Components_Hint"));
        jLabel2.setToolTipText(FormEditorCustomizer.loc("HINT_VARIABLES_MODIFIER"));
        jLabel3.setToolTipText(FormEditorCustomizer.loc("HINT_LISTENER_GENERATION_STYLE"));
        jLabel4.setToolTipText(FormEditorCustomizer.loc("HINT_AUTO_I18N_GLOBAL"));
        this.cbFold.setToolTipText(FormEditorCustomizer.loc("HINT_FOLD_GENERATED_CODE"));
        this.cbAssistant.setToolTipText(FormEditorCustomizer.loc("HINT_ASSISTANT_SHOWN"));
        jLabel2.setLabelFor(this.cbModifier);
        jLabel3.setLabelFor(this.cbListenerStyle);
        jLabel4.setLabelFor(this.cbAutoI18n);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((Component)jLabel2).add((Component)jLabel3).add((Component)jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.rbGenerateLocals).add((Component)this.rbGenerateFields).add((Component)this.cbFold).add((Component)this.cbAssistant).add((Component)this.cbModifier, -1, -1, Short.MAX_VALUE).add((Component)this.cbListenerStyle, -1, -1, Short.MAX_VALUE).add((Component)this.cbAutoI18n, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.rbGenerateLocals)).addPreferredGap(0).add((Component)this.rbGenerateFields).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.cbModifier)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel3).add((Component)this.cbListenerStyle)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel4).add((Component)this.cbAutoI18n)).addPreferredGap(0).add((Component)this.cbFold).add((Component)this.cbAssistant).addContainerGap());
        this.setBorder(new TitledBorder(FormEditorCustomizer.loc("Code_Generation")));
        this.setBackground(Color.white);
        this.cbFold.addActionListener(this);
        this.cbAssistant.addActionListener(this);
        this.cbListenerStyle.addActionListener(this);
        this.cbModifier.addActionListener(this);
        this.rbGenerateFields.addActionListener(this);
        this.rbGenerateLocals.addActionListener(this);
        this.cbAutoI18n.addActionListener(this);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(FormEditorCustomizer.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)FormEditorCustomizer.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)FormEditorCustomizer.loc(string));
        }
    }

    void update() {
        this.listen = false;
        FormLoaderSettings formLoaderSettings = FormLoaderSettings.getInstance();
        this.cbFold.setSelected(formLoaderSettings.getFoldGeneratedCode());
        this.cbAssistant.setSelected(formLoaderSettings.getAssistantShown());
        this.rbGenerateLocals.setSelected(formLoaderSettings.getVariablesLocal());
        this.rbGenerateFields.setSelected(!formLoaderSettings.getVariablesLocal());
        if ((formLoaderSettings.getVariablesModifier() & 1) > 0) {
            this.cbModifier.setSelectedIndex(0);
        } else if ((formLoaderSettings.getVariablesModifier() & 4) > 0) {
            this.cbModifier.setSelectedIndex(2);
        } else if ((formLoaderSettings.getVariablesModifier() & 2) > 0) {
            this.cbModifier.setSelectedIndex(3);
        } else {
            this.cbModifier.setSelectedIndex(1);
        }
        this.cbListenerStyle.setSelectedIndex(formLoaderSettings.getListenerGenerationStyle());
        this.cbAutoI18n.setSelectedIndex(formLoaderSettings.getI18nAutoMode());
        this.listen = true;
        this.changed = false;
    }

    void applyChanges() {
        FormLoaderSettings formLoaderSettings = FormLoaderSettings.getInstance();
        formLoaderSettings.setFoldGeneratedCode(this.cbFold.isSelected());
        formLoaderSettings.setAssistantShown(this.cbAssistant.isSelected());
        formLoaderSettings.setListenerGenerationStyle(this.cbListenerStyle.getSelectedIndex());
        formLoaderSettings.setI18nAutoMode(this.cbAutoI18n.getSelectedIndex());
        formLoaderSettings.setVariablesLocal(this.rbGenerateLocals.isSelected());
        switch (this.cbModifier.getSelectedIndex()) {
            case 0: {
                formLoaderSettings.setVariablesModifier(1);
                break;
            }
            case 1: {
                formLoaderSettings.setVariablesModifier(0);
                break;
            }
            case 2: {
                formLoaderSettings.setVariablesModifier(4);
                break;
            }
            case 3: {
                formLoaderSettings.setVariablesModifier(2);
            }
        }
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listen) {
            this.changed = true;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.listen) {
            this.changed = true;
        }
    }
}

