/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormJavaSource {
    private final FormDataObject formDataObject;
    private List<String> fields = null;
    private static final String[] PROPERTY_PREFIXES = new String[]{"get", "is"};

    public FormJavaSource(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    public void refresh() {
        this.fields = Collections.emptyList();
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.PARSED);
                FormJavaSource.this.fields = FormJavaSource.this.getFieldNames(compilationController);
            }
        });
    }

    private void runUserActionTask(CancellableTask<CompilationController> cancellableTask) {
        FileObject fileObject = this.formDataObject.getPrimaryFile();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask(cancellableTask, true);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    public boolean containsField(String string, boolean bl) {
        if (bl) {
            this.refresh();
        }
        return this.fields != null && this.fields.contains(string);
    }

    private ClassTree findClassTree(CompilationController compilationController) {
        String string = this.formDataObject.getPrimaryFile().getName();
        for (Tree tree : compilationController.getCompilationUnit().getTypeDecls()) {
            if (tree.getKind() != Tree.Kind.CLASS || !string.equals(((ClassTree)tree).getSimpleName().toString())) continue;
            return (ClassTree)tree;
        }
        return null;
    }

    private List<String> findMethodsByReturnType(CompilationController compilationController, TypeElement typeElement, Class clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = clazz.getName();
        TypeElement typeElement2 = compilationController.getElements().getTypeElement(string);
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            TypeMirror typeMirror = executableElement.getReturnType();
            if (!compilationController.getTypes().isAssignable(typeElement2.asType(), typeMirror)) continue;
            arrayList.add(executableElement.getSimpleName().toString());
        }
        return arrayList;
    }

    public String[] getMethodNames(final Class clazz) {
        final Object[] objectArray = new Object[1];
        this.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree classTree = FormJavaSource.this.findClassTree(compilationController);
                if (classTree != null) {
                    TreePath treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), classTree);
                    TypeElement typeElement = (TypeElement)compilationController.getTrees().getElement(treePath);
                    List list = FormJavaSource.this.findMethodsByReturnType(compilationController, typeElement, clazz);
                    objectArray[0] = FormJavaSource.toArray(list);
                }
            }
        });
        return objectArray[0] == null ? new String[]{} : (String[])objectArray[0];
    }

    public String[] getPropertyReadMethodNames(Class clazz) {
        String[] stringArray = this.getMethodNames(clazz);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (FormJavaSource.extractPropertyName(string).equals("")) continue;
            arrayList.add(string);
        }
        return FormJavaSource.toArray(arrayList);
    }

    public static String extractPropertyName(String string) {
        for (int i = 0; i < PROPERTY_PREFIXES.length; ++i) {
            if (!string.startsWith(PROPERTY_PREFIXES[i]) || string.length() <= PROPERTY_PREFIXES[i].length()) continue;
            return Introspector.decapitalize(string.substring(PROPERTY_PREFIXES[i].length()));
        }
        return "";
    }

    private List<String> getFieldNames(final CompilationController compilationController) {
        SimpleSection simpleSection = this.formDataObject.getFormEditorSupport().getVariablesSection();
        if (simpleSection == null) {
            return null;
        }
        final int n = simpleSection.getStartPosition().getOffset();
        final int n2 = simpleSection.getEndPosition().getOffset();
        final SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
        TreeScanner<Void, List<String>> treeScanner = new TreeScanner<Void, List<String>>(){

            @Override
            public Void visitClass(ClassTree classTree, List<String> list) {
                long l = sourcePositions.getStartPosition(compilationController.getCompilationUnit(), classTree);
                long l2 = sourcePositions.getEndPosition(compilationController.getCompilationUnit(), classTree);
                if ((long)n > l && (long)n2 < l2) {
                    for (Tree tree : classTree.getMembers()) {
                        if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                        this.testVariable((VariableTree)tree, list);
                    }
                }
                return null;
            }

            private void testVariable(VariableTree variableTree, List<String> list) {
                long l = sourcePositions.getStartPosition(compilationController.getCompilationUnit(), variableTree);
                if (l >= (long)n2 || l <= (long)n) {
                    list.add(variableTree.getName().toString());
                }
            }
        };
        ArrayList<String> arrayList = new ArrayList<String>();
        treeScanner.scan(compilationController.getCompilationUnit(), arrayList);
        return arrayList;
    }

    private boolean isAssignableFrom(String string, Class clazz) {
        Class clazz2 = this.getClassByName(string);
        return clazz2 != null ? clazz.isAssignableFrom(clazz2) : false;
    }

    private Class getClassByName(String string) {
        Class clazz = null;
        try {
            clazz = ClassPathUtils.loadClass(string, this.formDataObject.getPrimaryFile());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (LinkageError linkageError) {
            linkageError.printStackTrace();
        }
        return clazz;
    }

    private static String[] toArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    public static boolean isInDefaultPackage(FormModel formModel) {
        FileObject fileObject = FormEditor.getFormDataObject(formModel).getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = classPath.getResourceName(fileObject);
        return string.indexOf(47) < 0;
    }
}

