/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

public class FormPropertyEditor
implements PropertyEditor,
PropertyChangeListener,
EnhancedPropertyEditor,
ExPropertyEditor {
    private static String NO_VALUE_TEXT;
    private Object value = BeanSupport.NO_VALUE;
    private FormProperty property;
    private WeakReference propertyEnv;
    private PropertyEditor[] allEditors;
    private PropertyChangeSupport changeSupport;

    FormPropertyEditor(FormProperty formProperty) {
        this.property = formProperty;
        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(this);
            this.value = propertyEditor.getValue();
        }
    }

    Class getPropertyType() {
        return this.property.getValueType();
    }

    FormProperty getProperty() {
        return this.property;
    }

    FormPropertyContext getPropertyContext() {
        return this.property.getPropertyContext();
    }

    PropertyEnv getPropertyEnv() {
        return this.propertyEnv != null ? (PropertyEnv)this.propertyEnv.get() : null;
    }

    PropertyEditor getCurrentEditor() {
        return this.property.getCurrentEditor();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            this.value = propertyEditor.getValue();
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FormPropertyEditor.this.firePropertyChange();
                return null;
            }
        });
    }

    public void setValue(Object object) {
        this.value = object;
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (this.value != BeanSupport.NO_VALUE && propertyEditor != null) {
            propertyEditor.setValue(this.value);
        }
    }

    public Object getValue() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getValue() : this.value;
    }

    public boolean isPaintable() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.isPaintable() : false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.paintValue(graphics, rectangle);
        }
    }

    public String getJavaInitializationString() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getJavaInitializationString() : null;
    }

    public String getAsText() {
        if (this.value == BeanSupport.NO_VALUE) {
            if (NO_VALUE_TEXT == null) {
                NO_VALUE_TEXT = FormUtils.getBundleString("CTL_ValueNotSet");
            }
            return NO_VALUE_TEXT;
        }
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getAsText() : null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.setAsText(string);
        }
    }

    public String[] getTags() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getTags() : null;
    }

    public Component getCustomEditor() {
        Component component;
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null && propertyEditor.supportsCustomEditor()) {
            component = propertyEditor.getCustomEditor();
            if (component instanceof Window) {
                return component;
            }
        } else {
            component = null;
        }
        return new FormCustomEditor(this, component);
    }

    public boolean supportsCustomEditor() {
        PropertyEditor[] propertyEditorArray = this.getAllEditors();
        if (!this.property.canWrite()) {
            for (int i = 0; i < propertyEditorArray.length; ++i) {
                if (propertyEditorArray[i].getClass().equals(RADConnectionPropertyEditor.class) || !propertyEditorArray[i].supportsCustomEditor()) continue;
                return true;
            }
            return false;
        }
        if (propertyEditorArray.length > 1) {
            return true;
        }
        if (propertyEditorArray.length == 1) {
            return propertyEditorArray[0].supportsCustomEditor();
        }
        return false;
    }

    synchronized PropertyEditor[] getAllEditors() {
        if (this.allEditors == null) {
            PropertyEditor propertyEditor = this.property.getExpliciteEditor();
            PropertyEditor[] propertyEditorArray = FormPropertyEditorManager.getAllEditors(this.property);
            if (propertyEditor != null) {
                for (int i = 0; i < propertyEditorArray.length; ++i) {
                    if (!propertyEditor.getClass().equals(propertyEditorArray[i].getClass())) continue;
                    propertyEditorArray[i] = propertyEditor;
                    propertyEditor = null;
                    break;
                }
            }
            if (propertyEditor != null) {
                this.allEditors = new PropertyEditor[propertyEditorArray.length + 1];
                this.allEditors[0] = propertyEditor;
                System.arraycopy(propertyEditorArray, 0, this.allEditors, 1, propertyEditorArray.length);
            } else {
                this.allEditors = propertyEditorArray;
            }
        }
        return this.allEditors;
    }

    public Component getInPlaceCustomEditor() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)propertyEditor).getInPlaceCustomEditor() : null;
    }

    public boolean hasInPlaceCustomEditor() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)propertyEditor).hasInPlaceCustomEditor() : false;
    }

    public boolean supportsEditingTaggedValues() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor instanceof EnhancedPropertyEditor ? ((EnhancedPropertyEditor)propertyEditor).supportsEditingTaggedValues() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        FormPropertyEditor formPropertyEditor = this;
        synchronized (formPropertyEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = new WeakReference<PropertyEnv>(propertyEnv);
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
        }
    }

    public int hashCode() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        return object != null ? this.hashCode() == object.hashCode() : false;
    }
}

