/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.ErrorManager;

public final class FormPropertyEditorManager {
    private static HashMap editorsCache = new HashMap(30);
    private static HashMap expliciteEditors = new HashMap(10);

    public static synchronized PropertyEditor findEditor(FormProperty formProperty) {
        PropertyEditor[] propertyEditorArray;
        FormModel formModel;
        Class clazz = formProperty.getValueType();
        Class[] classArray = FormPropertyEditorManager.findEditorClasses(clazz, formModel = formProperty.getPropertyContext().getFormModel());
        if (classArray.length > 0 && (propertyEditorArray = FormPropertyEditorManager.createEditorInstances(new Class[]{classArray[0]}, clazz)).length > 0) {
            return propertyEditorArray[0];
        }
        return null;
    }

    public static synchronized PropertyEditor[] getAllEditors(FormProperty formProperty) {
        Class clazz = formProperty.getValueType();
        FormModel formModel = formProperty.getPropertyContext().getFormModel();
        return FormPropertyEditorManager.createEditorInstances(FormPropertyEditorManager.findEditorClasses(clazz, formModel), clazz);
    }

    public static synchronized void registerEditor(Class clazz, Class clazz2) {
        Class[] classArray;
        Class[] classArray2 = (Class[])expliciteEditors.get(FormPropertyEditorManager.getTypeName(clazz));
        if (classArray2 == null) {
            classArray = new Class[]{clazz2};
        } else {
            for (int i = 0; i < classArray2.length; ++i) {
                if (!classArray2[i].equals(clazz2)) continue;
                return;
            }
            classArray = new Class[classArray2.length + 1];
            System.arraycopy(classArray2, 0, classArray, 0, classArray2.length);
            classArray[classArray.length - 1] = clazz2;
        }
        expliciteEditors.put(FormPropertyEditorManager.getTypeName(clazz), classArray);
    }

    static synchronized void clearEditorsCache() {
        editorsCache.clear();
    }

    private static String getTypeName(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            if (Byte.TYPE.equals(clazz)) {
                string = "byte";
            } else if (Short.TYPE.equals(clazz)) {
                string = "short";
            } else if (Integer.TYPE.equals(clazz)) {
                string = "integer";
            } else if (Long.TYPE.equals(clazz)) {
                string = "long";
            } else if (Boolean.TYPE.equals(clazz)) {
                string = "boolean";
            } else if (Float.TYPE.equals(clazz)) {
                string = "float";
            } else if (Double.TYPE.equals(clazz)) {
                string = "double";
            } else if (Character.TYPE.equals(clazz)) {
                string = "char";
            }
        }
        return string;
    }

    private static Class[] findEditorClasses(Class clazz, FormModel formModel) {
        Class clazz2;
        int n;
        String string;
        PropertyEditor propertyEditor;
        Class[] classArray = (Class[])editorsCache.get(clazz);
        if (classArray != null) {
            return classArray;
        }
        FormLoaderSettings formLoaderSettings = FormLoaderSettings.getInstance();
        ArrayList<Class> arrayList = new ArrayList<Class>(5);
        PropertyEditor propertyEditor2 = propertyEditor = clazz == Object.class || clazz == Font.class ? null : PropertyEditorManager.findEditor(clazz);
        if (propertyEditor != null) {
            arrayList.add(propertyEditor.getClass());
        } else {
            string = clazz.getName();
            if (!string.startsWith("[")) {
                int n2 = string.lastIndexOf(46);
                if (n2 > 0) {
                    string = string.substring(n2 + 1);
                }
                String[] stringArray = formLoaderSettings.getEditorSearchPath();
                for (n = 0; n < stringArray.length; ++n) {
                    String string2 = stringArray[n] + "." + string + "Editor";
                    try {
                        clazz2 = FormUtils.loadClass(string2, formModel);
                        arrayList.add(clazz2);
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    catch (LinkageError linkageError) {
                        // empty catch block
                    }
                }
            }
        }
        string = FormPropertyEditorManager.getTypeName(clazz);
        String[][] stringArray = formLoaderSettings.getRegisteredEditors();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2 == null || stringArray2.length <= 0 || !stringArray2[0].equals(string)) continue;
            for (int j = 1; j < stringArray2.length; ++j) {
                try {
                    clazz2 = FormUtils.loadClass(stringArray2[j], formModel);
                    if (arrayList.contains(clazz2)) continue;
                    arrayList.add(clazz2);
                    continue;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
        Class[] classArray2 = (Class[])expliciteEditors.get(string);
        if (classArray2 != null) {
            for (n = 0; n < classArray2.length; ++n) {
                Class clazz3 = classArray2[n];
                if (arrayList.contains(clazz3)) continue;
                arrayList.add(clazz3);
            }
        }
        if (Component.class.isAssignableFrom(clazz)) {
            arrayList.add(ComponentChooserEditor.class);
        }
        arrayList.add(RADConnectionPropertyEditor.class);
        classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        editorsCache.put(clazz, classArray);
        return classArray;
    }

    private static PropertyEditor[] createEditorInstances(Class[] classArray, Class clazz) {
        ArrayList<FormAwareEditor> arrayList = new ArrayList<FormAwareEditor>(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            if (RADConnectionPropertyEditor.class.isAssignableFrom(clazz2)) {
                arrayList.add(new RADConnectionPropertyEditor(clazz));
                continue;
            }
            if (ComponentChooserEditor.class.isAssignableFrom(clazz2)) {
                arrayList.add(new ComponentChooserEditor(new Class[]{clazz}));
                continue;
            }
            if (!PropertyEditor.class.isAssignableFrom(clazz2)) continue;
            try {
                arrayList.add((FormAwareEditor)clazz2.newInstance());
                continue;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        PropertyEditor[] propertyEditorArray = new PropertyEditor[arrayList.size()];
        arrayList.toArray(propertyEditorArray);
        return propertyEditorArray;
    }
}

