/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class I18nSupport {
    private FormModel formModel;
    private String defaultBundle;
    private String designLocale = "";
    private I18nService i18nService;
    private Map<Object, I18nValue> droppedValues;
    private static Map<DataObject, String> rememberedLocales = new WeakHashMap<DataObject, String>();
    private static final String I18N_KEY_PREFIX = "";
    private static final String EXCLUDE_I18N = "NOI18N";
    private static final String PE_PLAIN_SET = "Plain_StringPropertyEditor";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    static final String PROP_FORM_BUNDLE = "formBundle";
    private static final String PROP_DESIGN_LOCALE = "designLocale";

    I18nSupport(FormModel formModel) {
        this.formModel = formModel;
        this.formModel.addFormModelListener(new ModelListener());
        String string = rememberedLocales.get(this.getSrcDataObject());
        if (string != null) {
            this.designLocale = string;
            if (!string.equals(I18N_KEY_PREFIX)) {
                this.updateDesignLocale();
            }
        }
    }

    private I18nService getI18nService() {
        if (this.i18nService == null) {
            this.i18nService = (I18nService)Lookup.getDefault().lookup(I18nService.class);
        }
        return this.i18nService;
    }

    private static I18nSupport getI18nSupport(FormProperty formProperty) {
        return FormEditor.getI18nSupport(formProperty.getPropertyContext().getFormModel());
    }

    private static I18nSupport getI18nSupport(RADComponent rADComponent) {
        return FormEditor.getI18nSupport(rADComponent.getFormModel());
    }

    public static Object internationalizeProperty(Object object, FormProperty formProperty, RADComponent rADComponent) {
        if (Boolean.TRUE.equals(formProperty.getValue(EXCLUDE_I18N))) {
            if (Boolean.TRUE.equals(formProperty.getValue(PE_PLAIN_SET))) {
                formProperty.setValue(EXCLUDE_I18N, Boolean.FALSE);
            }
            return object;
        }
        String string = I18nSupport.getComponentPath(rADComponent);
        I18nSupport i18nSupport = I18nSupport.getI18nSupport(formProperty);
        if (I18nSupport.isI18nType(formProperty.getValueType())) {
            return i18nSupport.internationalizeProperty(object, formProperty, string);
        }
        for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getNestedI18nProperties(object, formProperty, string, false)) {
            FormProperty formProperty2 = i18nPropertyInfo.property;
            try {
                Object object2 = formProperty2.getValue();
                Object object3 = i18nSupport.internationalizeProperty(object2, formProperty2, i18nPropertyInfo.path);
                if (object3 == object2) continue;
                boolean bl = formProperty2.isChangeFiring();
                formProperty2.setChangeFiring(false);
                formProperty2.setValue(object3);
                formProperty2.setChangeFiring(bl);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return object;
    }

    private Object internationalizeProperty(Object object, FormProperty formProperty, String string) {
        I18nValue i18nValue;
        if (this.getI18nService() == null) {
            return object;
        }
        if (object instanceof I18nValue) {
            I18nValue i18nValue2 = (I18nValue)object;
            if (i18nValue2.getKey() == "auto") {
                i18nValue2 = this.i18nService.changeKey(i18nValue2, this.getAutoKey(string, formProperty.getName()));
            }
            return i18nValue2;
        }
        if (!(object instanceof String)) {
            return object;
        }
        I18nValue i18nValue3 = I18nSupport.getI18nValue(formProperty);
        if (i18nValue3 != null) {
            i18nValue = this.i18nService.changeValue(i18nValue3, object.toString());
        } else {
            if (!this.isAutoMode()) {
                return object;
            }
            i18nValue = this.searchDroppedValues((Object)formProperty, object.toString());
            if (i18nValue == null) {
                String string2 = this.getAutoKey(string, formProperty.getName());
                i18nValue = this.i18nService.create(string2, object.toString(), this.getSrcDataObject());
            }
        }
        return new FormProperty.ValueWithEditor((Object)i18nValue, this.i18nService.getPropertyEditor(formProperty.getValueType(), formProperty.getCurrentEditor()));
    }

    private I18nValue searchDroppedValues(Object object, String string) {
        I18nValue i18nValue;
        if (this.droppedValues != null && (i18nValue = this.droppedValues.get(object)) != null && i18nValue.getValue().equals(string)) {
            return i18nValue;
        }
        return null;
    }

    public static void internationalizeComponent(RADComponent rADComponent) {
        I18nSupport i18nSupport = I18nSupport.getI18nSupport(rADComponent);
        if (i18nSupport.isAutoMode()) {
            i18nSupport.internationalizeComponent(rADComponent, false);
        }
    }

    private void internationalizeComponent(RADComponent rADComponent, boolean bl) {
        if (this.getI18nService() == null) {
            return;
        }
        for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getComponentI18nProperties(rADComponent, false, !bl)) {
            FormProperty formProperty = i18nPropertyInfo.property;
            try {
                Object object = this.internationalizeProperty(formProperty.getValue(), formProperty, i18nPropertyInfo.path);
                boolean bl2 = formProperty.isChangeFiring();
                formProperty.setChangeFiring(false);
                formProperty.setValue(object);
                formProperty.setChangeFiring(bl2);
                if (!bl) continue;
                this.i18nService.update(null, I18nSupport.getI18nValue(formProperty), this.getSrcDataObject(), this.getBundleName(), this.designLocale, true);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private void internationalizeForm() {
        if (this.getI18nService() == null) {
            return;
        }
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            this.internationalizeComponent(rADComponent, true);
        }
        if (this.droppedValues != null) {
            this.droppedValues.clear();
        }
    }

    private void deinternationalizeForm() {
        if (this.getI18nService() == null) {
            return;
        }
        for (RADComponent rADComponent : this.formModel.getAllComponents()) {
            for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getComponentI18nProperties(rADComponent, true, false)) {
                if (!this.isExclusiveValue(i18nPropertyInfo)) continue;
                FormProperty formProperty = i18nPropertyInfo.property;
                I18nValue i18nValue = I18nSupport.getI18nValue(formProperty);
                try {
                    boolean bl = formProperty.isChangeFiring();
                    formProperty.setChangeFiring(false);
                    formProperty.setValue(new FormProperty.ValueWithEditor((Object)i18nValue.getValue(), formProperty.findDefaultEditor()));
                    formProperty.setChangeFiring(bl);
                    this.i18nService.update(i18nValue, null, this.getSrcDataObject(), this.getBundleName(), null, true);
                    this.addDroppedValue(formProperty, i18nValue);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
    }

    private void addDroppedValue(FormProperty formProperty, I18nValue i18nValue) {
        if (this.droppedValues == null) {
            this.droppedValues = new HashMap<Object, I18nValue>();
        }
        this.droppedValues.put((Object)formProperty, i18nValue);
    }

    public static void componentRenamed(RADComponent rADComponent, String string) {
        I18nSupport i18nSupport = I18nSupport.getI18nSupport(rADComponent);
        if (i18nSupport.isAutoMode()) {
            i18nSupport.renameAutoKeys(rADComponent, string);
        }
    }

    private void renameAutoKeys(RADComponent rADComponent, String string) {
        if (this.getI18nService() == null) {
            return;
        }
        assert (rADComponent != rADComponent.getFormModel().getTopRADComponent());
        for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getComponentI18nProperties(rADComponent, true, false)) {
            String string2 = this.getAutoKey(i18nPropertyInfo);
            I18nValue i18nValue = I18nSupport.getI18nValue(i18nPropertyInfo);
            if (!I18nSupport.isExclusiveValue(i18nValue, string2)) continue;
            String string3 = rADComponent.getName();
            String string4 = i18nPropertyInfo.path;
            int n = string4.indexOf(string3);
            String string5 = string4.substring(0, n) + string + string4.substring(n + string3.length());
            FormProperty formProperty = i18nPropertyInfo.property;
            String string6 = this.getAutoKey(string5, formProperty.getName());
            String string7 = i18nValue.getKey();
            if (string7.length() > string2.length()) {
                string6 = string6 + string7.substring(string2.length());
            }
            I18nValue i18nValue2 = this.i18nService.changeKey(i18nValue, string6);
            try {
                boolean bl = formProperty.isChangeFiring();
                formProperty.setChangeFiring(false);
                formProperty.setValue(i18nValue2);
                formProperty.setChangeFiring(bl);
                this.i18nService.update(i18nValue, i18nValue2, this.getSrcDataObject(), this.getBundleName(), this.designLocale, true);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    public static void propertyEditorChanging(FormProperty formProperty, PropertyEditor propertyEditor) {
        I18nSupport i18nSupport = I18nSupport.getI18nSupport(formProperty);
        if (i18nSupport.getI18nService() != null) {
            i18nSupport.markI18nProperty(formProperty, propertyEditor);
        }
    }

    private void markI18nProperty(FormProperty formProperty, PropertyEditor propertyEditor) {
        PropertyEditor propertyEditor2 = formProperty.getCurrentEditor();
        int n = this.i18nService.analyzePropertyEditorChange(propertyEditor2, propertyEditor);
        if (n < 0 && !Boolean.TRUE.equals(formProperty.getValue(EXCLUDE_I18N))) {
            formProperty.setValue(EXCLUDE_I18N, Boolean.TRUE);
            formProperty.setValue(PE_PLAIN_SET, Boolean.TRUE);
        } else if (n > 0 && Boolean.TRUE.equals(formProperty.getValue(EXCLUDE_I18N)) && Boolean.TRUE.equals(formProperty.getValue(PE_PLAIN_SET))) {
            formProperty.setValue(EXCLUDE_I18N, Boolean.FALSE);
        }
    }

    public static void updateStoredValue(Object object, Object object2, FormProperty formProperty, RADComponent rADComponent) {
        I18nSupport i18nSupport = I18nSupport.getI18nSupport(rADComponent);
        if (i18nSupport.getI18nService() == null) {
            return;
        }
        if (formProperty.getValueType() == String.class) {
            I18nValue i18nValue;
            I18nValue i18nValue2 = object instanceof I18nValue ? (I18nValue)object : null;
            I18nValue i18nValue3 = i18nValue = object2 instanceof I18nValue ? (I18nValue)object2 : null;
            if (i18nValue2 != null || i18nValue != null) {
                i18nSupport.updateValue(i18nValue2, i18nValue, I18nSupport.getComponentPath(rADComponent), formProperty.getName());
            }
        } else {
            String string = I18nSupport.getComponentPath(rADComponent);
            Collection<I18nPropertyInfo> collection = I18nSupport.getNestedI18nProperties(object, formProperty, string, true);
            Collection<I18nPropertyInfo> collection2 = I18nSupport.getNestedI18nProperties(object2, formProperty, string, true);
            for (I18nPropertyInfo i18nPropertyInfo : collection) {
                boolean bl = false;
                Object object3 = collection2.iterator();
                while (object3.hasNext()) {
                    I18nPropertyInfo i18nPropertyInfo2 = object3.next();
                    if (!i18nPropertyInfo2.sameProperty(i18nPropertyInfo)) continue;
                    I18nValue i18nValue = I18nSupport.getI18nValue(i18nPropertyInfo);
                    I18nValue i18nValue4 = I18nSupport.getI18nValue(i18nPropertyInfo2);
                    i18nSupport.updateValue(i18nValue, i18nValue4, i18nPropertyInfo2.path, i18nPropertyInfo2.property.getName());
                    object3.remove();
                    bl = true;
                    break;
                }
                if (bl) continue;
                object3 = I18nSupport.getI18nValue(i18nPropertyInfo);
                i18nSupport.updateValue((I18nValue)object3, null, i18nPropertyInfo.path, i18nPropertyInfo.property.getName());
            }
            for (I18nPropertyInfo i18nPropertyInfo : collection2) {
                I18nValue i18nValue = I18nSupport.getI18nValue(i18nPropertyInfo);
                i18nSupport.updateValue(null, i18nValue, i18nPropertyInfo.path, i18nPropertyInfo.property.getName());
            }
        }
    }

    private void updateValue(I18nValue i18nValue, I18nValue i18nValue2, String string, String string2) {
        try {
            this.i18nService.update(i18nValue, i18nValue2, this.getSrcDataObject(), this.getBundleName(), this.designLocale, I18nSupport.isExclusiveValue(i18nValue, this.getAutoKey(string, string2)));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public boolean isDefaultInternationalizableProject() {
        this.getI18nService();
        return this.i18nService != null ? this.i18nService.isDefaultInternationalizableProject(this.getSrcDataObject()) : false;
    }

    private void changeBundle(String string) {
        this.deinternationalizeForm();
        this.formModel.getSettings().setFormBundle(string);
        String string2 = this.designLocale;
        this.setDesignLocale(I18N_KEY_PREFIX);
        FormEditor.getFormEditor(this.formModel).getFormRootNode().firePropertyChangeHelper(PROP_DESIGN_LOCALE, string2, this.designLocale);
        this.internationalizeForm();
    }

    private void changeDesignLocale(String string) {
        this.setDesignLocale(string);
        this.updateDesignLocale();
        this.formModel.fireEvents(null);
    }

    private void setDesignLocale(String string) {
        this.designLocale = string;
        rememberedLocales.put(this.getSrcDataObject(), string);
    }

    private void updateDesignLocale() {
        if (this.getI18nService() == null) {
            return;
        }
        for (I18nPropertyInfo i18nPropertyInfo : this.getAllI18nProperties(true)) {
            FormProperty formProperty = i18nPropertyInfo.property;
            I18nValue i18nValue = I18nSupport.getI18nValue(formProperty);
            if (i18nValue == null) continue;
            try {
                boolean bl = formProperty.isChangeFiring();
                formProperty.setChangeFiring(false);
                formProperty.setValue(this.i18nService.switchLocale(i18nValue, this.designLocale));
                formProperty.setChangeFiring(bl);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    private Collection<I18nPropertyInfo> getAllI18nProperties(boolean bl) {
        Collection<RADComponent> collection = this.formModel.getAllComponents();
        ArrayList<I18nPropertyInfo> arrayList = new ArrayList<I18nPropertyInfo>(collection.size());
        for (RADComponent rADComponent : collection) {
            I18nSupport.collectI18nProperties(rADComponent, bl, false, arrayList);
        }
        return arrayList;
    }

    private static Collection<I18nPropertyInfo> getComponentI18nProperties(RADComponent rADComponent, boolean bl, boolean bl2) {
        Collection<I18nPropertyInfo> collection = I18nSupport.collectI18nProperties(rADComponent, bl, bl2, null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    private static Collection<I18nPropertyInfo> getNestedI18nProperties(Object object, FormProperty formProperty, String string, boolean bl) {
        Collection<I18nPropertyInfo> collection = I18nSupport.collectNestedI18nProperties(object, formProperty, string, bl, null);
        if (collection == null) {
            collection = Collections.emptyList();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<I18nPropertyInfo> collectI18nProperties(RADComponent rADComponent, boolean bl, boolean bl2, Collection<I18nPropertyInfo> collection) {
        Node.Property[] propertyArray;
        for (RADProperty rADProperty : rADComponent.getKnownBeanProperties()) {
            if (Boolean.TRUE.equals(rADProperty.getValue(EXCLUDE_I18N)) || !rADProperty.isChanged()) continue;
            collection = I18nSupport.collectNestedI18nProperties(rADProperty, I18nSupport.getComponentPath(rADComponent), bl, collection);
        }
        if (rADComponent instanceof RADVisualComponent && (propertyArray = ((RADVisualComponent)rADComponent).getConstraintsProperties()) != null) {
            void var7_13;
            Node.Property[] propertyArray2 = propertyArray;
            int n = propertyArray2.length;
            boolean bl3 = false;
            while (var7_13 < n) {
                FormProperty formProperty;
                Node.Property property = propertyArray2[var7_13];
                if (property instanceof FormProperty && !Boolean.TRUE.equals(property.getValue(EXCLUDE_I18N)) && (formProperty = (FormProperty)property).isChanged()) {
                    collection = I18nSupport.collectNestedI18nProperties(formProperty, I18nSupport.getComponentPath(rADComponent), bl, collection);
                }
                ++var7_13;
            }
        }
        if (bl2 && rADComponent instanceof ComponentContainer) {
            for (RADComponent rADComponent2 : ((ComponentContainer)((Object)rADComponent)).getSubBeans()) {
                collection = I18nSupport.collectI18nProperties(rADComponent2, bl, bl2, collection);
            }
        }
        return collection;
    }

    private static Collection<I18nPropertyInfo> collectNestedI18nProperties(Object object, FormProperty formProperty, String string, boolean bl, Collection<I18nPropertyInfo> collection) {
        Node.Property[] propertyArray = I18nSupport.getNestedProperties(object);
        if (propertyArray == null) {
            if (I18nSupport.isI18nType(formProperty.getValueType()) && !bl == I18nSupport.needsI18n(object)) {
                if (collection == null) {
                    collection = new LinkedList<I18nPropertyInfo>();
                }
                collection.add(new I18nPropertyInfo(formProperty, string));
            }
            return collection;
        }
        string = string != null ? string + "." + formProperty.getName() : formProperty.getName();
        for (Node.Property property : propertyArray) {
            if (!(property instanceof FormProperty)) continue;
            if (!Boolean.TRUE.equals(property.getValue(EXCLUDE_I18N))) {
                FormProperty formProperty2 = (FormProperty)property;
                if (!formProperty2.isChanged()) continue;
                collection = I18nSupport.collectNestedI18nProperties(formProperty2, string, bl, collection);
                continue;
            }
            if (!Boolean.TRUE.equals(property.getValue(PE_PLAIN_SET))) continue;
            property.setValue(EXCLUDE_I18N, (Object)Boolean.FALSE);
        }
        return collection;
    }

    private static boolean isI18nType(Class clazz) {
        return clazz == String.class;
    }

    private static boolean needsI18n(Object object) {
        if (object instanceof I18nValue) {
            I18nValue i18nValue = (I18nValue)object;
            return i18nValue.getKey() == "auto";
        }
        return object != null && I18nSupport.isI18nType(object.getClass());
    }

    private static Collection<I18nPropertyInfo> collectNestedI18nProperties(FormProperty formProperty, String string, boolean bl, Collection<I18nPropertyInfo> collection) {
        Object var4_4 = null;
        try {
            return I18nSupport.collectNestedI18nProperties(formProperty.getValue(), formProperty, string, bl, collection);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return collection;
        }
    }

    private static Node.Property[] getNestedProperties(Object object) {
        if (object instanceof BorderDesignSupport) {
            return ((BorderDesignSupport)object).getProperties();
        }
        return null;
    }

    private static I18nValue getI18nValue(I18nPropertyInfo i18nPropertyInfo) {
        return I18nSupport.getI18nValue(i18nPropertyInfo.property);
    }

    private static I18nValue getI18nValue(FormProperty formProperty) {
        try {
            I18nValue i18nValue;
            Object object = formProperty.getValue();
            if (object instanceof I18nValue && (i18nValue = (I18nValue)object).getKey() != "auto" && i18nValue.getKey() != "noi18n") {
                return i18nValue;
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        return null;
    }

    private boolean isExclusiveValue(I18nPropertyInfo i18nPropertyInfo) {
        I18nValue i18nValue = I18nSupport.getI18nValue(i18nPropertyInfo);
        return I18nSupport.isExclusiveValue(i18nValue, this.getAutoKey(i18nPropertyInfo));
    }

    private static boolean isExclusiveValue(I18nValue i18nValue, String string) {
        if (i18nValue == null) {
            return false;
        }
        String string2 = i18nValue.getKey();
        return string2 != null && string2 != "noi18n" && string2.startsWith(string);
    }

    private String getAutoKey(I18nPropertyInfo i18nPropertyInfo) {
        return this.getAutoKey(i18nPropertyInfo.path, i18nPropertyInfo.property.getName());
    }

    private String getAutoKey(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18N_KEY_PREFIX);
        stringBuilder.append(this.formModel.getName());
        if (string != null) {
            stringBuilder.append(".");
            stringBuilder.append(string);
        }
        stringBuilder.append(".");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static String getComponentPath(RADComponent rADComponent) {
        return rADComponent != rADComponent.getFormModel().getTopRADComponent() ? rADComponent.getName() : null;
    }

    private String getBundleName() {
        String string = this.formModel.getSettings().getFormBundle();
        if (string == null) {
            if (this.defaultBundle == null) {
                FileObject fileObject = this.getSrcDataObject().getPrimaryFile();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (classPath == null) {
                    return null;
                }
                String string2 = classPath.getResourceName(fileObject.getParent());
                this.defaultBundle = string2 != null && string2.length() > 0 ? string2 + "/" + DEFAULT_BUNDLE_NAME : DEFAULT_BUNDLE_NAME;
            }
            string = this.defaultBundle;
        }
        return string;
    }

    DataObject getSrcDataObject() {
        return FormEditor.getFormDataObject(this.formModel);
    }

    boolean isAutoMode() {
        return this.formModel.getSettings().getI18nAutoMode();
    }

    String getDesignLocale() {
        return this.designLocale;
    }

    Node.Property[] createFormProperties() {
        PropertySupport.ReadWrite readWrite = new PropertySupport.ReadWrite("i18nAutoMode", Boolean.TYPE, FormUtils.getBundleString("PROP_AUTO_I18N"), FormUtils.getBundleString("HINT_AUTO_I18N_LOCAL")){

            public void setValue(Object object) {
                Boolean bl;
                Boolean bl2 = bl = I18nSupport.this.isAutoMode() ? Boolean.TRUE : Boolean.FALSE;
                if (!bl.equals(object)) {
                    boolean bl3 = (Boolean)object;
                    I18nSupport.this.formModel.getSettings().setI18nAutoMode(bl3);
                    if (bl3) {
                        I18nSupport.this.internationalizeForm();
                    } else {
                        I18nSupport.this.deinternationalizeForm();
                    }
                    I18nSupport.this.formModel.fireSyntheticPropertyChanged(null, "i18nAutoMode", bl, object);
                    FormEditor.getFormEditor(I18nSupport.this.formModel).getFormRootNode().firePropertyChangeHelper("i18nAutoMode", bl, object);
                }
            }

            public Object getValue() {
                return I18nSupport.this.isAutoMode() ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        PropertySupport.ReadWrite readWrite2 = new PropertySupport.ReadWrite(PROP_FORM_BUNDLE, String.class, FormUtils.getBundleString("PROP_FORM_BUNDLE"), FormUtils.getBundleString("HINT_FORM_BUNDLE")){

            public void setValue(Object object) {
                String string = I18nSupport.this.getBundleName();
                if (string == null && object != null || !string.equals(object)) {
                    String string2 = (String)object;
                    if (string2 != null && string2.toLowerCase().endsWith(".properties")) {
                        string2 = string2.substring(0, string2.length() - ".properties".length());
                    }
                    I18nSupport.this.changeBundle(string2);
                    I18nSupport.this.formModel.fireSyntheticPropertyChanged(null, I18nSupport.PROP_FORM_BUNDLE, string, object);
                    FormEditor.getFormEditor(I18nSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(I18nSupport.PROP_FORM_BUNDLE, string, object);
                }
            }

            public Object getValue() {
                return I18nSupport.this.getBundleName();
            }

            public PropertyEditor getPropertyEditor() {
                return new BundleFilePropertyEditor();
            }
        };
        PropertySupport.ReadWrite readWrite3 = new PropertySupport.ReadWrite(PROP_DESIGN_LOCALE, String.class, FormUtils.getBundleString("PROP_DESIGN_LOCALE"), FormUtils.getBundleString("HINT_DESIGN_LOCALE")){

            public void setValue(Object object) {
                String string = I18nSupport.this.designLocale;
                I18nSupport.this.changeDesignLocale((String)object);
                I18nSupport.this.formModel.fireSyntheticPropertyChanged(null, I18nSupport.PROP_DESIGN_LOCALE, string, object);
                FormEditor.getFormEditor(I18nSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(I18nSupport.PROP_DESIGN_LOCALE, string, object);
            }

            public Object getValue() {
                return I18nSupport.this.designLocale;
            }

            public PropertyEditor getPropertyEditor() {
                return new LocalePropertyEditor();
            }
        };
        return new Node.Property[]{readWrite, readWrite2, readWrite3};
    }

    private class BundleFilePropertyEditor
    extends PropertyEditorSupport {
        private BundleFilePropertyEditor() {
        }

        public boolean supportsCustomEditor() {
            return I18nSupport.this.getI18nService() != null;
        }

        public Component getCustomEditor() {
            return I18nSupport.this.getI18nService() != null ? I18nSupport.this.i18nService.getBundleSelectionComponent(this, I18nSupport.this.getSrcDataObject()) : null;
        }
    }

    private static class I18nPropertyInfo {
        private FormProperty property;
        private String path;

        I18nPropertyInfo(FormProperty formProperty, String string) {
            this.property = formProperty;
            this.path = string;
        }

        boolean sameProperty(I18nPropertyInfo i18nPropertyInfo) {
            return this.path.equals(i18nPropertyInfo.path) && this.property.getName().equals(this.property.getName());
        }
    }

    private class LocalePropertyEditor
    extends PropertyEditorSupport {
        private String[][] tags;

        private LocalePropertyEditor() {
        }

        public String[] getTags() {
            DataObject dataObject;
            if (I18nSupport.this.getI18nService() == null) {
                return null;
            }
            if (this.tags == null && (dataObject = I18nSupport.this.getSrcDataObject()) != null) {
                this.tags = I18nSupport.this.i18nService.getAvailableLocales(dataObject, I18nSupport.this.getBundleName());
            }
            return this.tags != null ? this.tags[1] : null;
        }

        public void setAsText(String string) {
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[1][i].equals(string)) continue;
                    this.setValue(this.tags[0][i]);
                    return;
                }
            }
            this.setValue(string);
        }

        public String getAsText() {
            Object object = this.getValue();
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[0][i].equals(object)) continue;
                    return this.tags[1][i];
                }
            }
            return object != null ? object.toString() : null;
        }

        public boolean supportsCustomEditor() {
            return I18nSupport.this.getI18nService() != null && this.getTags() != null;
        }

        public Component getCustomEditor() {
            return I18nSupport.this.getI18nService() != null && this.getTags() != null ? I18nSupport.this.i18nService.getCreateLocaleComponent(this, I18nSupport.this.getSrcDataObject(), I18nSupport.this.getBundleName()) : null;
        }
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        public void formChanged(FormModelEvent[] formModelEventArray) {
            if (I18nSupport.this.getI18nService() == null) {
                return;
            }
            if (formModelEventArray == null) {
                return;
            }
            block10: for (int i = 0; i < formModelEventArray.length; ++i) {
                FormModelEvent formModelEvent = formModelEventArray[i];
                switch (formModelEvent.getChangeType()) {
                    case 8: {
                        for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getComponentI18nProperties(formModelEvent.getComponent(), true, true)) {
                            if (!I18nSupport.this.isExclusiveValue(i18nPropertyInfo)) continue;
                            try {
                                I18nSupport.this.i18nService.update(I18nSupport.getI18nValue(i18nPropertyInfo), null, I18nSupport.this.getSrcDataObject(), I18nSupport.this.getBundleName(), null, true);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        continue block10;
                    }
                    case 7: {
                        for (I18nPropertyInfo i18nPropertyInfo : I18nSupport.getComponentI18nProperties(formModelEvent.getComponent(), true, true)) {
                            I18nValue i18nValue = I18nSupport.getI18nValue(i18nPropertyInfo);
                            if (i18nValue == null) continue;
                            try {
                                I18nSupport.this.i18nService.update(null, i18nValue, I18nSupport.this.getSrcDataObject(), I18nSupport.this.getBundleName(), I18nSupport.this.designLocale, false);
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            }
                        }
                        continue block10;
                    }
                    case 2: {
                        if (I18nSupport.this.i18nService == null) continue block10;
                        I18nSupport.this.i18nService.autoSave(I18nSupport.this.getSrcDataObject());
                        continue block10;
                    }
                    case 3: {
                        if (I18nSupport.this.i18nService == null) continue block10;
                        I18nSupport.this.i18nService.close(I18nSupport.this.getSrcDataObject());
                    }
                }
            }
        }
    }
}

