/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.MethodDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.ParametersPicker;
import org.netbeans.modules.form.RADComponent;
import org.openide.awt.Mnemonics;

public class MethodPicker
extends JPanel {
    static final long serialVersionUID = 7355140527892160804L;
    private JLabel componentLabel;
    private JComboBox componentsCombo;
    private JLabel listLabel;
    private JList methodList;
    private JScrollPane propertiesScrollPane;
    private boolean pickerValid = false;
    private RADComponent[] components;
    private Class requiredType;
    private MethodPickerItem[] items;
    private RADComponent selectedComponent;
    private static Class[] NO_PARAMETERS = new Class[0];

    public MethodPicker(FormModel formModel, RADComponent rADComponent, Class clazz) {
        this.requiredType = clazz;
        this.initComponents();
        List<RADComponent> list = formModel.getComponentList();
        Collections.sort(list, new ParametersPicker.ComponentComparator());
        this.components = new RADComponent[list.size()];
        list.toArray(this.components);
        int n = -1;
        for (RADComponent rADComponent2 : list) {
            if (rADComponent != null && rADComponent == rADComponent2) {
                n = this.componentsCombo.getItemCount();
            }
            if (rADComponent2 == formModel.getTopRADComponent()) {
                this.componentsCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                continue;
            }
            this.componentsCombo.addItem(rADComponent2.getName());
        }
        if (n >= 0) {
            this.componentsCombo.setSelectedIndex(n);
        }
        this.updateMethodList();
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)FormUtils.getBundleString("CTL_CW_Component"));
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)FormUtils.getBundleString("CTL_CW_MethodList"));
        this.componentsCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Component"));
        this.methodList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodList"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_MethodPicker"));
    }

    public boolean isPickerValid() {
        return this.pickerValid;
    }

    private void setPickerValid(boolean bl) {
        boolean bl2 = this.pickerValid;
        this.pickerValid = bl;
        this.firePropertyChange("pickerValid", bl2, this.pickerValid);
    }

    RADComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(RADComponent rADComponent) {
        if (rADComponent != null) {
            this.componentsCombo.setSelectedItem(rADComponent.getName());
        }
    }

    MethodPickerItem getSelectedMethod() {
        if (this.selectedComponent == null || this.methodList.getSelectedIndex() == -1) {
            return null;
        }
        return this.items[this.methodList.getSelectedIndex()];
    }

    void setSelectedMethod(MethodDescriptor methodDescriptor) {
        if (methodDescriptor == null) {
            this.methodList.setSelectedIndex(-1);
        } else {
            this.methodList.setSelectedValue(FormUtils.getMethodName(methodDescriptor), true);
        }
    }

    private void addComponentsRecursively(ComponentContainer componentContainer, Vector vector) {
        RADComponent[] rADComponentArray = componentContainer.getSubBeans();
        for (int i = 0; i < rADComponentArray.length; ++i) {
            vector.addElement(rADComponentArray[i]);
            if (!(rADComponentArray[i] instanceof ComponentContainer)) continue;
            this.addComponentsRecursively((ComponentContainer)((Object)rADComponentArray[i]), vector);
        }
    }

    private void updateMethodList() {
        RADComponent rADComponent = this.getSelectedComponent();
        if (rADComponent == null) {
            this.methodList.setListData(new Object[0]);
            this.methodList.revalidate();
            this.methodList.repaint();
        } else {
            MethodDescriptor[] methodDescriptorArray = rADComponent.getBeanInfo().getMethodDescriptors();
            HashMap<String, MethodPickerItem> hashMap = new HashMap<String, MethodPickerItem>();
            for (int i = 0; i < methodDescriptorArray.length; ++i) {
                if (!this.requiredType.isAssignableFrom(methodDescriptorArray[i].getMethod().getReturnType()) || methodDescriptorArray[i].getMethod().getParameterTypes().length != 0) continue;
                MethodPickerItem methodPickerItem = this.createItem(methodDescriptorArray[i]);
                hashMap.put(methodPickerItem.getMethodName(), methodPickerItem);
            }
            if (rADComponent == rADComponent.getFormModel().getTopRADComponent()) {
                String[] stringArray = FormEditor.getFormJavaSource(rADComponent.getFormModel()).getMethodNames(this.requiredType);
                for (int i = 0; i < stringArray.length; ++i) {
                    MethodPickerItem methodPickerItem = this.createItem(stringArray[i]);
                    if (hashMap.containsKey(methodPickerItem.getMethodName())) continue;
                    hashMap.put(methodPickerItem.getMethodName(), methodPickerItem);
                }
            }
            this.items = new MethodPickerItem[hashMap.size()];
            hashMap.values().toArray(this.items);
            Arrays.sort(this.items, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((MethodPickerItem)object).getMethodName().compareTo(((MethodPickerItem)object2).getMethodName());
                }
            });
            String[] stringArray = new String[this.items.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.items[i].getMethodName();
            }
            this.methodList.setListData(stringArray);
            this.methodList.revalidate();
            this.methodList.repaint();
        }
    }

    private MethodPickerItem createItem(final MethodDescriptor methodDescriptor) {
        return new MethodPickerItem(){
            private String name;
            {
                this.name = FormUtils.getMethodName(methodDescriptor);
            }

            public String getMethodName() {
                return this.name;
            }

            public Class[] getParameterTypes() {
                return methodDescriptor.getMethod().getParameterTypes();
            }

            public boolean providesMethodDescriptor() {
                return true;
            }

            public MethodDescriptor getMethodDescriptor() {
                return methodDescriptor;
            }
        };
    }

    private MethodPickerItem createItem(final String string) {
        return new MethodPickerItem(){
            private String name;
            {
                this.name = FormUtils.getMethodName(string, NO_PARAMETERS);
            }

            public String getMethodName() {
                return this.name;
            }

            public Class[] getParameterTypes() {
                return NO_PARAMETERS;
            }

            public boolean providesMethodDescriptor() {
                return false;
            }

            public MethodDescriptor getMethodDescriptor() {
                return null;
            }
        };
    }

    private void updateState() {
        if (this.getSelectedComponent() == null || this.getSelectedMethod() == null) {
            this.setPickerValid(false);
        } else {
            this.setPickerValid(this.getSelectedMethod().getParameterTypes().length == 0);
        }
    }

    private void initComponents() {
        this.componentLabel = new JLabel();
        this.componentsCombo = new JComboBox();
        this.listLabel = new JLabel();
        this.propertiesScrollPane = new JScrollPane();
        this.methodList = new JList();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        this.componentLabel.setLabelFor(this.componentsCombo);
        this.componentLabel.setText("Component:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 6);
        this.add((Component)this.componentLabel, gridBagConstraints);
        this.componentsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MethodPicker.this.componentsComboItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.componentsCombo, gridBagConstraints);
        this.listLabel.setLabelFor(this.methodList);
        this.listLabel.setText("Methods");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.listLabel, gridBagConstraints);
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MethodPicker.this.methodListValueChanged(listSelectionEvent);
            }
        });
        this.propertiesScrollPane.setViewportView(this.methodList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.propertiesScrollPane, gridBagConstraints);
    }

    private void methodListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateState();
    }

    private void componentsComboItemStateChanged(ItemEvent itemEvent) {
        this.selectedComponent = this.componentsCombo.getSelectedIndex() == -1 ? null : this.components[this.componentsCombo.getSelectedIndex()];
        this.updateMethodList();
    }

    static interface MethodPickerItem {
        public String getMethodName();

        public Class[] getParameterTypes();

        public MethodDescriptor getMethodDescriptor();
    }
}

