/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.beans.PropertyEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class FormCodeSupport {
    public static CodeExpressionOrigin createOrigin(Node.Property property) {
        if (property instanceof FormProperty) {
            return new FormPropertyValueOrigin((FormProperty)property);
        }
        return new PropertyValueOrigin(property);
    }

    public static CodeExpressionOrigin createOrigin(Class clazz, PropertyEditor propertyEditor) {
        return new PropertyEditorOrigin(clazz, propertyEditor);
    }

    public static CodeExpressionOrigin createOrigin(RADComponent rADComponent) {
        return new RADComponentOrigin(rADComponent);
    }

    public static void readPropertyExpression(CodeExpression codeExpression, Node.Property property, boolean bl) {
        FormProperty formProperty;
        FormProperty formProperty2 = formProperty = property instanceof FormProperty ? (FormProperty)property : null;
        if (formProperty != null) {
            Object object;
            if (!bl) {
                if (formProperty.isChangeFiring()) {
                    formProperty.setChangeFiring(false);
                } else {
                    bl = true;
                }
            }
            if ((object = codeExpression.getOrigin().getMetaObject()) instanceof PropertyEditor) {
                formProperty.setCurrentEditor((PropertyEditor)object);
            }
        }
        try {
            property.setValue(codeExpression.getOrigin().getValue());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
        codeExpression.setOrigin(FormCodeSupport.createOrigin(property));
        if (formProperty != null && !bl) {
            formProperty.setChangeFiring(true);
        }
    }

    public static void readPropertyStatement(CodeStatement codeStatement, Node.Property property, boolean bl) {
        CodeExpression[] codeExpressionArray = codeStatement.getStatementParameters();
        if (codeExpressionArray.length != 1) {
            throw new IllegalArgumentException();
        }
        FormCodeSupport.readPropertyExpression(codeExpressionArray[0], property, bl);
    }

    static final class FormPropertyValueOrigin
    implements CodeExpressionOrigin {
        private FormProperty property;

        public FormPropertyValueOrigin(FormProperty formProperty) {
            this.property = formProperty;
        }

        public Class getType() {
            return this.property.getValueType();
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getValue() {
            try {
                return this.property.getRealValue();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Object getMetaObject() {
            return this.property;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            return this.property.getJavaInitializationString();
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }

    static final class PropertyEditorOrigin
    implements CodeExpressionOrigin {
        private Class type;
        private PropertyEditor propertyEditor;

        public PropertyEditorOrigin(Class clazz, PropertyEditor propertyEditor) {
            this.type = clazz;
            this.propertyEditor = propertyEditor;
        }

        public Class getType() {
            return this.type;
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getValue() {
            return this.propertyEditor.getValue();
        }

        public Object getMetaObject() {
            return this.propertyEditor;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            return this.propertyEditor.getJavaInitializationString();
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }

    static final class PropertyValueOrigin
    implements CodeExpressionOrigin {
        private Node.Property property;

        public PropertyValueOrigin(Node.Property property) {
            this.property = property;
        }

        public Class getType() {
            return this.property.getValueType();
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getValue() {
            try {
                return this.property.getValue();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public Object getMetaObject() {
            return this.property;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            try {
                PropertyEditor propertyEditor = this.property.getPropertyEditor();
                propertyEditor.setValue(this.property.getValue());
                return propertyEditor.getJavaInitializationString();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }
    }

    static final class RADComponentOrigin
    implements CodeExpressionOrigin {
        private RADComponent component;

        public RADComponentOrigin(RADComponent rADComponent) {
            this.component = rADComponent;
        }

        public Class getType() {
            return this.component.getBeanClass();
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getMetaObject() {
            return this.component;
        }

        public Object getValue() {
            return this.component.getBeanInstance();
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            if (this.component == this.component.getFormModel().getTopRADComponent()) {
                return "this";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("new ");
            stringBuffer.append(this.component.getBeanClass().getName().replace('&', '.'));
            stringBuffer.append("()");
            return stringBuffer.toString();
        }
    }
}

