/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutCodeGenerator {
    private static final String LAYOUT_VAR_NAME = "layout";
    private LayoutModel layoutModel;
    private String layoutVarName;
    private boolean useLayoutLibrary;
    private Map componentIDMap = new HashMap();

    public SwingLayoutCodeGenerator(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    public void generateContainerLayout(Writer writer, LayoutComponent layoutComponent, String string, String string2, ComponentInfo[] componentInfoArray, boolean bl) throws IOException {
        this.useLayoutLibrary = bl;
        this.layoutVarName = string2 == null ? LAYOUT_VAR_NAME : string2 + Character.toUpperCase(LAYOUT_VAR_NAME.charAt(0)) + LAYOUT_VAR_NAME.substring(1);
        this.fillMap(componentInfoArray);
        this.generateInstantiation(writer, string);
        StringBuffer stringBuffer = new StringBuffer();
        LayoutInterval layoutInterval = layoutComponent.getLayoutRoot(0);
        this.composeGroup(stringBuffer, layoutInterval, true, true);
        String string3 = stringBuffer.toString();
        writer.write(this.layoutVarName + ".setHorizontalGroup(\n" + string3 + "\n);\n");
        stringBuffer = new StringBuffer();
        this.composeLinks(stringBuffer, layoutComponent, this.layoutVarName, 0);
        String string4 = stringBuffer.toString();
        writer.write(string4);
        stringBuffer = new StringBuffer();
        LayoutInterval layoutInterval2 = layoutComponent.getLayoutRoot(1);
        this.composeGroup(stringBuffer, layoutInterval2, true, true);
        String string5 = stringBuffer.toString();
        writer.write(this.layoutVarName + ".setVerticalGroup(\n" + string5 + "\n);\n");
        stringBuffer = new StringBuffer();
        this.composeLinks(stringBuffer, layoutComponent, this.layoutVarName, 1);
        String string6 = stringBuffer.toString();
        writer.write(string6);
    }

    private void fillMap(ComponentInfo[] componentInfoArray) {
        for (int i = 0; i < componentInfoArray.length; ++i) {
            this.componentIDMap.put(componentInfoArray[i].id, componentInfoArray[i]);
        }
    }

    private void generateInstantiation(Writer writer, String string) throws IOException {
        writer.write(this.getLayoutName() + " " + this.layoutVarName + " ");
        writer.write("= new " + this.getLayoutName() + "(" + string + ");\n");
        writer.write(string + ".setLayout(" + this.layoutVarName + ");\n");
    }

    private void composeGroup(StringBuffer stringBuffer, LayoutInterval layoutInterval, boolean bl, boolean bl2) throws IOException {
        if (layoutInterval.isGroup()) {
            Object object;
            int n = layoutInterval.getGroupAlignment();
            if (layoutInterval.isParallel()) {
                boolean bl3 = layoutInterval.getMaximumSize(false) == -2;
                object = this.convertAlignment(n);
                stringBuffer.append(this.layoutVarName).append(".createParallelGroup(");
                stringBuffer.append((String)object);
                if (bl3) {
                    stringBuffer.append(", false");
                }
                stringBuffer.append(")");
            } else if (layoutInterval.isSequential()) {
                stringBuffer.append(this.layoutVarName).append(".createSequentialGroup()");
            } else assert (false);
            if (layoutInterval.getSubIntervalCount() > 0) {
                stringBuffer.append("\n");
            }
            Iterator iterator = layoutInterval.getSubIntervals();
            while (iterator.hasNext()) {
                object = (LayoutInterval)iterator.next();
                this.fillGroup(stringBuffer, (LayoutInterval)object, bl, bl2 && (!layoutInterval.isSequential() || !iterator.hasNext()), n);
                if (bl && layoutInterval.isSequential()) {
                    bl = false;
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(this.layoutVarName).append(".createSequentialGroup()\n");
            this.fillGroup(stringBuffer, layoutInterval, true, true, -1);
        }
    }

    private void fillGroup(StringBuffer stringBuffer, LayoutInterval layoutInterval, boolean bl, boolean bl2, int n) throws IOException {
        if (layoutInterval.isGroup()) {
            stringBuffer.append(this.getAddGroupStr());
            int n2 = layoutInterval.getAlignment();
            if (n2 != -1 && layoutInterval.getParent().isParallel() && n2 != n && n2 != 3 && n != 3) {
                String string = this.convertAlignment(n2);
                stringBuffer.append(string).append(", ");
            }
            this.composeGroup(stringBuffer, layoutInterval, bl, bl2);
        } else {
            int n3 = layoutInterval.getMinimumSize(false);
            int n4 = layoutInterval.getPreferredSize(false);
            int n5 = layoutInterval.getMaximumSize(false);
            if (layoutInterval.isComponent()) {
                int n6;
                stringBuffer.append(this.getAddComponentStr());
                int n7 = layoutInterval.getAlignment();
                LayoutComponent layoutComponent = layoutInterval.getComponent();
                ComponentInfo componentInfo = (ComponentInfo)this.componentIDMap.get(layoutComponent.getId());
                if (n3 == -1) {
                    int n8 = n6 = layoutComponent.getLayoutInterval(0) == layoutInterval ? 0 : 1;
                    if (n6 == 0 && componentInfo.clazz.getName().equals("javax.swing.JComboBox")) {
                        n3 = 0;
                    } else if (n4 >= 0) {
                        int n9;
                        int n10 = n9 = n6 == 0 ? componentInfo.minSize.width : componentInfo.minSize.height;
                        if (n9 > n4) {
                            n3 = -2;
                        }
                    }
                }
                assert (componentInfo.variableName != null);
                if (layoutInterval.getParent().isSequential() || n7 == -1 || n7 == n || n7 == 3 || n == 3) {
                    stringBuffer.append(componentInfo.variableName);
                } else {
                    String string = this.convertAlignment(n7);
                    if (this.useLayoutLibrary()) {
                        stringBuffer.append(string).append(", ").append(componentInfo.variableName);
                    } else {
                        stringBuffer.append(componentInfo.variableName).append(", ").append(string);
                    }
                }
                n6 = SwingLayoutUtils.getResizableStatus(componentInfo.clazz);
                if (n4 != -1 || n3 != -1 && (n3 != -2 || componentInfo.sizingChanged || n6 != 0) || n5 != -1 && (n5 != -2 || componentInfo.sizingChanged || n6 != 0) && (n5 != Short.MAX_VALUE || componentInfo.sizingChanged || n6 != 1)) {
                    stringBuffer.append(", ");
                    this.generateSizeParams(stringBuffer, n3, n4, n5);
                }
            } else if (layoutInterval.isEmptySpace()) {
                if (layoutInterval.isDefaultPadding(false)) {
                    if (bl || bl2) {
                        stringBuffer.append(this.getAddContainerGapStr());
                    } else {
                        stringBuffer.append(this.getAddPreferredGapStr());
                        stringBuffer.append(this.getLayoutStyleName());
                        if (!this.useLayoutLibrary()) {
                            stringBuffer.append(".ComponentPlacement");
                        }
                        stringBuffer.append(".RELATED");
                    }
                    if (n4 != -1 || n5 != -1 && n5 != -2) {
                        if (!bl && !bl2) {
                            stringBuffer.append(',').append(' ');
                        }
                        stringBuffer.append(this.convertSize(n4)).append(", ");
                        stringBuffer.append(this.convertSize(n5));
                    }
                } else {
                    if (n3 == -2) {
                        n3 = n4;
                    }
                    if (n5 == -2) {
                        n5 = n4;
                    }
                    stringBuffer.append(this.getAddGapStr());
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    n3 = Math.min(n4, n3);
                    n5 = Math.max(n4, n5);
                    this.generateSizeParams(stringBuffer, n3, n4, n5);
                }
            } else assert (false);
        }
        stringBuffer.append(")");
    }

    private void generateSizeParams(StringBuffer stringBuffer, int n, int n2, int n3) {
        stringBuffer.append(this.convertSize(n)).append(", ");
        stringBuffer.append(this.convertSize(n2)).append(", ");
        stringBuffer.append(this.convertSize(n3));
    }

    private String convertAlignment(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "LEADING";
                break;
            }
            case 1: {
                string = "TRAILING";
                break;
            }
            case 2: {
                string = "CENTER";
                break;
            }
            case 3: {
                string = "BASELINE";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.useLayoutLibrary() ? this.getLayoutName() + "." + string : this.getLayoutName() + ".Alignment." + string;
    }

    private String convertSize(int n) {
        String string;
        switch (n) {
            case -1: {
                string = this.getLayoutName() + ".DEFAULT_SIZE";
                break;
            }
            case -2: {
                string = this.getLayoutName() + ".PREFERRED_SIZE";
                break;
            }
            case 32767: {
                string = "Short.MAX_VALUE";
                break;
            }
            default: {
                assert (n >= 0);
                string = Integer.toString(n);
            }
        }
        return string;
    }

    private void composeLinks(StringBuffer stringBuffer, LayoutComponent layoutComponent, String string, int n) throws IOException {
        Map map = SwingLayoutUtils.createLinkSizeGroups(layoutComponent, n);
        Collection collection = map.values();
        for (List list : collection) {
            Collections.sort(list, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = (String)object;
                    String string2 = (String)object2;
                    ComponentInfo componentInfo = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(string);
                    ComponentInfo componentInfo2 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(string2);
                    return componentInfo.variableName.compareTo(componentInfo2.variableName);
                }
            });
            if (list.size() <= 1) continue;
            stringBuffer.append("\n\n" + string + ".linkSize(");
            if (!this.useLayoutLibrary()) {
                stringBuffer.append("javax.swing.SwingConstants");
                stringBuffer.append(n == 0 ? ".HORIZONTAL, " : ".VERTICAL, ");
            }
            stringBuffer.append("new java.awt.Component[] {");
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ComponentInfo componentInfo = (ComponentInfo)this.componentIDMap.get(string2);
                if (bl) {
                    bl = false;
                    stringBuffer.append(componentInfo.variableName);
                    continue;
                }
                stringBuffer.append(", " + componentInfo.variableName);
            }
            stringBuffer.append("}");
            if (this.useLayoutLibrary()) {
                stringBuffer.append(", ");
                stringBuffer.append(this.getLayoutName());
                stringBuffer.append(n == 0 ? ".HORIZONTAL" : ".VERTICAL");
            }
            stringBuffer.append(");\n\n");
        }
    }

    boolean useLayoutLibrary() {
        return this.useLayoutLibrary;
    }

    private String getLayoutName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.GroupLayout" : "javax.swing.GroupLayout";
    }

    private String getLayoutStyleName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.LayoutStyle" : "javax.swing.LayoutStyle";
    }

    private String getAddComponentStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addComponent(";
    }

    private String getAddGapStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGap(";
    }

    private String getAddPreferredGapStr() {
        return ".addPreferredGap(";
    }

    private String getAddContainerGapStr() {
        return ".addContainerGap(";
    }

    private String getAddGroupStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGroup(";
    }

    public static class ComponentInfo {
        public String id;
        public String variableName;
        public Class clazz;
        public Dimension minSize;
        public boolean sizingChanged;
    }
}

