/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.ChooseBeansWizardPanel;
import org.netbeans.modules.form.palette.ChooseCategoryWizardPanel;
import org.netbeans.modules.form.palette.ChooseJARWizardPanel;
import org.netbeans.modules.form.palette.ChooseLibraryWizardPanel;
import org.netbeans.modules.form.palette.ChooseProjectWizardPanel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

class AddToPaletteWizard
extends WizardDescriptor {
    ATPWizardIterator wizardIterator;
    private File[] selectedFiles;
    private BeanInstaller.ItemInfo[] selectedBeans;
    private String selectedCategory;
    private String sourceType;
    Map libraryNameMap;
    private Dialog dialog;

    public AddToPaletteWizard() {
        this(new ATPWizardIterator());
    }

    private AddToPaletteWizard(ATPWizardIterator aTPWizardIterator) {
        super((WizardDescriptor.Iterator)aTPWizardIterator);
        this.wizardIterator = aTPWizardIterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(PaletteUtils.getBundleString("CTL_AddToPaletteWizard_Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    public boolean show(String string) {
        String string2;
        this.sourceType = string;
        if ("jar".equals(string)) {
            string2 = "CTL_SelectJAR_Step";
        } else if ("library".equals(string)) {
            string2 = "CTL_SelectLibrary_Step";
        } else if ("project".equals(string)) {
            string2 = "CTL_SelectProject_Step";
        } else {
            throw new IllegalArgumentException();
        }
        this.putProperty("WizardPanel_contentData", new String[]{PaletteUtils.getBundleString(string2), PaletteUtils.getBundleString("CTL_SelectBeans_Step"), PaletteUtils.getBundleString("CTL_SelectCategory_Step")});
        this.libraryNameMap = null;
        this.wizardIterator.setSourceType(string);
        this.updateState();
        if (this.dialog == null) {
            this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        }
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.getValue() == FINISH_OPTION;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    void setJARFiles(File[] fileArray) {
        this.selectedFiles = fileArray;
    }

    File[] getJARFiles() {
        return this.selectedFiles;
    }

    void setSelectedBeans(BeanInstaller.ItemInfo[] itemInfoArray) {
        this.selectedBeans = itemInfoArray;
    }

    BeanInstaller.ItemInfo[] getSelectedBeans() {
        return this.selectedBeans;
    }

    void setSelectedCategory(String string) {
        this.selectedCategory = string;
    }

    String getSelectedCategory() {
        return this.selectedCategory;
    }

    String getSourceType() {
        return this.sourceType;
    }

    static class ATPWizardIterator
    implements WizardDescriptor.Iterator {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[ATPWizardIterator.getPanelsCount()];
        int stage;

        ATPWizardIterator() {
        }

        void setSourceType(String string) {
            if ("jar".equals(string)) {
                this.panels[0] = new ChooseJARWizardPanel();
            } else if ("library".equals(string)) {
                this.panels[0] = new ChooseLibraryWizardPanel();
            } else if ("project".equals(string)) {
                this.panels[0] = new ChooseProjectWizardPanel();
            } else {
                throw new IllegalArgumentException();
            }
            this.panels[1] = new ChooseBeansWizardPanel();
            this.panels[2] = new ChooseCategoryWizardPanel();
            this.stage = 1;
        }

        static int getPanelsCount() {
            return 3;
        }

        public WizardDescriptor.Panel current() {
            return this.panels[this.stage - 1];
        }

        public boolean hasNext() {
            return this.stage < ATPWizardIterator.getPanelsCount();
        }

        public boolean hasPrevious() {
            return this.stage > 1;
        }

        public String name() {
            return "";
        }

        public void nextPanel() {
            if (this.stage < ATPWizardIterator.getPanelsCount()) {
                ++this.stage;
            }
        }

        public void previousPanel() {
            if (this.stage > 1) {
                --this.stage;
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

