/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

class ChooseProjectWizardPanel
implements WizardDescriptor.Panel {
    private JFileChooser projectChooser;
    private static String lastDirectoryUsed;
    private EventListenerList listenerList;

    ChooseProjectWizardPanel() {
    }

    public Component getComponent() {
        if (this.projectChooser == null) {
            this.projectChooser = ProjectChooser.projectChooser();
            this.projectChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.projectChooser.setName(PaletteUtils.getBundleString("CTL_SelectProject_Caption"));
            this.projectChooser.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            if (lastDirectoryUsed != null) {
                this.projectChooser.setCurrentDirectory(new File(lastDirectoryUsed));
            }
            this.projectChooser.setControlButtonsAreShown(false);
            this.projectChooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(string) || "directoryChanged".equals(string)) {
                        ChooseProjectWizardPanel.this.fireStateChanged();
                    }
                }
            });
        }
        return this.projectChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        File file;
        if (this.projectChooser != null && (file = this.projectChooser.getSelectedFile()) != null) {
            file = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project != null) {
                    lastDirectoryUsed = this.projectChooser.getCurrentDirectory().getAbsolutePath();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void readSettings(Object object) {
    }

    public void storeSettings(Object object) {
        if (this.projectChooser == null) {
            return;
        }
        File file = this.projectChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        file = FileUtil.normalizeFile((File)file);
        Project project = null;
        try {
            project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (project == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        for (int i = 0; i < antArtifactArray.length; ++i) {
            URI uRI = antArtifactArray[i].getScriptLocation().toURI();
            URI[] uRIArray = antArtifactArray[i].getArtifactLocations();
            for (int j = 0; j < uRIArray.length; ++j) {
                File file2 = new File(uRI.resolve(uRIArray[j]).normalize());
                arrayList.add(file2);
            }
        }
        File[] fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        ((AddToPaletteWizard)((Object)object)).setJARFiles(fileArray);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

