/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public final class PaletteItem
implements Node.Cookie {
    private PaletteItemDataObject itemDataObject;
    ClassSource componentClassSource;
    String componentType_explicit;
    private Class componentClass;
    private Throwable lastError;
    private int componentType = -1;
    private static final int LAYOUT = 1;
    private static final int BORDER = 2;
    private static final int VISUAL = 4;
    private static final int MENU = 8;
    private static final int TYPE_MASK = 15;

    PaletteItem(PaletteItemDataObject paletteItemDataObject) {
        this.itemDataObject = paletteItemDataObject;
    }

    public PaletteItem(ClassSource classSource) {
        this.componentClassSource = classSource;
    }

    public void setComponentClassSource(String string, String[] stringArray, String[] stringArray2) {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.componentClassSource = new ClassSource(string, stringArray, stringArray2);
    }

    void setComponentExplicitType(String string) {
        this.componentType_explicit = string;
    }

    public Node getNode() {
        return this.itemDataObject == null ? null : this.itemDataObject.getNodeDelegate();
    }

    public String getId() {
        return this.getComponentClassName();
    }

    public String getComponentClassName() {
        return this.componentClassSource.getClassName();
    }

    public ClassSource getComponentClassSource() {
        return this.componentClassSource;
    }

    public Class getComponentClass() {
        if (this.componentClass == null && this.lastError == null) {
            this.componentClass = this.loadComponentClass();
        }
        return this.componentClass;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public String getExplicitComponentType() {
        return this.componentType_explicit;
    }

    public boolean isVisual() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 4) != 0;
    }

    public boolean isMenu() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 8) != 0;
    }

    public boolean isLayout() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 1;
    }

    public boolean isBorder() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 2;
    }

    public String toString() {
        return PaletteUtils.getItemComponentDescription(this);
    }

    String getDisplayName() {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor();
        return beanDescriptor != null ? beanDescriptor.getDisplayName() : null;
    }

    String getTooltip() {
        BeanDescriptor beanDescriptor = this.getBeanDescriptor();
        return beanDescriptor != null ? beanDescriptor.getShortDescription() : null;
    }

    Image getIcon(int n) {
        BeanInfo beanInfo = this.getBeanInfo();
        return beanInfo != null ? beanInfo.getIcon(n) : null;
    }

    void reset() {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.itemDataObject.displayName = null;
        this.itemDataObject.tooltip = null;
        this.itemDataObject.icon16 = null;
        this.itemDataObject.icon32 = null;
    }

    private Class loadComponentClass() {
        try {
            return FormUtils.loadSystemClass(this.getComponentClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return ClassPathUtils.loadClass(this.getComponentClassSource());
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                this.lastError = exception;
            }
            catch (LinkageError linkageError) {
                ErrorManager.getDefault().notify(1, (Throwable)linkageError);
                this.lastError = linkageError;
            }
            return null;
        }
    }

    private BeanInfo getBeanInfo() {
        Class clazz = this.getComponentClass();
        if (clazz != null) {
            try {
                return FormUtils.getBeanInfo(clazz);
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanDescriptor getBeanDescriptor() {
        Class clazz = this.getComponentClass();
        if (clazz != null) {
            try {
                return FormUtils.getBeanInfo(clazz).getBeanDescriptor();
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private void resolveComponentType() {
        if (this.componentType_explicit == null) {
            this.componentType = 0;
            Class clazz = this.getComponentClass();
            if (clazz == null) {
                return;
            }
            if (LayoutManager.class.isAssignableFrom(clazz)) {
                this.componentType = 1;
                return;
            }
            if (Border.class.isAssignableFrom(clazz)) {
                this.componentType = 2;
                return;
            }
            if (Component.class.isAssignableFrom(clazz)) {
                this.componentType |= 4;
            }
            if (MenuComponent.class.isAssignableFrom(clazz) || JMenuItem.class.isAssignableFrom(clazz) || JMenuBar.class.isAssignableFrom(clazz) || JPopupMenu.class.isAssignableFrom(clazz)) {
                this.componentType |= 8;
            }
        } else {
            this.componentType = "visual".equalsIgnoreCase(this.componentType_explicit) ? 4 : ("layout".equalsIgnoreCase(this.componentType_explicit) ? 1 : ("border".equalsIgnoreCase(this.componentType_explicit) ? 2 : ("menu".equalsIgnoreCase(this.componentType_explicit) ? 12 : 0)));
        }
    }
}

