/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class PaletteItemDataObject
extends MultiDataObject {
    static final String XML_ROOT = "palette_item";
    static final String ATTR_VERSION = "version";
    static final String TAG_COMPONENT = "component";
    static final String ATTR_CLASSNAME = "classname";
    static final String ATTR_TYPE = "type";
    static final String TAG_CLASSPATH = "classpath";
    static final String TAG_RESOURCE = "resource";
    static final String ATTR_NAME = "name";
    static final String TAG_DESCRIPTION = "description";
    static final String ATTR_BUNDLE = "localizing-bundle";
    static final String ATTR_DISPLAY_NAME_KEY = "display-name-key";
    static final String ATTR_TOOLTIP_KEY = "tooltip-key";
    static final String TAG_ICON16 = "icon16";
    static final String ATTR_URL = "urlvalue";
    static final String TAG_ICON32 = "icon32";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private boolean fileLoaded;
    private PaletteItem paletteItem;
    private String displayName_key;
    private String tooltip_key;
    private String bundleName;
    private String icon16URL;
    private String icon32URL;
    String displayName;
    String tooltip;
    Image icon16;
    Image icon32;

    PaletteItemDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    boolean isFileRead() {
        return this.fileLoaded;
    }

    boolean isItemValid() {
        return this.paletteItem != null;
    }

    void reloadFile() {
        if (this.paletteItem != null) {
            this.paletteItem.reset();
            this.paletteItem.componentClassSource = null;
            this.paletteItem.componentType_explicit = null;
        }
        this.displayName = null;
        this.tooltip = null;
        this.icon16 = null;
        this.icon32 = null;
        this.displayName_key = null;
        this.tooltip_key = null;
        this.bundleName = null;
        this.icon16URL = null;
        this.icon32URL = null;
        this.loadFile();
    }

    public Node createNodeDelegate() {
        return new ItemNode();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (PaletteItem.class.equals((Object)clazz)) {
            if (!this.fileLoaded) {
                this.loadFile();
            }
            return this.paletteItem;
        }
        return super.getCookie(clazz);
    }

    private void loadFile() {
        FileObject fileObject;
        this.fileLoaded = true;
        PaletteItem paletteItem = this.paletteItem;
        if (paletteItem == null) {
            paletteItem = new PaletteItem(this);
        }
        if ((fileObject = this.getPrimaryFile()).getSize() == 0L) {
            paletteItem.setComponentClassSource(fileObject.getName().replace('-', '.'), null, null);
            this.paletteItem = paletteItem;
            return;
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            PaletteItemHandler paletteItemHandler = new PaletteItemHandler();
            xMLReader.setContentHandler(paletteItemHandler);
            InputSource inputSource = new InputSource(this.getPrimaryFile().getURL().toExternalForm());
            xMLReader.parse(inputSource);
            paletteItem.setComponentExplicitType(paletteItemHandler.componentExplicitType);
            if (paletteItemHandler.componentClassName != null || this.displayName_key != null) {
                String[] stringArray;
                String[] stringArray2;
                if (paletteItemHandler.cpTypeList.size() > 0) {
                    stringArray2 = new String[paletteItemHandler.cpTypeList.size()];
                    paletteItemHandler.cpTypeList.toArray(stringArray2);
                    stringArray = new String[paletteItemHandler.cpNameList.size()];
                    paletteItemHandler.cpNameList.toArray(stringArray);
                } else {
                    stringArray = null;
                    stringArray2 = null;
                }
                paletteItem.setComponentClassSource(paletteItemHandler.componentClassName, stringArray2, stringArray);
                this.paletteItem = paletteItem;
            }
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createFile(FileObject fileObject, ClassSource classSource) throws IOException {
        String string = classSource.getClassName();
        int n = string.lastIndexOf(46);
        String string2 = FileUtil.findFreeFileName((FileObject)fileObject, (String)(n >= 0 ? string.substring(n + 1) : string), (String)XML_ROOT);
        FileObject fileObject2 = fileObject.createData(string2, XML_ROOT);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        stringBuffer.append("<palette_item version=\"1.0\">\n");
        stringBuffer.append("  <component classname=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" />\n");
        stringBuffer.append("  <classpath>\n");
        int n2 = classSource.getCPRootCount();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("      <resource type=\"");
            stringBuffer.append(classSource.getCPRootType(i));
            stringBuffer.append("\" name=\"");
            stringBuffer.append(classSource.getCPRootName(i));
            stringBuffer.append("\" />\n");
            stringBuffer.append("  </classpath>\n");
            stringBuffer.append("</palette_item>\n");
        }
        FileLock fileLock = fileObject2.lock();
        OutputStream outputStream = fileObject2.getOutputStream(fileLock);
        try {
            outputStream.write(stringBuffer.toString().getBytes());
        }
        finally {
            outputStream.close();
            fileLock.releaseLock();
        }
    }

    class ItemNode
    extends DataNode {
        ItemNode() {
            super((DataObject)PaletteItemDataObject.this, Children.LEAF);
        }

        public String getDisplayName() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.displayName == null) {
                PaletteItemDataObject.this.displayName = this.getExplicitDisplayName();
                if (PaletteItemDataObject.this.displayName == null) {
                    if (PaletteItemDataObject.this.isItemValid()) {
                        String string;
                        PaletteItemDataObject.this.displayName = PaletteItemDataObject.this.paletteItem.getDisplayName();
                        if (PaletteItemDataObject.this.displayName == null && (string = PaletteItemDataObject.this.paletteItem.getComponentClassName()) != null) {
                            int n = string.lastIndexOf(46);
                            String string2 = PaletteItemDataObject.this.displayName = n >= 0 ? string.substring(n + 1) : string;
                        }
                    }
                    if (PaletteItemDataObject.this.displayName == null) {
                        PaletteItemDataObject.this.displayName = super.getDisplayName();
                    }
                }
            }
            return PaletteItemDataObject.this.displayName;
        }

        public String getShortDescription() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.tooltip == null) {
                PaletteItemDataObject.this.tooltip = this.getExplicitTooltip();
                if (PaletteItemDataObject.this.tooltip == null) {
                    if (PaletteItemDataObject.this.isItemValid()) {
                        PaletteItemDataObject.this.tooltip = PaletteItemDataObject.this.paletteItem.getTooltip();
                        if (PaletteItemDataObject.this.tooltip == null) {
                            PaletteItemDataObject.this.tooltip = PaletteItemDataObject.this.paletteItem.getComponentClassName();
                        }
                    }
                    if (PaletteItemDataObject.this.tooltip == null) {
                        PaletteItemDataObject.this.tooltip = this.getDisplayName();
                    }
                }
            }
            return PaletteItemDataObject.this.tooltip;
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int n) {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (n == 2 || n == 4) {
                if (PaletteItemDataObject.this.icon32 == null) {
                    PaletteItemDataObject.this.icon32 = this.getExplicitIcon(n);
                    if (PaletteItemDataObject.this.icon32 == null && PaletteItemDataObject.this.isItemValid()) {
                        PaletteItemDataObject.this.icon32 = PaletteItemDataObject.this.paletteItem.getIcon(n);
                    }
                    if (PaletteItemDataObject.this.icon32 == null) {
                        PaletteItemDataObject.this.icon32 = Utilities.loadImage((String)"org/netbeans/modules/form/resources/palette/unknown32.gif");
                    }
                }
                return PaletteItemDataObject.this.icon32;
            }
            if (PaletteItemDataObject.this.icon16 == null) {
                PaletteItemDataObject.this.icon16 = this.getExplicitIcon(n);
                if (PaletteItemDataObject.this.icon16 == null && PaletteItemDataObject.this.isItemValid()) {
                    PaletteItemDataObject.this.icon16 = PaletteItemDataObject.this.paletteItem.getIcon(n);
                }
                if (PaletteItemDataObject.this.icon16 == null) {
                    PaletteItemDataObject.this.icon16 = Utilities.loadImage((String)"org/netbeans/modules/form/resources/palette/unknown.gif");
                }
            }
            return PaletteItemDataObject.this.icon16;
        }

        public Node.PropertySet[] getPropertySets() {
            return NO_PROPERTIES;
        }

        private String getExplicitDisplayName() {
            String string = null;
            if (PaletteItemDataObject.this.displayName_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        string = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.displayName_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = PaletteItemDataObject.this.displayName_key;
                }
            }
            return string;
        }

        private String getExplicitTooltip() {
            String string = null;
            if (PaletteItemDataObject.this.tooltip_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        string = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.tooltip_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string == null) {
                    string = PaletteItemDataObject.this.tooltip_key;
                }
            }
            return string;
        }

        private Image getExplicitIcon(int n) {
            if (n == 2 || n == 4) {
                if (PaletteItemDataObject.this.icon32URL != null) {
                    try {
                        return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon32URL));
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon32") != null) {
                    return super.getIcon(n);
                }
            } else if (PaletteItemDataObject.this.icon16URL != null) {
                try {
                    return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon16URL));
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null) {
                return super.getIcon(n);
            }
            return null;
        }
    }

    public static final class PaletteItemDataLoader
    extends UniFileLoader {
        static final String ITEM_EXT = "palette_item";

        PaletteItemDataLoader() {
            super("org.netbeans.modules.form.palette.PaletteItemDataObject");
            ExtensionList extensionList = new ExtensionList();
            extensionList.addExtension("palette_item");
            this.setExtensions(extensionList);
        }

        protected String defaultDisplayName() {
            return NbBundle.getBundle(PaletteItemDataObject.class).getString("PROP_PaletteItemLoader_Name");
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new PaletteItemDataObject(fileObject, (MultiFileLoader)this);
        }
    }

    public static final class PaletteItemDataLoaderBeanInfo
    extends SimpleBeanInfo {
        private static String iconURL = "org/netbeans/modules/form/resources/palette_manager.png";

        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(UniFileLoader.class)};
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify((Throwable)introspectionException);
                return null;
            }
        }

        public Image getIcon(int n) {
            return Utilities.loadImage((String)iconURL);
        }
    }

    private class PaletteItemHandler
    extends DefaultHandler {
        List cpTypeList;
        List cpNameList;
        String componentClassName;
        String componentExplicitType;

        private PaletteItemHandler() {
        }

        public void startDocument() throws SAXException {
            this.cpTypeList = new ArrayList();
            this.cpNameList = new ArrayList();
            this.componentClassName = null;
            this.componentExplicitType = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (PaletteItemDataObject.XML_ROOT.equals(string3)) {
                String string4 = attributes.getValue(PaletteItemDataObject.ATTR_VERSION);
                if (string4 == null) {
                    String string5 = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnknownPaletteItemVersion");
                    throw new SAXException(string5);
                }
                if (!string4.startsWith("1.")) {
                    String string6 = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnsupportedPaletteItemVersion");
                    throw new SAXException(string6);
                }
            } else if (PaletteItemDataObject.TAG_COMPONENT.equals(string3)) {
                String string7;
                this.componentClassName = string7 = attributes.getValue(PaletteItemDataObject.ATTR_CLASSNAME);
                this.componentExplicitType = attributes.getValue(PaletteItemDataObject.ATTR_TYPE);
            } else if (!PaletteItemDataObject.TAG_CLASSPATH.equals(string3)) {
                String string8;
                if (PaletteItemDataObject.TAG_RESOURCE.equals(string3)) {
                    String string9 = attributes.getValue(PaletteItemDataObject.ATTR_TYPE);
                    String string10 = attributes.getValue(PaletteItemDataObject.ATTR_NAME);
                    if (string9 != null && string10 != null) {
                        this.cpTypeList.add(string9);
                        this.cpNameList.add(string10);
                    }
                } else if (PaletteItemDataObject.TAG_DESCRIPTION.equals(string3)) {
                    String string11;
                    String string12;
                    String string13 = attributes.getValue(PaletteItemDataObject.ATTR_BUNDLE);
                    if (string13 != null) {
                        PaletteItemDataObject.this.bundleName = string13;
                    }
                    if ((string12 = attributes.getValue(PaletteItemDataObject.ATTR_DISPLAY_NAME_KEY)) != null) {
                        PaletteItemDataObject.this.displayName_key = string12;
                    }
                    if ((string11 = attributes.getValue(PaletteItemDataObject.ATTR_TOOLTIP_KEY)) != null) {
                        PaletteItemDataObject.this.tooltip_key = string11;
                    }
                } else if (PaletteItemDataObject.TAG_ICON16.equals(string3)) {
                    String string14 = attributes.getValue(PaletteItemDataObject.ATTR_URL);
                    if (string14 != null) {
                        PaletteItemDataObject.this.icon16URL = string14;
                    }
                } else if (PaletteItemDataObject.TAG_ICON32.equals(string3) && (string8 = attributes.getValue(PaletteItemDataObject.ATTR_URL)) != null) {
                    PaletteItemDataObject.this.icon32URL = string8;
                }
            }
        }
    }
}

