/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

public class SimpleFileOwnerQueryImplementation
implements FileOwnerQueryImplementation {
    private final Set<FileObject> warnedAboutBrokenProjects = new WeakSet();
    private static final Map<URI, Reference<FileObject>> externalOwners = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<FileObject, Collection<URI>> project2External = Collections.synchronizedMap(new WeakHashMap());

    public Project getOwner(URI uRI) {
        FileObject fileObject;
        URI uRI2 = uRI;
        do {
            fileObject = SimpleFileOwnerQueryImplementation.uri2FileObject(uRI2);
            uRI2 = SimpleFileOwnerQueryImplementation.goUp(uRI2);
        } while (fileObject == null && uRI2 != null);
        if (fileObject == null) {
            return null;
        }
        return this.getOwner(fileObject);
    }

    public Project getOwner(FileObject fileObject) {
        while (fileObject != null) {
            FileObject fileObject2;
            Object object;
            if (fileObject.isFolder()) {
                try {
                    object = ProjectManager.getDefault().findProject(fileObject);
                }
                catch (IOException iOException) {
                    if (this.warnedAboutBrokenProjects.add(fileObject)) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    return null;
                }
                if (object != null) {
                    return object;
                }
            }
            if (!externalOwners.isEmpty() && (object = externalOwners.get(SimpleFileOwnerQueryImplementation.fileObject2URI(fileObject))) != null && (fileObject2 = (FileObject)((Reference)object).get()) != null) {
                try {
                    return ProjectManager.getDefault().findProject(fileObject2);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    return null;
                }
            }
            fileObject = fileObject.getParent();
        }
        return null;
    }

    public static void reset() {
        externalOwners.clear();
    }

    private static URI fileObject2URI(FileObject fileObject) {
        try {
            return URI.create(fileObject.getURL().toString());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw (IllegalArgumentException)new IllegalArgumentException(fileStateInvalidException.toString()).initCause(fileStateInvalidException);
        }
    }

    public static void markExternalOwnerTransient(FileObject fileObject, Project project) {
        SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(SimpleFileOwnerQueryImplementation.fileObject2URI(fileObject), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markExternalOwnerTransient(URI uRI, Project project) {
        FileObject fileObject;
        if (project != null) {
            externalOwners.put(uRI, new WeakReference<FileObject>(project.getProjectDirectory()));
            Map<FileObject, Collection<URI>> map = project2External;
            synchronized (map) {
                FileObject fileObject2 = project.getProjectDirectory();
                Collection<URI> collection = project2External.get(fileObject2);
                if (collection == null) {
                    collection = new LinkedList<URI>();
                    project2External.put(fileObject2, collection);
                }
                collection.add(uRI);
            }
        }
        Reference<FileObject> reference = externalOwners.remove(uRI);
        if (reference != null && (fileObject = reference.get()) != null) {
            Map<FileObject, Collection<URI>> map = project2External;
            synchronized (map) {
                Collection<URI> collection = project2External.get(fileObject);
                if (collection != null) {
                    collection.remove(uRI);
                    if (collection.size() == 0) {
                        project2External.remove(fileObject);
                    }
                }
            }
        }
    }

    private static FileObject uri2FileObject(URI uRI) {
        URL uRL;
        try {
            uRL = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            assert (false) : uRI;
            return null;
        }
        return URLMapper.findFileObject((URL)uRL);
    }

    private static URI goUp(URI uRI) {
        String string;
        URI uRI2;
        assert (uRI.isAbsolute()) : uRI;
        assert (uRI.getFragment() == null) : uRI;
        assert (uRI.getQuery() == null) : uRI;
        String string2 = uRI.getPath();
        if (string2 == null || string2.equals("/")) {
            return null;
        }
        String string3 = uRI.toString();
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
            assert (string2.endsWith("/"));
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string3.lastIndexOf(47);
        assert (n != -1) : string2;
        string3 = string2.lastIndexOf(47) == 0 ? string3.substring(0, n + 1) : string3.substring(0, n);
        try {
            uRI2 = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError((Object)uRISyntaxException);
        }
        if (Utilities.isWindows() && ((string = uRI2.getPath()).length() == 3 && string.endsWith(":") || string.length() == 1 && string.endsWith("/"))) {
            return null;
        }
        assert (uRI2.isAbsolute()) : uRI2;
        assert (uRI.toString().startsWith(uRI2.toString())) : "not a parent: " + uRI2 + " of " + uRI;
        return uRI2;
    }
}

