/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.turbo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.turbo.Statistics;

final class Memory {
    private final int minimumSize;
    private final int maximumSize;
    private final Map minimalMap;
    private final Map liveEntitiesMap = new WeakHashMap(3571);
    public static final Object NULL = new Object();
    public static final ThreadLocal prepared = new ThreadLocal();
    private final Statistics statistics;
    private static final Random random = new Random(0L);

    public Memory(Statistics statistics, int n, int n2) {
        if (n2 != -1 && (n2 < n || n2 < 1)) {
            throw new IllegalArgumentException();
        }
        this.minimumSize = n;
        this.maximumSize = n2;
        this.minimalMap = new LRU(this.minimumSize);
        this.statistics = statistics;
    }

    public synchronized void put(Object object, String string, Object object2) {
        Map<String, Object> map;
        if (this.liveEntitiesMap.containsKey(object)) {
            map = (HashMap<String, Object>)this.liveEntitiesMap.get(object);
        } else {
            map = (Map)this.minimalMap.get(object);
            if (map == null) {
                map = new HashMap<String, Object>(5);
            }
        }
        if (object2 != null) {
            map.put(string, Memory.normalizeValue(object2));
        } else {
            map.remove(string);
        }
        this.putLive(object, map);
        this.minimalMap.put(object, map);
        Entry entry = (Entry)prepared.get();
        if (entry != null && object.equals(entry.key) && string.equals(entry.name)) {
            if (object2 != null) {
                entry.value = Memory.normalizeValue(object2);
            } else {
                prepared.set(null);
            }
        }
    }

    private void putLive(Object object, Map map) {
        if (this.maximumSize != -1 && this.liveEntitiesMap.size() >= this.maximumSize) {
            Set set = this.liveEntitiesMap.keySet();
            ArrayList arrayList = new ArrayList(this.liveEntitiesMap.keySet());
            if (arrayList.size() == this.maximumSize) {
                int n = Math.min(7, this.maximumSize / 10);
                for (int i = 0; i < n; ++i) {
                    int n2 = random.nextInt(this.maximumSize);
                    Object e = arrayList.get(n2);
                    if (!set.remove(e)) continue;
                    this.statistics.keyRemoved(e);
                }
            }
        }
        this.liveEntitiesMap.put(object, map);
        this.statistics.keyAdded(object);
    }

    private static Object normalizeValue(Object object) {
        if (object == NULL) {
            return null;
        }
        return object;
    }

    public synchronized Object get(Object object, String string) {
        Map map = (Map)this.liveEntitiesMap.get(object);
        if (map != null) {
            return map.get(string);
        }
        map = (Map)this.minimalMap.get(object);
        if (map != null) {
            this.putLive(object, map);
            return map.get(string);
        }
        Entry entry = (Entry)prepared.get();
        if (entry != null && object.equals(entry.key) && string.equals(entry.name)) {
            prepared.set(null);
            return entry.value;
        }
        return null;
    }

    public synchronized boolean existsEntry(Object object, String string) {
        boolean bl;
        Map map = (Map)this.liveEntitiesMap.get(object);
        if (map == null) {
            map = (Map)this.minimalMap.get(object);
        }
        boolean bl2 = bl = map != null && map.keySet().contains(string);
        if (bl) {
            Entry entry = (Entry)prepared.get();
            if (entry == null) {
                entry = new Entry();
            }
            entry.key = object;
            entry.name = string;
            entry.value = map.get(string);
            prepared.set(entry);
        } else {
            this.statistics.computeRemoved(this.liveEntitiesMap.keySet());
            prepared.set(null);
        }
        return bl;
    }

    public synchronized Object getMonitoredKey(Object object) {
        Set set = this.liveEntitiesMap.keySet();
        if (set.contains(object)) {
            for (Object k : set) {
                if (!object.equals(k)) continue;
                return k;
            }
        }
        return null;
    }

    private class Entry {
        private Object key;
        private String name;
        private Object value;

        private Entry() {
        }
    }

    private static final class LRU
    extends LinkedHashMap {
        private final int maxSize;

        public LRU(int n) {
            super(n * 2, 0.5f, true);
            this.maxSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.maxSize;
        }
    }
}

