/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningAnnotationProvider
extends AnnotationProvider {
    static VersioningAnnotationProvider instance;

    public VersioningAnnotationProvider() {
        instance = this;
    }

    private VCSContext createContext(Set<FileObject> set) {
        HashSet<File> hashSet = new HashSet<File>(set.size());
        if (set instanceof NonRecursiveFolder) {
            FileObject fileObject = ((NonRecursiveFolder)set).getFolder();
            hashSet.add(new FlatFolder(FileUtil.toFile((FileObject)fileObject).getAbsolutePath()));
        } else {
            for (FileObject fileObject : set) {
                hashSet.add(FileUtil.toFile((FileObject)fileObject));
            }
        }
        return VCSContext.forFiles(hashSet);
    }

    private VersioningSystem getOwner(File file) {
        return file == null ? null : VersioningManager.getInstance().getOwner(file);
    }

    public Image annotateIcon(Image image, int n, Set set) {
        FileObject fileObject = (FileObject)set.iterator().next();
        VersioningSystem versioningSystem = this.getOwner(FileUtil.toFile((FileObject)fileObject));
        if (versioningSystem == null) {
            return null;
        }
        VCSAnnotator vCSAnnotator = versioningSystem.getVCSAnnotator();
        if (vCSAnnotator == null) {
            return null;
        }
        VCSContext vCSContext = this.createContext(set);
        return vCSAnnotator.annotateIcon(image, vCSContext);
    }

    public String annotateNameHtml(String string, Set set) {
        FileObject fileObject = (FileObject)set.iterator().next();
        VersioningSystem versioningSystem = this.getOwner(FileUtil.toFile((FileObject)fileObject));
        if (versioningSystem == null) {
            return null;
        }
        VCSAnnotator vCSAnnotator = versioningSystem.getVCSAnnotator();
        if (vCSAnnotator == null) {
            return null;
        }
        VCSContext vCSContext = this.createContext(set);
        return vCSAnnotator.annotateName(string, vCSContext);
    }

    public Action[] actions(Set set) {
        Object object;
        FileObject fileObject = (FileObject)set.iterator().next();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return new Action[0];
        }
        VersioningSystem versioningSystem = this.getOwner(file);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        VCSAnnotator vCSAnnotator = null;
        if (versioningSystem != null) {
            vCSAnnotator = versioningSystem.getVCSAnnotator();
        }
        if (vCSAnnotator != null) {
            object = (VersioningSystemActions)SystemAction.get(VersioningSystemActions.class);
            ((AbstractVersioningSystemActions)((Object)object)).setVersioninSystem(versioningSystem);
            arrayList.add(object);
        }
        if ((object = VersioningManager.getInstance().getLocalHistory(file)) != null && ((VersioningSystem)object).getVCSAnnotator() != null) {
            LocalHistoryActions localHistoryActions = (LocalHistoryActions)SystemAction.get(LocalHistoryActions.class);
            localHistoryActions.setVersioninSystem((VersioningSystem)object);
            arrayList.add((Object)localHistoryActions);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public InterceptionListener getInterceptionListener() {
        return VersioningManager.getInstance().getInterceptionListener();
    }

    public String annotateName(String string, Set set) {
        return string;
    }

    public void refreshAllAnnotations(boolean bl, boolean bl2) {
        HashSet<FileSystem> hashSet = new HashSet<FileSystem>(1);
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                hashSet.add(fileObject.getFileSystem());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        for (FileSystem fileSystem : hashSet) {
            this.fireFileStatusChanged(new FileStatusEvent(fileSystem, bl, bl2));
        }
    }

    void refreshAnnotations(Set<File> set) {
        Object object;
        if (set == null) {
            this.refreshAllAnnotations(true, true);
            return;
        }
        HashMap<FileSystem, HashSet<FileObject>> hashMap = new HashMap<FileSystem, HashSet<FileObject>>();
        for (File file : set) {
            for (object = file.getParentFile(); object != null; object = ((File)object).getParentFile()) {
                try {
                    Serializable serializable;
                    FileObject fileObject;
                    try {
                        fileObject = FileUtil.toFileObject((File)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Issue #73233 log begins:");
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Original File: " + file.getAbsolutePath());
                        Logger.getLogger(VersioningAnnotationProvider.class.getName()).log(Level.INFO, "Illegal file: " + ((File)object).getAbsolutePath());
                        serializable = new RuntimeException("Please report this and append your messages.log file to issue http://www.netbeans.org/issues/show_bug.cgi?id=73233");
                        ((Throwable)serializable).initCause(illegalArgumentException);
                        throw serializable;
                    }
                    if (fileObject == null) continue;
                    FileSystem fileSystem = fileObject.getFileSystem();
                    serializable = (HashSet<FileObject>)hashMap.get(fileSystem);
                    if (serializable == null) {
                        serializable = new HashSet<FileObject>();
                        hashMap.put(fileSystem, (HashSet<FileObject>)serializable);
                    }
                    serializable.add(fileObject);
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            object = FileUtil.toFileObject((File)file);
            if (object == null) continue;
            try {
                this.fireFileStatusChanged(new FileStatusEvent(object.getFileSystem(), (FileObject)object, object.isFolder(), true));
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
        }
        for (File file : hashMap.keySet()) {
            object = (Set)hashMap.get(file);
            this.fireFileStatusChanged(new FileStatusEvent((FileSystem)file, (Set)object, true, false));
        }
    }

    public static abstract class AbstractVersioningSystemActions
    extends SystemAction
    implements ContextAwareAction {
        private VersioningSystem system;

        public String getName() {
            return this.system.getDisplayName();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.system.getClass());
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new RealVersioningSystemActions(this.system, VCSContext.forLookup(lookup));
        }

        public void setVersioninSystem(VersioningSystem versioningSystem) {
            this.system = versioningSystem;
        }
    }

    public static class LocalHistoryActions
    extends AbstractVersioningSystemActions {
    }

    private static class RealVersioningSystemActions
    extends AbstractAction
    implements Presenter.Popup {
        private final VersioningSystem system;
        private final VCSContext context;

        public RealVersioningSystemActions(VersioningSystem versioningSystem, VCSContext vCSContext) {
            super(versioningSystem.getDisplayName());
            this.system = versioningSystem;
            this.context = vCSContext;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public JMenuItem getPopupPresenter() {
            return new VersioningSystemMenuItem();
        }

        private class VersioningSystemMenuItem
        extends JMenu {
            private boolean popupContructed;

            public VersioningSystemMenuItem() {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)RealVersioningSystemActions.this.system.getDisplayName());
            }

            public void setSelected(boolean bl) {
                if (bl && !this.popupContructed) {
                    Action[] actionArray = RealVersioningSystemActions.this.system.getVCSAnnotator().getActions(RealVersioningSystemActions.this.context, VCSAnnotator.ActionDestination.PopupMenu);
                    for (int i = 0; i < actionArray.length; ++i) {
                        Action action = actionArray[i];
                        if (action == null) {
                            this.add(new JSeparator());
                            continue;
                        }
                        JMenuItem jMenuItem = Utils.toMenuItem(action);
                        this.add(jMenuItem);
                    }
                    this.popupContructed = true;
                }
                super.setSelected(bl);
            }
        }
    }

    public static class VersioningSystemActions
    extends AbstractVersioningSystemActions {
    }
}

