/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.VersioningOutputManager;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.LocalHistory;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningManager
implements PropertyChangeListener,
LookupListener {
    private static VersioningManager instance;
    private final FilesystemInterceptor filesystemInterceptor;
    private final VersioningOutputManager outputManager = new VersioningOutputManager();
    private final Collection<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(2);
    private final Map<File, VersioningSystem> folderOwners = new WeakHashMap<File, VersioningSystem>(100);
    private VersioningSystem localHistory;
    private Map<File, Boolean> localHistoryFolders = new WeakHashMap<File, Boolean>(100);
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){

        public String getDisplayName() {
            return null;
        }
    };

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    private VersioningManager() {
        this.filesystemInterceptor = new FilesystemInterceptor();
    }

    private void init() {
        this.initVersioningSystems();
        this.filesystemInterceptor.init(this);
    }

    private void initVersioningSystems() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.refreshVersioningSystems(result.allInstances());
        result.addLookupListener((LookupListener)this);
    }

    private synchronized void refreshVersioningSystems(Collection<? extends VersioningSystem> collection) {
        this.unloadVersioningSystems();
        this.loadVersioningSystems(collection);
    }

    private void loadVersioningSystems(Collection<? extends VersioningSystem> collection) {
        assert (this.versioningSystems.size() == 0);
        assert (this.localHistory == null);
        this.versioningSystems.addAll(collection);
        for (VersioningSystem versioningSystem : this.versioningSystems) {
            if (this.localHistory == null && versioningSystem instanceof LocalHistory) {
                this.localHistory = versioningSystem;
            }
            versioningSystem.addPropertyChangeListener(this);
        }
    }

    private void unloadVersioningSystems() {
        for (VersioningSystem versioningSystem : this.versioningSystems) {
            versioningSystem.removePropertyChangeListener(this);
        }
        this.versioningSystems.clear();
        this.localHistory = null;
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars() {
        DiffSidebarManager.getInstance().refreshAllSidebars();
    }

    private synchronized void flushFileOwnerCache() {
        this.folderOwners.clear();
        this.localHistoryFolders.clear();
    }

    synchronized VersioningSystem[] getVersioningSystems() {
        return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
    }

    VersioningSystem[] getOwners(VCSContext vCSContext) {
        Set<File> set = vCSContext.getRootFiles();
        HashSet<VersioningSystem> hashSet = new HashSet<VersioningSystem>();
        for (File file : set) {
            VersioningSystem versioningSystem = this.getOwner(file);
            if (versioningSystem == null) continue;
            hashSet.add(versioningSystem);
        }
        return hashSet.toArray(new VersioningSystem[hashSet.size()]);
    }

    public synchronized VersioningSystem getOwner(File file) {
        File file2 = file;
        if (file.isFile() && (file2 = file.getParentFile()) == null) {
            return null;
        }
        VersioningSystem versioningSystem = this.folderOwners.get(file2);
        if (versioningSystem == this.NULL_OWNER) {
            return null;
        }
        if (versioningSystem != null) {
            return versioningSystem;
        }
        File file3 = null;
        for (VersioningSystem versioningSystem2 : this.versioningSystems) {
            File file4;
            if (versioningSystem2 == this.localHistory || (file4 = versioningSystem2.getTopmostManagedParent(file2)) == null || file3 != null && !Utils.isParentOrEqual(file3, file4)) continue;
            versioningSystem = versioningSystem2;
            file3 = file4;
        }
        if (versioningSystem != null) {
            this.folderOwners.put(file2, versioningSystem);
        } else {
            this.folderOwners.put(file2, this.NULL_OWNER);
        }
        return versioningSystem;
    }

    synchronized VersioningSystem getLocalHistory(File file) {
        boolean bl;
        if (this.localHistory == null) {
            return null;
        }
        File file2 = file;
        if (file.isFile() && (file2 = file.getParentFile()) == null) {
            return null;
        }
        Boolean bl2 = this.localHistoryFolders.get(file2);
        if (bl2 != null) {
            return bl2 != false ? this.localHistory : null;
        }
        boolean bl3 = bl = this.localHistory.getTopmostManagedParent(file2) != null;
        if (bl) {
            this.localHistoryFolders.put(file2, Boolean.TRUE);
            return this.localHistory;
        }
        this.localHistoryFolders.put(file2, Boolean.FALSE);
        return null;
    }

    public VersioningOutputManager getOutputManager() {
        return this.outputManager;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Lookup.Result result = (Lookup.Result)lookupEvent.getSource();
        this.refreshVersioningSystems(result.allInstances());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("Set<File> VCS.StatusChanged".equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
        } else if ("Set<File> VCS.AnnotationsChanged".equals(propertyChangeEvent.getPropertyName())) {
            Set set = (Set)propertyChangeEvent.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(set);
        } else if ("null VCS.VersionedFilesChanged".equals(propertyChangeEvent.getPropertyName())) {
            this.flushFileOwnerCache();
            this.refreshDiffSidebars();
        }
    }
}

