/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.netbeans.modules.versioning.diff.DiffTooltipActionsPanel;
import org.netbeans.modules.versioning.diff.DiffTooltipContentPanel;

class DiffActionTooltipWindow
implements AWTEventListener {
    private static final int SCREEN_BORDER = 20;
    private JWindow actionsWindow;
    private JWindow contentWindow;
    private final DiffSidebar master;
    private final Difference diff;

    public DiffActionTooltipWindow(DiffSidebar diffSidebar, Difference difference) {
        this.master = diffSidebar;
        this.diff = difference;
        Window window = SwingUtilities.windowForComponent(diffSidebar.getTextComponent());
        this.actionsWindow = new JWindow(window);
        if (difference.getType() != 1) {
            this.contentWindow = new JWindow(window);
        }
    }

    DiffSidebar getMaster() {
        return this.master;
    }

    public void show(Point point) {
        DiffTooltipActionsPanel diffTooltipActionsPanel = new DiffTooltipActionsPanel(this, this.diff);
        this.actionsWindow.add(diffTooltipActionsPanel);
        this.actionsWindow.pack();
        this.actionsWindow.setLocation(point);
        if (this.contentWindow != null) {
            DiffTooltipContentPanel diffTooltipContentPanel = new DiffTooltipContentPanel(this.master.getTextComponent(), this.master.getMimeType(), this.diff);
            this.contentWindow.add(diffTooltipContentPanel);
            this.contentWindow.pack();
            Dimension dimension = this.contentWindow.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.y + this.actionsWindow.getHeight() + dimension.height + 20 > dimension2.height) {
                dimension.height = dimension2.height - (point.y + this.actionsWindow.getHeight() + 20);
            }
            if (point.x + dimension.width + 20 > dimension2.width) {
                dimension.width = dimension2.width - (point.x + 20);
            }
            this.contentWindow.setSize(dimension);
            this.contentWindow.setLocation(point.x, point.y + this.actionsWindow.getHeight() - 1);
            this.contentWindow.setVisible(true);
        }
        this.actionsWindow.setVisible(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 501) {
            this.onClick(aWTEvent);
        }
    }

    private void onClick(AWTEvent aWTEvent) {
        Component component = (Component)aWTEvent.getSource();
        Window window = SwingUtilities.windowForComponent(component);
        if (window != this.actionsWindow && (this.contentWindow == null || window != this.contentWindow)) {
            this.shutdown();
        }
    }

    void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.actionsWindow.dispose();
        if (this.contentWindow != null) {
            this.contentWindow.dispose();
        }
    }
}

