/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSContext {
    public static final VCSContext Empty = new VCSContext(null, VCSContext.emptySet(), VCSContext.emptySet());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Node[] nodes;
    private final Set<File> rootFiles;
    private final Set<File> exclusions;

    public static VCSContext forLookup(Lookup lookup) {
        Lookup.Result result = lookup.lookup(new Lookup.Template(Node.class));
        Collection collection = result.allInstances();
        return VCSContext.forNodes(collection.toArray(new Node[collection.size()]));
    }

    public static VCSContext forFiles(Set<File> set) {
        return new VCSContext(null, Collections.unmodifiableSet(new HashSet<File>(set)), VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodeArray) {
        Object object;
        if (Arrays.equals(contextNodesCached.get(), nodeArray) && (object = contextCached.get()) != null) {
            return object;
        }
        object = new HashSet(nodeArray.length);
        HashSet<File> hashSet = new HashSet<File>(nodeArray.length);
        HashSet<File> hashSet2 = new HashSet<File>(5);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            File file = (File)node.getLookup().lookup(File.class);
            if (file != null) {
                object.add(file);
                hashSet.add(file);
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                VCSContext.addProjectFiles(hashSet, hashSet2, project);
                continue;
            }
            VCSContext.addFileObjects(node, (Set<File>)object, hashSet);
        }
        VCSContext vCSContext = new VCSContext(nodeArray, hashSet, hashSet2);
        contextCached = new WeakReference<VCSContext>(vCSContext);
        contextNodesCached = new WeakReference<Node[]>(nodeArray);
        return vCSContext;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public Set<File> getRootFiles() {
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(File file) {
        block0: for (File file2 : this.rootFiles) {
            if (!Utils.isParentOrEqual(file2, file)) continue;
            for (File file3 : this.exclusions) {
                if (!Utils.isParentOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            collection.add(file);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                if (sourceGroup.contains(fileObject2) || SharabilityQuery.getSharability((File)file2) == 2) continue;
                collection2.add(file2);
            }
        }
    }

    private static void addFileObjects(Node node, Set<File> set, Set<File> set2) {
        Collection collection = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (collection.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : collection) {
                arrayList.add(new FlatFolder(FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder()).getAbsolutePath()));
            }
        } else {
            Collection collection2 = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection2.size() > 0) {
                arrayList.addAll(VCSContext.toFileCollection(collection2));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> collection3 = VCSContext.toFileCollection(dataObject.files());
                    arrayList.addAll(collection3);
                }
            }
        }
        set.addAll(arrayList);
        set2.addAll(arrayList);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        for (FileObject fileObject : collection) {
            hashSet.add(FileUtil.toFile((FileObject)fileObject));
        }
        hashSet.remove(null);
        return hashSet;
    }

    private VCSContext(Node[] nodeArray, Set<File> set, Set<File> set2) {
        this.nodes = nodeArray;
        this.rootFiles = Collections.unmodifiableSet(new HashSet<File>(set));
        this.exclusions = Collections.unmodifiableSet(new HashSet<File>(set2));
    }

    private static final Set<File> emptySet() {
        return Collections.emptySet();
    }
}

