/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.ColorValue;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnnotationsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private ColorModel colorModel;
    private boolean listen = false;
    private String currentScheme;
    private Map schemes = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;
    private JComboBox cbBackground;
    private JComboBox cbForeground;
    private JComboBox cbWaveUnderlined;
    private JScrollPane cpCategories;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lForeground;
    private JLabel lWaveUnderlined;
    private JLabel lbackground;

    public AnnotationsPanel() {
        this.initComponents();
        this.cbForeground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Background_Chooser"));
        this.cbWaveUnderlined.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Wave_Underlined"));
        this.cbWaveUnderlined.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Wave_Underlined"));
        this.lCategories.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Categories"));
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbBackground);
        ColorComboBox.init(this.cbWaveUnderlined);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!AnnotationsPanel.this.listen) {
                    return;
                }
                AnnotationsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbForeground.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        this.cbWaveUnderlined.addPropertyChangeListener(this);
        ((JComponent)((Object)this.cbWaveUnderlined.getEditor())).addPropertyChangeListener(this);
        JLabel jLabel = new JLabel();
        AnnotationsPanel.loc(jLabel, "CTL_Category");
        jLabel.setLabelFor(this.lCategories);
    }

    private void initComponents() {
        this.lCategory = new JLabel();
        this.cpCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lForeground = new JLabel();
        this.lbackground = new JLabel();
        this.lWaveUnderlined = new JLabel();
        this.cbForeground = new JComboBox();
        this.cbBackground = new JComboBox();
        this.cbWaveUnderlined = new JComboBox();
        this.lCategory.setText("Category:");
        this.cpCategories.setViewportView(this.lCategories);
        this.lForeground.setText("Foreground:");
        this.lbackground.setText("Background:");
        this.lWaveUnderlined.setText("Wave Underlined:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cpCategories, -1, 212, Short.MAX_VALUE).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lbackground).add((Component)this.lWaveUnderlined).add((Component)this.lForeground)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.cbForeground, 0, 71, Short.MAX_VALUE).add((Component)this.cbBackground, 0, 71, Short.MAX_VALUE).add((Component)this.cbWaveUnderlined, 0, 71, Short.MAX_VALUE))).add((Component)this.lCategory)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lbackground).add((Component)this.cbBackground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lWaveUnderlined).add((Component)this.cbWaveUnderlined, -2, -1, -2))).add((Component)this.cpCategories, -1, 258, Short.MAX_VALUE)).addContainerGap()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.listen = false;
        this.currentScheme = colorModel.getCurrentProfile();
        this.lCategories.setListData(this.getAnnotations(this.currentScheme));
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
        this.changed = false;
    }

    void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator iterator = this.toBeSaved.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.colorModel.setAnnotations(string, this.getAnnotations(string));
        }
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String string) {
        String string2 = this.currentScheme;
        this.currentScheme = string;
        Vector vector = this.getAnnotations(string);
        if (vector == null) {
            vector = this.getAnnotations(string2);
            this.schemes.put(string, new Vector(vector));
            this.toBeSaved.add(string);
            vector = this.getAnnotations(string);
        }
        this.lCategories.setListData(vector);
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
    }

    void deleteProfile(String string) {
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)AnnotationsPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)AnnotationsPanel.loc(string));
        }
    }

    private void updateData() {
        Vector vector = this.getAnnotations(this.currentScheme);
        SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)vector.get(this.lCategories.getSelectedIndex());
        Color color = ((ColorValue)this.cbBackground.getSelectedItem()).color;
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        color = ((ColorValue)this.cbForeground.getSelectedItem()).color;
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        color = ((ColorValue)this.cbWaveUnderlined.getSelectedItem()).color;
        if (color != null) {
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, color);
        } else {
            simpleAttributeSet.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.toBeSaved.add(this.currentScheme);
    }

    private void refreshUI() {
        Object object;
        Serializable serializable;
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            this.cbForeground.setEnabled(false);
            this.cbBackground.setEnabled(false);
            this.cbWaveUnderlined.setEnabled(false);
            return;
        }
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        this.cbWaveUnderlined.setEnabled(true);
        this.listen = false;
        AttributeSet attributeSet = this.getDefaultColoring();
        if (attributeSet != null) {
            serializable = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
            if (serializable == null) {
                serializable = Color.black;
            }
            ColorComboBox.setInheritedColor(this.cbForeground, (Color)serializable);
            object = (Color)attributeSet.getAttribute(StyleConstants.Background);
            if (object == null) {
                object = Color.white;
            }
            ColorComboBox.setInheritedColor(this.cbBackground, (Color)object);
        }
        serializable = this.getAnnotations(this.currentScheme);
        object = (AttributeSet)((Vector)serializable).get(n);
        ColorComboBox.setColor(this.cbForeground, (Color)object.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)object.getAttribute(StyleConstants.Background));
        ColorComboBox.setColor(this.cbWaveUnderlined, (Color)object.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        this.listen = true;
    }

    private AttributeSet getDefaultColoring() {
        Collection collection = this.colorModel.getCategories(this.currentScheme, ColorModel.ALL_LANGUAGES);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            String string = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (string == null || !"default".equals(string)) continue;
            return attributeSet;
        }
        return null;
    }

    private Vector getAnnotations(String string) {
        if (!this.schemes.containsKey(string)) {
            Collection collection = this.colorModel.getAnnotations(this.currentScheme);
            if (collection == null) {
                return null;
            }
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.schemes.put(string, new Vector(arrayList));
        }
        return (Vector)this.schemes.get(string);
    }
}

