/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.ColorValue;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HighlightingPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private ColorModel colorModel = null;
    private boolean listen = false;
    private String currentProfile;
    private Map profileToCategories = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;
    private JComboBox cbBackground;
    private JComboBox cbForeground;
    private JScrollPane cpCategories;
    private JLabel lBackground;
    private JList lCategories;
    private JLabel lCategory;
    private JLabel lForeground;
    private Map profileToDefaults = new HashMap();

    public HighlightingPanel() {
        this.initComponents();
        this.lCategories.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Categories"));
        this.cbForeground.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Foreground_Chooser"));
        this.cbForeground.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Foreground_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleName(HighlightingPanel.loc("AN_Background_Chooser"));
        this.cbBackground.getAccessibleContext().setAccessibleDescription(HighlightingPanel.loc("AD_Background_Chooser"));
        ColorComboBox.init(this.cbForeground);
        ColorComboBox.init(this.cbBackground);
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!HighlightingPanel.this.listen) {
                    return;
                }
                HighlightingPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.cbForeground.addActionListener(this);
        ((JComponent)((Object)this.cbForeground.getEditor())).addPropertyChangeListener(this);
        this.cbBackground.addActionListener(this);
        ((JComponent)((Object)this.cbBackground.getEditor())).addPropertyChangeListener(this);
        JLabel jLabel = new JLabel();
        HighlightingPanel.loc(jLabel, "CTL_Category");
        jLabel.setLabelFor(this.lCategories);
    }

    private void initComponents() {
        this.lCategory = new JLabel();
        this.cpCategories = new JScrollPane();
        this.lCategories = new JList();
        this.lForeground = new JLabel();
        this.lBackground = new JLabel();
        this.cbBackground = new JComboBox();
        this.cbForeground = new JComboBox();
        this.lCategory.setText("Category:");
        this.cpCategories.setViewportView(this.lCategories);
        this.lForeground.setText("Foreground:");
        this.lBackground.setText("Background:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cpCategories, -1, 211, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lBackground).add((Component)this.lForeground)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.cbBackground, 0, 53, Short.MAX_VALUE).add(2, (Component)this.cbForeground, 0, 53, Short.MAX_VALUE))).add((Component)this.lCategory)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lCategory).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lForeground).add((Component)this.cbForeground, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lBackground).add((Component)this.cbBackground, -2, -1, -2))).add((Component)this.cpCategories, -1, 189, Short.MAX_VALUE)).addContainerGap()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.listen) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "color") {
            this.updateData();
            this.changed = true;
        }
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.currentProfile = colorModel.getCurrentProfile();
        this.listen = false;
        this.setCurrentProfile(this.currentProfile);
        this.lCategories.setListData(this.getCategories(this.currentProfile));
        this.lCategories.setSelectedIndex(0);
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
        this.changed = false;
    }

    public void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator iterator = this.toBeSaved.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.colorModel.setHighlightings(string, this.getCategories(string));
        }
        this.toBeSaved = new HashSet();
        this.profileToCategories = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    void setCurrentProfile(String string) {
        String string2 = this.currentProfile;
        this.currentProfile = string;
        if (!this.colorModel.getProfiles().contains(string)) {
            Vector vector = this.getCategories(string2);
            this.profileToCategories.put(string, new Vector(vector));
            this.toBeSaved.add(string);
        }
        this.refreshUI();
    }

    void deleteProfile(String string) {
        if (this.colorModel.isCustomProfile(string)) {
            this.profileToCategories.put(string, null);
        } else {
            this.profileToCategories.put(string, this.getDefaults(string));
            this.refreshUI();
        }
        this.toBeSaved.add(string);
    }

    Collection getHighlightings() {
        return this.getCategories(this.currentProfile);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)HighlightingPanel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)HighlightingPanel.loc(string));
        }
    }

    private void updateData() {
        if (this.lCategories.getSelectedIndex() < 0) {
            return;
        }
        Vector vector = this.getCategories(this.currentProfile);
        AttributeSet attributeSet = (AttributeSet)vector.get(this.lCategories.getSelectedIndex());
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(attributeSet);
        Color color = ((ColorValue)this.cbBackground.getSelectedItem()).color;
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Background, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Background);
        }
        color = ((ColorValue)this.cbForeground.getSelectedItem()).color;
        if (color != null) {
            simpleAttributeSet.addAttribute(StyleConstants.Foreground, color);
        } else {
            simpleAttributeSet.removeAttribute(StyleConstants.Foreground);
        }
        int n = this.lCategories.getSelectedIndex();
        vector.set(n, simpleAttributeSet);
        this.toBeSaved.add(this.currentProfile);
    }

    private void refreshUI() {
        int n = this.lCategories.getSelectedIndex();
        if (n < 0) {
            this.cbForeground.setEnabled(false);
            this.cbBackground.setEnabled(false);
            return;
        }
        this.cbForeground.setEnabled(true);
        this.cbBackground.setEnabled(true);
        Vector vector = this.getCategories(this.currentProfile);
        AttributeSet attributeSet = (AttributeSet)vector.get(n);
        this.listen = false;
        AttributeSet attributeSet2 = this.getDefaultColoring();
        if (attributeSet2 != null) {
            Color color = (Color)attributeSet2.getAttribute(StyleConstants.Foreground);
            if (color == null) {
                color = Color.black;
            }
            ColorComboBox.setInheritedColor(this.cbForeground, color);
            Color color2 = (Color)attributeSet2.getAttribute(StyleConstants.Background);
            if (color2 == null) {
                color2 = Color.white;
            }
            ColorComboBox.setInheritedColor(this.cbBackground, color2);
        }
        ColorComboBox.setColor(this.cbForeground, (Color)attributeSet.getAttribute(StyleConstants.Foreground));
        ColorComboBox.setColor(this.cbBackground, (Color)attributeSet.getAttribute(StyleConstants.Background));
        this.listen = true;
    }

    private AttributeSet getDefaultColoring() {
        Collection collection = this.colorModel.getCategories(this.currentProfile, ColorModel.ALL_LANGUAGES);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AttributeSet attributeSet = (AttributeSet)iterator.next();
            String string = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (string == null || !"default".equals(string)) continue;
            return attributeSet;
        }
        return null;
    }

    private Vector getCategories(String string) {
        if (this.colorModel == null) {
            return null;
        }
        if (!this.profileToCategories.containsKey(string)) {
            Collection collection = this.colorModel.getHighlightings(string);
            if (collection == null) {
                collection = Collections.EMPTY_SET;
            }
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.profileToCategories.put(string, new Vector(arrayList));
        }
        return (Vector)this.profileToCategories.get(string);
    }

    private Vector getDefaults(String string) {
        if (!this.profileToDefaults.containsKey(string)) {
            Collection collection = this.colorModel.getHighlightingDefaults(string);
            ArrayList arrayList = new ArrayList(collection);
            Collections.sort(arrayList, new CategoryComparator());
            this.profileToDefaults.put(string, new Vector(arrayList));
        }
        return (Vector)this.profileToDefaults.get(string);
    }
}

