/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private boolean changed = false;
    private boolean listen = false;
    private JCheckBox cbAutoPopup;
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbFoldImports;
    private JCheckBox cbFoldInitialComments;
    private JCheckBox cbFoldInnerClasses;
    private JCheckBox cbFoldJavadocComments;
    private JCheckBox cbFoldMethods;
    private JCheckBox cbInsertClosingBracketsAutomatically;
    private JCheckBox cbInsertSingleProposalsAutomatically;
    private JCheckBox cbShowDeprecated;
    private JCheckBox cbUseCodeFolding;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lCodeCompletion;
    private JLabel lCodeCompletion2;
    private JLabel lCodeFolding;
    private JLabel lCollapseByDefault;
    private JLabel lUseCodeFolding;
    private Model model;

    public GeneralEditorPanel() {
        this.initComponents();
        GeneralEditorPanel.loc(this.lCodeFolding, "Code_Folding");
        GeneralEditorPanel.loc(this.lUseCodeFolding, "Code_Folding_Section");
        GeneralEditorPanel.loc(this.lCollapseByDefault, "Fold_by_Default");
        GeneralEditorPanel.loc(this.lCodeCompletion, "Code_Completion");
        GeneralEditorPanel.loc(this.lCodeCompletion2, "Code_Completion_Section");
        GeneralEditorPanel.loc(this.cbUseCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavadocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComments, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbAutoPopup, "Auto_Popup_Completion_Window");
        GeneralEditorPanel.loc(this.cbInsertSingleProposalsAutomatically, "Insert_Single_Proposals_Automatically");
        GeneralEditorPanel.loc(this.cbCaseSensitive, "Case_Sensitive_Code_Completion");
        GeneralEditorPanel.loc(this.cbShowDeprecated, "Show_Deprecated_Members");
        GeneralEditorPanel.loc(this.cbInsertClosingBracketsAutomatically, "Pair_Character_Completion");
    }

    private void initComponents() {
        this.lCodeFolding = new JLabel();
        this.lUseCodeFolding = new JLabel();
        this.lCollapseByDefault = new JLabel();
        this.cbUseCodeFolding = new JCheckBox();
        this.cbFoldMethods = new JCheckBox();
        this.cbFoldInnerClasses = new JCheckBox();
        this.cbFoldImports = new JCheckBox();
        this.cbFoldJavadocComments = new JCheckBox();
        this.cbFoldInitialComments = new JCheckBox();
        this.lCodeCompletion = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lCodeCompletion2 = new JLabel();
        this.cbAutoPopup = new JCheckBox();
        this.cbInsertSingleProposalsAutomatically = new JCheckBox();
        this.cbCaseSensitive = new JCheckBox();
        this.cbShowDeprecated = new JCheckBox();
        this.cbInsertClosingBracketsAutomatically = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.lCodeFolding.setText("Code Folding");
        this.lUseCodeFolding.setText("Use Code Folding:");
        this.lCollapseByDefault.setText("Collapse by Default:");
        this.cbUseCodeFolding.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUseCodeFolding.setMargin(new Insets(0, 0, 0, 0));
        this.cbFoldMethods.setText("Methods");
        this.cbFoldMethods.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldMethods.setMargin(new Insets(0, 0, 0, 0));
        this.cbFoldInnerClasses.setText("Inner Classes");
        this.cbFoldInnerClasses.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldInnerClasses.setMargin(new Insets(0, 0, 0, 0));
        this.cbFoldImports.setText("Imports");
        this.cbFoldImports.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldImports.setMargin(new Insets(0, 0, 0, 0));
        this.cbFoldJavadocComments.setText("Javadoc Comments");
        this.cbFoldJavadocComments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldJavadocComments.setMargin(new Insets(0, 0, 0, 0));
        this.cbFoldInitialComments.setText("Initial Comments");
        this.cbFoldInitialComments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbFoldInitialComments.setMargin(new Insets(0, 0, 0, 0));
        this.lCodeCompletion.setText("Code Completion");
        this.lCodeCompletion2.setText("Code Completion:");
        this.cbAutoPopup.setText("Auto Popup Code Completion Window");
        this.cbAutoPopup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAutoPopup.setMargin(new Insets(0, 0, 0, 0));
        this.cbInsertSingleProposalsAutomatically.setText("Insert Single Proposals Automatically");
        this.cbInsertSingleProposalsAutomatically.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbInsertSingleProposalsAutomatically.setMargin(new Insets(0, 0, 0, 0));
        this.cbCaseSensitive.setText("Case Sensitive Code Completion");
        this.cbCaseSensitive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCaseSensitive.setMargin(new Insets(0, 0, 0, 0));
        this.cbShowDeprecated.setText("Show Deprecated Members In Code Completion");
        this.cbShowDeprecated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbShowDeprecated.setMargin(new Insets(0, 0, 0, 0));
        this.cbInsertClosingBracketsAutomatically.setText("Insert Closing Brackets Automatically");
        this.cbInsertClosingBracketsAutomatically.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbInsertClosingBracketsAutomatically.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lUseCodeFolding).add((Component)this.lCodeCompletion2).add((Component)this.lCollapseByDefault)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbUseCodeFolding).add((Component)this.cbFoldMethods).add((Component)this.cbFoldInnerClasses).add((Component)this.cbFoldImports).add((Component)this.cbFoldJavadocComments).add((Component)this.cbFoldInitialComments).add((Component)this.cbAutoPopup).add((Component)this.cbInsertSingleProposalsAutomatically).add((Component)this.cbCaseSensitive).add((Component)this.cbShowDeprecated).add((Component)this.cbInsertClosingBracketsAutomatically)).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lCodeCompletion).addPreferredGap(0).add((Component)this.jSeparator2, -1, 392, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lCodeFolding).addPreferredGap(0).add((Component)this.jSeparator1, -1, 411, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeFolding).add((Component)this.jSeparator1, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lUseCodeFolding).add((Component)this.cbUseCodeFolding)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lCollapseByDefault).add((Component)this.cbFoldMethods)).addPreferredGap(0).add((Component)this.cbFoldInnerClasses).addPreferredGap(0).add((Component)this.cbFoldImports).addPreferredGap(0).add((Component)this.cbFoldJavadocComments).addPreferredGap(0).add((Component)this.cbFoldInitialComments).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeCompletion).add((Component)this.jSeparator2, -2, 10, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.lCodeCompletion2).add((Component)this.cbAutoPopup)).addPreferredGap(0).add((Component)this.cbInsertSingleProposalsAutomatically).addPreferredGap(0).add((Component)this.cbCaseSensitive).addPreferredGap(0).add((Component)this.cbShowDeprecated).addPreferredGap(0).add((Component)this.cbInsertClosingBracketsAutomatically).addContainerGap(73, Short.MAX_VALUE)));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)GeneralEditorPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralEditorPanel.loc("CTL_" + string));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbUseCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavadocComments.addActionListener(this);
            this.cbFoldInitialComments.addActionListener(this);
            this.cbAutoPopup.addActionListener(this);
            this.cbInsertSingleProposalsAutomatically.addActionListener(this);
            this.cbCaseSensitive.addActionListener(this);
            this.cbShowDeprecated.addActionListener(this);
            this.cbInsertClosingBracketsAutomatically.addActionListener(this);
        }
        this.cbUseCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComments.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavadocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.updateEnabledState();
        this.cbInsertClosingBracketsAutomatically.setSelected(this.model.isPairCharacterCompletion());
        this.cbAutoPopup.setSelected(this.model.isCompletionAutoPopup());
        this.cbShowDeprecated.setSelected(this.model.isShowDeprecatedMembers());
        this.cbInsertSingleProposalsAutomatically.setSelected(this.model.isCompletionInstantSubstitution());
        this.cbCaseSensitive.setSelected(this.model.isCompletionCaseSensitive());
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        this.model.setFoldingOptions(this.cbUseCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComments.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavadocComments.isSelected(), this.cbFoldMethods.isSelected());
        this.model.setCompletionOptions(this.cbInsertClosingBracketsAutomatically.isSelected(), this.cbAutoPopup.isSelected(), this.cbShowDeprecated.isSelected(), this.cbInsertSingleProposalsAutomatically.isSelected(), this.cbCaseSensitive.isSelected());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        if (actionEvent.getSource() == this.cbUseCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean bl = this.cbUseCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(bl);
        this.cbFoldInitialComments.setEnabled(bl);
        this.cbFoldInnerClasses.setEnabled(bl);
        this.cbFoldJavadocComments.setEnabled(bl);
        this.cbFoldMethods.setEnabled(bl);
    }
}

