/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.options.indentation.IndentationModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IndentationPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private IndentationModel model;
    private String originalText;
    private boolean listen = false;
    private boolean changed = false;
    private JCheckBox cbAddLeadingStarInComments;
    private JCheckBox cbAddNewLineBeforeBrace;
    private JCheckBox cbAddSpaceBeforeParenthesis;
    private JCheckBox cbExpandTabsToSpaces;
    private JEditorPane epPreview;
    private JScrollPane jScrollPane1;
    private JLabel lNumberOfSpacesPerIndent;
    private JLabel lPreview;
    private JLabel lStatementContinuationIndent;
    private JSpinner sNumberOfSpacesPerIndent;
    private JSpinner sStatementContinuationIndent;

    public IndentationPanel() {
        this.initComponents();
        IndentationPanel.loc(this.lStatementContinuationIndent, "Statement_Indent");
        IndentationPanel.loc(this.lNumberOfSpacesPerIndent, "Indent");
        IndentationPanel.loc(this.lPreview, "Preview");
        IndentationPanel.loc(this.cbExpandTabsToSpaces, "Expand_Tabs");
        IndentationPanel.loc(this.cbAddLeadingStarInComments, "Add_Leading_Star");
        IndentationPanel.loc(this.cbAddNewLineBeforeBrace, "Add_New_Line");
        IndentationPanel.loc(this.cbAddSpaceBeforeParenthesis, "Add_Space");
        this.epPreview.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_Preview"));
        this.epPreview.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_Preview"));
        this.epPreview.setBorder(new EtchedBorder());
        this.cbAddNewLineBeforeBrace.addActionListener(this);
        this.cbAddLeadingStarInComments.addActionListener(this);
        this.cbExpandTabsToSpaces.addActionListener(this);
        this.cbAddSpaceBeforeParenthesis.addActionListener(this);
        this.sStatementContinuationIndent.setModel(new SpinnerNumberModel(8, 1, 50, 1));
        this.sStatementContinuationIndent.addChangeListener(this);
        this.sNumberOfSpacesPerIndent.setModel(new SpinnerNumberModel(4, 1, 50, 1));
        this.sNumberOfSpacesPerIndent.addChangeListener(this);
        this.epPreview.setEnabled(false);
    }

    private void initComponents() {
        this.lStatementContinuationIndent = new JLabel();
        this.sStatementContinuationIndent = new JSpinner();
        this.lNumberOfSpacesPerIndent = new JLabel();
        this.sNumberOfSpacesPerIndent = new JSpinner();
        this.cbExpandTabsToSpaces = new JCheckBox();
        this.cbAddLeadingStarInComments = new JCheckBox();
        this.cbAddNewLineBeforeBrace = new JCheckBox();
        this.cbAddSpaceBeforeParenthesis = new JCheckBox();
        this.lPreview = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.epPreview = new JEditorPane();
        this.lStatementContinuationIndent.setLabelFor(this.sStatementContinuationIndent);
        this.lStatementContinuationIndent.setText("Statement Continuation Indent:");
        this.lNumberOfSpacesPerIndent.setLabelFor(this.sNumberOfSpacesPerIndent);
        this.lNumberOfSpacesPerIndent.setText("Number of Spaces per Indent:");
        this.cbExpandTabsToSpaces.setText("Expand Tabs to Spaces");
        this.cbExpandTabsToSpaces.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbExpandTabsToSpaces.setMargin(new Insets(0, 0, 0, 0));
        this.cbAddLeadingStarInComments.setText("Add Leading Star in Comments");
        this.cbAddLeadingStarInComments.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddLeadingStarInComments.setMargin(new Insets(0, 0, 0, 0));
        this.cbAddNewLineBeforeBrace.setText("Add New Line Before Brace");
        this.cbAddNewLineBeforeBrace.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddNewLineBeforeBrace.setMargin(new Insets(0, 0, 0, 0));
        this.cbAddSpaceBeforeParenthesis.setText("Add Space Before Parenthesis");
        this.cbAddSpaceBeforeParenthesis.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddSpaceBeforeParenthesis.setMargin(new Insets(0, 0, 0, 0));
        this.lPreview.setText("Preview:");
        this.jScrollPane1.setViewportView(this.epPreview);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lPreview).add((Component)this.lNumberOfSpacesPerIndent).add((Component)this.lStatementContinuationIndent)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sStatementContinuationIndent, -2, -1, -2).add((Component)this.sNumberOfSpacesPerIndent, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbExpandTabsToSpaces).add((Component)this.cbAddLeadingStarInComments).add((Component)this.cbAddNewLineBeforeBrace).add((Component)this.cbAddSpaceBeforeParenthesis)).addContainerGap(49, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lStatementContinuationIndent).add((Component)this.sStatementContinuationIndent, -2, -1, -2).add((Component)this.cbExpandTabsToSpaces)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lNumberOfSpacesPerIndent).add((Component)this.sNumberOfSpacesPerIndent, -2, -1, -2).add((Component)this.cbAddLeadingStarInComments)).addPreferredGap(0).add((Component)this.cbAddNewLineBeforeBrace).addPreferredGap(0).add((Component)this.cbAddSpaceBeforeParenthesis).addPreferredGap(0).add((Component)this.lPreview).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 190, Short.MAX_VALUE)));
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)IndentationPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(IndentationPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(IndentationPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)IndentationPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)IndentationPanel.loc("CTL_" + string));
        }
    }

    private void updatePreview() {
        this.model.setJavaFormatLeadingStarInComment(this.cbAddLeadingStarInComments.isSelected());
        this.model.setJavaFormatNewlineBeforeBrace(this.cbAddNewLineBeforeBrace.isSelected());
        this.model.setJavaFormatSpaceBeforeParenthesis(this.cbAddSpaceBeforeParenthesis.isSelected());
        this.model.setExpandTabs(this.cbExpandTabsToSpaces.isSelected());
        this.model.setJavaFormatStatementContinuationIndent((Integer)this.sStatementContinuationIndent.getValue());
        this.model.setSpacesPerTab((Integer)this.sNumberOfSpacesPerIndent.getValue());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setText(IndentationPanel.this.originalText);
                Document document = IndentationPanel.this.epPreview.getDocument();
                if (document instanceof BaseDocument) {
                    try {
                        ((BaseDocument)document).getFormatter().reformat((BaseDocument)document, 0, ((BaseDocument)document).getEndPosition().getOffset() - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        this.updatePreview();
        if (this.changed != this.model.isChanged()) {
            this.firePropertyChange("changed", (Object)this.changed, (Object)this.model.isChanged());
        }
        this.changed = this.model.isChanged();
    }

    public void update() {
        this.model = new IndentationModel();
        if (this.originalText == null) {
            InputStream inputStream = this.getClass().getResourceAsStream("/org/netbeans/modules/options/indentation/indentationExample");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuffer.append(string).append('\n');
                    string = bufferedReader.readLine();
                }
                this.originalText = new String(stringBuffer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.listen = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndentationPanel.this.epPreview.setContentType("text/x-java");
                IndentationPanel.this.cbExpandTabsToSpaces.setSelected(IndentationPanel.this.model.isExpandTabs());
                IndentationPanel.this.cbAddLeadingStarInComments.setSelected(IndentationPanel.this.model.getJavaFormatLeadingStarInComment());
                IndentationPanel.this.cbAddNewLineBeforeBrace.setSelected(IndentationPanel.this.model.getJavaFormatNewlineBeforeBrace());
                IndentationPanel.this.cbAddSpaceBeforeParenthesis.setSelected(IndentationPanel.this.model.getJavaFormatSpaceBeforeParenthesis());
                IndentationPanel.this.sNumberOfSpacesPerIndent.setValue(IndentationPanel.this.model.getSpacesPerTab());
                IndentationPanel.this.sStatementContinuationIndent.setValue(IndentationPanel.this.model.getJavaFormatStatementContinuationIndent());
                IndentationPanel.this.listen = true;
                IndentationPanel.this.updatePreview();
            }
        });
    }

    public void applyChanges() {
        if (this.model != null) {
            this.model.applyChanges();
        }
    }

    public void cancel() {
        if (this.model != null) {
            this.model.revertChanges();
        }
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        return this.model.isChanged();
    }
}

