/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.EditorBridge;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ExportShortcutsAction {
    private static Action exportIDEActionsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Actions_Action"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayersBridge layersBridge = new LayersBridge();
            Map map = layersBridge.getActions();
            Map map2 = ExportShortcutsAction.resolveNames(map);
            ExportShortcutsAction.generateLayersXML(layersBridge, map2);
        }
    };
    private static Action exportIDEShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_IDE_Shortcuts_Action"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            LayersBridge layersBridge = new LayersBridge();
            layersBridge.getActions();
            List list = layersBridge.getProfiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Map map = layersBridge.getKeymap(string);
                Map map2 = LayersBridge.shortcutToAction(map);
                hashMap.put(string, map2);
            }
            ExportShortcutsAction.generateLayersXML(layersBridge, hashMap);
        }
    };
    private static Action exportEditorShortcutsAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Editor_Shortcuts_Action"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashMap hashMap = new HashMap();
            EditorBridge editorBridge = new EditorBridge();
            editorBridge.getActions();
            Map map = editorBridge.readKeymap(editorBridge.getCurrentProfile());
            ExportShortcutsAction.generateEditorXML(map);
        }
    };
    private static Action exportShortcutsToHTMLAction = new AbstractAction(){
        {
            this.putValue("Name", ExportShortcutsAction.loc("CTL_Export_Shortcuts_to_HTML_Action"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExportShortcutsAction.exportShortcutsToHTML();
        }
    };

    public static Action getExportIDEActionsAction() {
        return exportIDEActionsAction;
    }

    public static Action getExportIDEShortcutsAction() {
        return exportIDEShortcutsAction;
    }

    public static Action getExportEditorShortcutsAction() {
        return exportEditorShortcutsAction;
    }

    public static Action getExportShortcutsToHTMLAction() {
        return exportShortcutsToHTMLAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportShortcutsToHTML() {
        CharSequence charSequence;
        KeymapModel keymapModel = new KeymapModel();
        TreeMap<CharSequence, Map> treeMap = new TreeMap<CharSequence, Map>();
        Iterator<Object> iterator = keymapModel.getProfiles().iterator();
        while (iterator.hasNext()) {
            charSequence = (String)iterator.next();
            treeMap.put(charSequence, keymapModel.getKeymap((String)charSequence));
        }
        try {
            String string;
            charSequence = new StringBuffer();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "html", attribs, "");
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "body", attribs, "  ");
            attribs.add("border", "1");
            attribs.add("cellpadding", "1");
            attribs.add("cellspacing", "0");
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "table", attribs, "    ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "tr", attribs, "      ");
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "td", attribs, "        ");
            XMLStorage.generateFolderStart((StringBuffer)charSequence, "h2", attribs, "        ");
            ((StringBuffer)charSequence).append("Action Name");
            XMLStorage.generateFolderEnd((StringBuffer)charSequence, "h2", "        ");
            XMLStorage.generateFolderEnd((StringBuffer)charSequence, "td", "        ");
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                XMLStorage.generateFolderStart((StringBuffer)charSequence, "td", attribs, "        ");
                XMLStorage.generateFolderStart((StringBuffer)charSequence, "h2", attribs, "        ");
                ((StringBuffer)charSequence).append(string);
                XMLStorage.generateFolderEnd((StringBuffer)charSequence, "h2", "        ");
                XMLStorage.generateFolderEnd((StringBuffer)charSequence, "td", "        ");
            }
            ExportShortcutsAction.exportShortcutsToHTML2(keymapModel, (StringBuffer)charSequence, treeMap);
            XMLStorage.generateFolderEnd((StringBuffer)charSequence, "table", "    ");
            XMLStorage.generateFolderEnd((StringBuffer)charSequence, "body", "  ");
            XMLStorage.generateFolderEnd((StringBuffer)charSequence, "html", "");
            string = FileUtil.createData((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot(), (String)"shortcuts.html");
            FileLock fileLock = string.lock();
            try {
                OutputStream outputStream = string.getOutputStream(fileLock);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(((StringBuffer)charSequence).toString());
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static void exportShortcutsToHTML2(KeymapModel keymapModel, StringBuffer stringBuffer, Map map) {
        ArrayList arrayList = new ArrayList(keymapModel.getActionCategories());
        Collections.sort(arrayList);
        XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            XMLStorage.generateFolderStart(stringBuffer, "tr", attribs, "      ");
            attribs.add("colspan", Integer.toString(map.size() + 1));
            attribs.add("rowspan", "1");
            XMLStorage.generateFolderStart(stringBuffer, "td", attribs, "        ");
            attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "h3", attribs, "        ");
            stringBuffer.append(string);
            XMLStorage.generateFolderEnd(stringBuffer, "h3", "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "tr", "      ");
            ExportShortcutsAction.exportShortcutsToHTML3(stringBuffer, keymapModel, string, map);
        }
    }

    private static void exportShortcutsToHTML3(StringBuffer stringBuffer, KeymapModel keymapModel, String string, Map map) {
        Object object;
        Set set = keymapModel.getActions(string);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (ActionImpl)iterator.next();
            treeMap.put(object.getDisplayName(), object);
        }
        object = new XMLStorage.Attribs(true);
        iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ActionImpl actionImpl = (ActionImpl)treeMap.get(string2);
            XMLStorage.generateFolderStart(stringBuffer, "tr", (XMLStorage.Attribs)object, "      ");
            XMLStorage.generateFolderStart(stringBuffer, "td", (XMLStorage.Attribs)object, "        ");
            stringBuffer.append(string2);
            XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                Map map2 = (Map)map.get(string3);
                Set set2 = (Set)map2.get(actionImpl);
                XMLStorage.generateFolderStart(stringBuffer, "td", (XMLStorage.Attribs)object, "        ");
                ExportShortcutsAction.printShortcuts(set2, stringBuffer);
                XMLStorage.generateFolderEnd(stringBuffer, "td", "        ");
            }
            XMLStorage.generateFolderEnd(stringBuffer, "tr", "      ");
        }
    }

    private static void printShortcuts(Set set, StringBuffer stringBuffer) {
        if (set == null) {
            stringBuffer.append('-');
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLayersXML(LayersBridge layersBridge, Map map) {
        Writer writer = null;
        try {
            writer = ExportShortcutsAction.openWriter();
            if (writer == null) {
                return;
            }
            StringBuffer stringBuffer = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "filesystem", attribs, "");
            attribs.add("name", "Keymaps");
            XMLStorage.generateFolderStart(stringBuffer, "folder", attribs, "    ");
            ExportShortcutsAction.generateShadowsToXML(layersBridge, stringBuffer, map, "        ");
            XMLStorage.generateFolderEnd(stringBuffer, "folder", "    ");
            XMLStorage.generateFolderEnd(stringBuffer, "filesystem", "");
            System.out.println(stringBuffer.toString());
            writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEditorXML(Map map) {
        Writer writer = null;
        try {
            Object object;
            writer = ExportShortcutsAction.openWriter();
            if (writer == null) {
                return;
            }
            StringBuffer stringBuffer = XMLStorage.generateHeader();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            XMLStorage.generateFolderStart(stringBuffer, "bindings", attribs, "");
            TreeMap treeMap = new TreeMap();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (ActionImpl)iterator.next();
                treeMap.put(object.getDisplayName(), map.get(object));
            }
            iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Set set = (Set)treeMap.get(object);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    attribs = new XMLStorage.Attribs(true);
                    attribs.add("actionName", (String)object);
                    attribs.add("key", string);
                    XMLStorage.generateLeaf(stringBuffer, "bind", attribs, "  ");
                }
            }
            XMLStorage.generateFolderEnd(stringBuffer, "bindings", "");
            System.out.println(stringBuffer.toString());
            writer.write(stringBuffer.toString());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Map resolveNames(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            HashMap<String, ActionImpl> hashMap2 = new HashMap<String, ActionImpl>();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                ActionImpl actionImpl = (ActionImpl)iterator2.next();
                hashMap2.put(actionImpl.getDisplayName(), actionImpl);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    private static void generateShadowsToXML(LayersBridge layersBridge, StringBuffer stringBuffer, Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            if (v instanceof Map) {
                object = new XMLStorage.Attribs(true);
                ((XMLStorage.Attribs)object).add("name", string2);
                XMLStorage.generateFolderStart(stringBuffer, "folder", (XMLStorage.Attribs)object, string);
                ExportShortcutsAction.generateShadowsToXML(layersBridge, stringBuffer, (Map)v, "    " + string);
                XMLStorage.generateFolderEnd(stringBuffer, "folder", string);
                continue;
            }
            object = layersBridge.getDataObject(v);
            if (object == null) {
                System.out.println("no Dataobject " + v);
                continue;
            }
            FileObject fileObject = object.getPrimaryFile();
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", string2 + ".shadow");
            XMLStorage.generateFolderStart(stringBuffer, "file", attribs, string);
            XMLStorage.Attribs attribs2 = new XMLStorage.Attribs(true);
            attribs2.add("name", "originalFile");
            attribs2.add("stringvalue", fileObject.getPath());
            XMLStorage.generateLeaf(stringBuffer, "attr", attribs2, string + "    ");
            XMLStorage.generateFolderEnd(stringBuffer, "file", string);
        }
    }

    private static Writer openWriter() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        if (n != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        return new FileWriter(file);
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)ExportShortcutsAction.class, (String)string);
    }
}

