/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapListRenderer;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KeymapPanel
extends JPanel
implements ActionListener,
TreeSelectionListener,
ListSelectionListener {
    private boolean listen = false;
    private JButton bAdd;
    private JButton bDelete;
    private JButton bDuplicate;
    private JButton bRemove;
    private JComboBox cbProfile;
    private JLabel lActions;
    private JLabel lProfile;
    private JLabel lShortcuts;
    private JList liShortcuts;
    private JScrollPane spActions;
    private JScrollPane spShortcuts;
    private JTree tActions;
    private boolean initialized = false;
    private KeymapViewModel model;

    public KeymapPanel() {
        this.initComponents();
        KeymapPanel.loc(this.bDuplicate, "Duplicate");
        KeymapPanel.loc(this.bDelete, "Delete");
        this.liShortcuts.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Shortcuts"));
        this.liShortcuts.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Shortcuts"));
        this.tActions.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Actions"));
        this.tActions.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Actions"));
        this.cbProfile.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_Profiles"));
        this.cbProfile.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_Profiles"));
        this.bDuplicate.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.tActions.setRootVisible(false);
        this.tActions.setShowsRootHandles(true);
        this.tActions.addTreeSelectionListener(this);
        this.cbProfile.addActionListener(this);
        KeymapPanel.loc(this.bAdd, "Add_Shortcut");
        KeymapPanel.loc(this.bRemove, "Remove_Shortcut");
        this.bAdd.addActionListener(this);
        this.bRemove.addActionListener(this);
        this.liShortcuts.addListSelectionListener(this);
        this.bAdd.setEnabled(false);
        this.bRemove.setEnabled(false);
        KeymapPanel.loc(this.lShortcuts, "Shortcuts");
        this.lShortcuts.setLabelFor(this.liShortcuts);
        KeymapPanel.loc(this.lActions, "Actions");
        this.lActions.setLabelFor(this.tActions);
    }

    private void initComponents() {
        this.lProfile = new JLabel();
        this.cbProfile = new JComboBox();
        this.bDuplicate = new JButton();
        this.bDelete = new JButton();
        this.lActions = new JLabel();
        this.spActions = new JScrollPane();
        this.tActions = new JTree();
        this.lShortcuts = new JLabel();
        this.spShortcuts = new JScrollPane();
        this.liShortcuts = new JList();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.lProfile.setText("Profile:");
        this.bDuplicate.setText("Duplicate...");
        this.bDelete.setText("Delete");
        this.lActions.setText("Actions:");
        this.spActions.setViewportView(this.tActions);
        this.lShortcuts.setText("Shortcuts:");
        this.spShortcuts.setViewportView(this.liShortcuts);
        this.bAdd.setText("Add...");
        this.bRemove.setText("Remove");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lProfile).addPreferredGap(0).add((Component)this.cbProfile, 0, 139, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.bDuplicate)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.spShortcuts, -2, 175, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.bRemove).add((Component)this.bAdd)))).addPreferredGap(0).add((Component)this.bDelete)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lActions).addContainerGap()).add((Component)this.spActions, -1, 367, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lShortcuts).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.bAdd, this.bRemove}, 1);
        groupLayout.linkSize(new Component[]{this.bDelete, this.bDuplicate}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.bDelete).add((Component)this.bDuplicate).add((Component)this.lProfile).add((Component)this.cbProfile, -2, -1, -2)).addPreferredGap(0).add((Component)this.lActions).addPreferredGap(0).add((Component)this.spActions, -1, 168, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lShortcuts).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bAdd).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.spShortcuts, 0, 52, Short.MAX_VALUE))));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.listen) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.bAdd) {
            Object object2 = this.tActions.getSelectionPath().getLastPathComponent();
            String string = ShortcutsDialog.getShortcut(this.getModel());
            if (string == null) {
                return;
            }
            this.getModel().addShortcut(this.tActions.getSelectionPath(), string);
            this.selectAction(object2);
            if (this.liShortcuts.getModel().getSize() > 0) {
                this.liShortcuts.setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KeymapPanel.this.liShortcuts.requestFocus();
                }
            });
        } else if (object == this.bRemove) {
            int n = this.liShortcuts.getSelectedIndex();
            Object object3 = this.tActions.getSelectionPath().getLastPathComponent();
            String string = (String)this.liShortcuts.getSelectedValue();
            this.getModel().removeShortcut(this.tActions.getSelectionPath(), string);
            this.selectAction(object3);
            if (this.liShortcuts.getModel().getSize() > n) {
                this.liShortcuts.setSelectedIndex(n);
            } else if (this.liShortcuts.getModel().getSize() > 0) {
                this.liShortcuts.setSelectedIndex(0);
            }
        } else if (object == this.bDelete) {
            this.deleteCurrentProfile();
        } else if (object == this.cbProfile) {
            String string = (String)this.cbProfile.getSelectedItem();
            this.getModel().setCurrentProfile(string);
            if (this.getModel().isCustomProfile(string)) {
                KeymapPanel.loc(this.bDelete, "Delete");
            } else {
                KeymapPanel.loc(this.bDelete, "Restore");
            }
            this.refreshAction();
        } else if (object == this.bDuplicate) {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(KeymapPanel.loc("CTL_Create_New_Profile_Message"), KeymapPanel.loc("CTL_Create_New_Profile_Title"));
            inputLine.setInputText((String)this.cbProfile.getSelectedItem());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() == NotifyDescriptor.OK_OPTION) {
                String string = inputLine.getInputText();
                Iterator iterator = this.getModel().getProfiles().iterator();
                while (iterator.hasNext()) {
                    if (!string.equals(iterator.next())) continue;
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)KeymapPanel.loc("CTL_Duplicate_Profile_Name"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return;
                }
                this.getModel().cloneProfile(string);
                this.cbProfile.addItem(inputLine.getInputText());
                this.cbProfile.setSelectedItem(inputLine.getInputText());
            }
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.listen) {
            return;
        }
        this.refreshAction();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.listen) {
            return;
        }
        int n = this.liShortcuts.getSelectedIndex();
        if (n < 0) {
            this.bRemove.setEnabled(false);
            return;
        }
        this.bRemove.setEnabled(true);
    }

    void update() {
        if (!this.initialized) {
            this.initialized = true;
            this.listen = false;
            this.tActions.setCellRenderer(new KeymapListRenderer(this.getModel()));
            this.tActions.setModel(this.getModel());
            List list = this.getModel().getProfiles();
            this.cbProfile.removeAllItems();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.cbProfile.addItem(list.get(i));
            }
            this.listen = true;
        }
        this.cbProfile.setSelectedItem(this.getModel().getCurrentProfile());
    }

    private void deleteCurrentProfile() {
        String string = (String)this.cbProfile.getSelectedItem();
        this.getModel().deleteProfile(string);
        if (this.getModel().isCustomProfile(string)) {
            this.cbProfile.removeItem(string);
            this.cbProfile.setSelectedIndex(0);
        }
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        this.getModel().apply();
    }

    void cancel() {
        if (this.model == null) {
            return;
        }
        this.model.cancel();
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.getModel().isChanged();
    }

    KeymapViewModel getModel() {
        if (this.model == null) {
            this.model = new KeymapViewModel();
        }
        return this.model;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)KeymapPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(KeymapPanel.loc("AN_" + string));
            component.getAccessibleContext().setAccessibleDescription(KeymapPanel.loc("AD_" + string));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)KeymapPanel.loc("CTL_" + string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)KeymapPanel.loc("CTL_" + string));
        }
    }

    void refreshAction() {
        Object object = this.tActions.getSelectionPath() == null ? null : this.tActions.getSelectionPath().getLastPathComponent();
        this.selectAction(object);
        if (this.liShortcuts.getModel().getSize() > 0) {
            this.liShortcuts.setSelectedIndex(0);
        }
    }

    void selectAction(Object object) {
        if (object == null || object instanceof String) {
            this.liShortcuts.setModel(new DefaultListModel());
            this.bAdd.setEnabled(false);
            this.bRemove.setEnabled(false);
            return;
        }
        this.bAdd.setEnabled(true);
        this.bRemove.setEnabled(false);
        final String[] stringArray = this.getModel().getShortcuts((ActionImpl)object);
        this.liShortcuts.setModel(new AbstractListModel(){

            public int getSize() {
                return stringArray.length;
            }

            public Object getElementAt(int n) {
                return stringArray[n];
            }
        });
    }
}

