/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.AbbrevSettings;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class CodeTemplateCompletionItem
implements CompletionItem {
    private static ImageIcon icon;
    private final CodeTemplate codeTemplate;
    private String leftText;
    static /* synthetic */ Class class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem;

    public static String toHtmlText(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\n': {
                    string2 = "<br>";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (string2 != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(120 * string.length() / 100);
                    if (i > 0) {
                        stringBuffer.append(string.substring(0, i));
                    }
                }
                stringBuffer.append(string2);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }

    public CodeTemplateCompletionItem(CodeTemplate codeTemplate) {
        this.codeTemplate = codeTemplate;
    }

    private String getLeftText() {
        return this.codeTemplate.getDescription();
    }

    private String getRightText() {
        if (this.leftText == null) {
            this.leftText = CodeTemplateCompletionItem.toHtmlText(this.codeTemplate.getAbbreviation());
        }
        return this.leftText;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (icon == null) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/editor/codetemplates/resources/code_template.png"));
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion.get().hideAll();
        Document document = jTextComponent.getDocument();
        int n = jTextComponent.getSelectionStart();
        int n2 = CodeTemplateCompletionItem.getInitialMatchLength(document, n, this.codeTemplate.getParametrizedText());
        if (n2 > 0) {
            try {
                document.remove(n - n2, n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.codeTemplate.insert(jTextComponent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public static int getInitialMatchLength(Document document, int n, String string) {
        int n2;
        CharSequence charSequence = DocumentUtilities.getText((Document)((BaseDocument)document));
        for (n2 = Math.min(string.length(), n); n2 > 0; --n2) {
            int n3;
            for (n3 = 1; n3 < n2 && charSequence.charAt(n - n3) == string.charAt(n2 - n3); ++n3) {
            }
            if (n3 == n2) break;
        }
        return n2;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(this.codeTemplate));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getSortPriority() {
        return 650;
    }

    public CharSequence getSortText() {
        return "";
    }

    public CharSequence getInsertPrefix() {
        String string = this.codeTemplate.getParametrizedText();
        int n = string.indexOf("${");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static final class DocItem
    implements CompletionDocumentation {
        private CodeTemplate codeTemplate;
        private String text;

        DocItem(CodeTemplate codeTemplate) {
            this.codeTemplate = codeTemplate;
            this.text = this.createText();
        }

        public String getText() {
            return this.text;
        }

        private String createText() {
            StringBuffer stringBuffer = new StringBuffer("<html><pre>");
            ParametrizedTextParser parametrizedTextParser = new ParametrizedTextParser(null, this.codeTemplate.getParametrizedText());
            parametrizedTextParser.parse();
            parametrizedTextParser.appendHtmlText(stringBuffer);
            stringBuffer.append("</pre><br>");
            String string = CodeTemplateApiPackageAccessor.get().getOperation(this.codeTemplate).getMimeType();
            stringBuffer.append(NbBundle.getMessage((Class)(class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem == null ? (class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem = CodeTemplateCompletionItem.class$("org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem")) : class$org$netbeans$lib$editor$codetemplates$CodeTemplateCompletionItem), (String)"DOC_ITEM_Abbreviation", (Object)CodeTemplateCompletionItem.toHtmlText(this.codeTemplate.getAbbreviation()), (Object)AbbrevSettings.get(string).getExpandKeyStrokeText()));
            return stringBuffer.toString();
        }

        public CompletionDocumentation resolveLink(String string) {
            return null;
        }

        public URL getURL() {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static final class DocQuery
    extends AsyncCompletionQuery {
        private CodeTemplate codeTemplate;

        DocQuery(CodeTemplate codeTemplate) {
            this.codeTemplate = codeTemplate;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(this.codeTemplate));
            completionResultSet.finish();
        }
    }
}

