/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.lib.editor.codetemplates.CodeTemplateCompletionItem;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public final class CodeTemplateCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return n != 1 || CodeTemplateCompletionProvider.isAbbrevDisabled(jTextComponent) ? null : new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static boolean isAbbrevDisabled(JTextComponent jTextComponent) {
        return Abbrev.isAbbrevDisabled((JTextComponent)jTextComponent);
    }

    private static final class Query
    extends AsyncCompletionQuery
    implements ChangeListener {
        private JTextComponent component;
        private int queryCaretOffset;
        private int queryAnchorOffset;
        private List queryResult;
        private String filterPrefix;

        private Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getSelectionStart();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            if (n >= this.queryCaretOffset && this.queryAnchorOffset < this.queryCaretOffset) {
                try {
                    this.filterPrefix = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (!this.isJavaIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.queryResult != null) {
                completionResultSet.addAllItems(this.getFilteredData(this.queryResult, this.filterPrefix));
            }
            completionResultSet.finish();
        }

        private boolean isJavaIdentifierPart(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (Character.isJavaIdentifierPart(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection collection, String string) {
            ArrayList<CodeTemplateCompletionItem> arrayList = new ArrayList<CodeTemplateCompletionItem>();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CodeTemplateCompletionItem codeTemplateCompletionItem = (CodeTemplateCompletionItem)iterator.next();
                if (!((Object)codeTemplateCompletionItem.getInsertPrefix()).toString().startsWith(string)) continue;
                arrayList.add(codeTemplateCompletionItem);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            CodeTemplateManagerOperation codeTemplateManagerOperation = CodeTemplateManagerOperation.get(document);
            String string = null;
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                abstractDocument.readLock();
                try {
                    if (abstractDocument instanceof BaseDocument) {
                        string = Utilities.getIdentifierBefore((BaseDocument)((BaseDocument)abstractDocument), (int)n);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    abstractDocument.readUnlock();
                }
            }
            codeTemplateManagerOperation.waitLoaded();
            this.queryCaretOffset = n;
            int n2 = this.queryAnchorOffset = string != null ? n - string.length() : n;
            if (string != null) {
                boolean bl = !SettingsUtil.getBoolean(this.component.getUI().getEditorKit(this.component).getClass(), (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
                Collection collection = codeTemplateManagerOperation.findByParametrizedText(string, bl);
                Collection collection2 = codeTemplateManagerOperation.getTemplateFilters(this.component, this.queryAnchorOffset);
                this.queryResult = new ArrayList(collection.size());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
                    if (!Query.accept(codeTemplate, collection2)) continue;
                    this.queryResult.add(new CodeTemplateCompletionItem(codeTemplate));
                }
                completionResultSet.addAllItems((Collection)this.queryResult);
            }
            completionResultSet.setAnchorOffset(this.queryAnchorOffset);
            completionResultSet.finish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            Query query = this;
            synchronized (query) {
                this.notify();
            }
        }

        private static boolean accept(CodeTemplate codeTemplate, Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CodeTemplateFilter codeTemplateFilter = (CodeTemplateFilter)iterator.next();
                if (codeTemplateFilter.accept(codeTemplate)) continue;
                return false;
            }
            return true;
        }
    }
}

