/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateComparator;
import org.netbeans.lib.editor.codetemplates.CodeTemplateInsertHandler;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class CodeTemplateManagerOperation
implements LookupListener,
Runnable,
SettingsChangeListener {
    private static Map mime2operation;
    private final CodeTemplateManager manager;
    private final String mimeType;
    private Lookup.Result descriptions;
    private Collection processorFactories;
    private Collection filterFactories;
    private Map abbrev2template;
    private List sortedTemplatesByAbbrev;
    private List unmodSortedTemplatesByAbbrev;
    private List sortedTemplatesByParametrizedText;
    private List selectionTemplates;
    private EventListenerList listenerList = new EventListenerList();
    private boolean settingsListeningInitialized;
    private static final int MATCH_NO = 0;
    private static final int MATCH_IGNORE_CASE = 1;
    private static final int MATCH = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized CodeTemplateManager getManager(Document document) {
        return CodeTemplateManagerOperation.get(document).getManager();
    }

    public static synchronized CodeTemplateManagerOperation get(Document document) {
        boolean bl;
        String string = (String)document.getProperty("mimeType");
        CodeTemplateManagerOperation codeTemplateManagerOperation = (CodeTemplateManagerOperation)document.getProperty(CodeTemplateManagerOperation.class);
        boolean bl2 = bl = codeTemplateManagerOperation != null && CodeTemplateManagerOperation.mimeTypesEqual(string, codeTemplateManagerOperation.getMimeType());
        if (!bl) {
            WeakReference weakReference = (WeakReference)mime2operation.get(string);
            codeTemplateManagerOperation = weakReference != null ? (CodeTemplateManagerOperation)weakReference.get() : null;
            if (codeTemplateManagerOperation == null) {
                codeTemplateManagerOperation = new CodeTemplateManagerOperation(string);
                CodeTemplateApiPackageAccessor.get().createCodeTemplateManager(codeTemplateManagerOperation);
                mime2operation.put(string, new WeakReference<CodeTemplateManagerOperation>(codeTemplateManagerOperation));
            }
            document.putProperty(CodeTemplateManagerOperation.class, codeTemplateManagerOperation);
        }
        return codeTemplateManagerOperation;
    }

    private static boolean mimeTypesEqual(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    private CodeTemplateManagerOperation(String string) {
        this.mimeType = string;
        CodeTemplateManager.class.getName();
        this.manager = CodeTemplateApiPackageAccessor.get().createCodeTemplateManager(this);
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public CodeTemplateManager getManager() {
        if (!$assertionsDisabled && this.manager == null) {
            throw new AssertionError();
        }
        return this.manager;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Collection getCodeTemplates() {
        return this.unmodSortedTemplatesByAbbrev;
    }

    public Collection findSelectionTemplates() {
        return this.selectionTemplates;
    }

    public CodeTemplate findByAbbreviation(String string) {
        return (CodeTemplate)this.abbrev2template.get(string);
    }

    public Collection findByParametrizedText(String string, boolean bl) {
        int n;
        CodeTemplate codeTemplate;
        int n2;
        ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>();
        int n3 = 0;
        int n4 = this.sortedTemplatesByParametrizedText.size() - 1;
        while (n3 <= n4) {
            n2 = n3 + n4 >> 1;
            codeTemplate = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(n2);
            n = CodeTemplateManagerOperation.compareTextIgnoreCase(codeTemplate.getParametrizedText(), string);
            if (n < 0) {
                n3 = n2 + 1;
                continue;
            }
            if (n > 0) {
                n4 = n2 - 1;
                continue;
            }
            n3 = n2;
            break;
        }
        for (n2 = n3 - 1; n2 >= 0 && (n = CodeTemplateManagerOperation.matchPrefix((codeTemplate = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(n2)).getParametrizedText(), string)) != 0; --n2) {
            if (n == 1) {
                if (!bl) continue;
                arrayList.add(codeTemplate);
                continue;
            }
            arrayList.add(codeTemplate);
        }
        for (n2 = n3; n2 < this.sortedTemplatesByParametrizedText.size() && (n = CodeTemplateManagerOperation.matchPrefix((codeTemplate = (CodeTemplate)this.sortedTemplatesByParametrizedText.get(n2)).getParametrizedText(), string)) != 0; ++n2) {
            if (n == 1) {
                if (!bl) continue;
                arrayList.add(codeTemplate);
                continue;
            }
            arrayList.add(codeTemplate);
        }
        return arrayList;
    }

    public Collection getTemplateFilters(JTextComponent jTextComponent, int n) {
        ArrayList<CodeTemplateFilter> arrayList = new ArrayList<CodeTemplateFilter>();
        Iterator iterator = this.filterFactories.iterator();
        while (iterator.hasNext()) {
            CodeTemplateFilter.Factory factory = (CodeTemplateFilter.Factory)iterator.next();
            arrayList.add(factory.createFilter(jTextComponent, n));
        }
        return arrayList;
    }

    public void insert(CodeTemplate codeTemplate, JTextComponent jTextComponent) {
        CodeTemplateInsertHandler codeTemplateInsertHandler = new CodeTemplateInsertHandler(codeTemplate, jTextComponent, this.processorFactories);
        codeTemplateInsertHandler.processTemplate();
    }

    private static int matchPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        boolean bl = true;
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return 0;
        }
        for (n = 0; n < n2; ++n) {
            char c;
            char c2 = charSequence.charAt(n);
            if (c2 == (c = charSequence2.charAt(n))) continue;
            bl = false;
            if (Character.toLowerCase(c2) != Character.toLowerCase(c)) break;
        }
        if (n == n2) {
            return bl ? 2 : 1;
        }
        return 0;
    }

    private static int compareTextIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = Math.min(charSequence.length(), charSequence2.length());
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = Character.toLowerCase(charSequence.charAt(i));
            if (c2 == (c = Character.toLowerCase(charSequence2.charAt(i)))) continue;
            return c2 - c;
        }
        return charSequence.length() - charSequence2.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            return this.descriptions != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLoadedListener(ChangeListener changeListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (this.descriptions != null) {
                changeListener.stateChanged(new ChangeEvent(this));
            } else {
                this.listenerList.add(ChangeListener.class, changeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitLoaded() {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            if (!this.isLoaded()) {
                try {
                    this.listenerList.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged(ChangeEvent changeEvent) {
        Object[] objectArray;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            objectArray = this.listenerList.getListenerList();
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if ((class$javax$swing$event$ChangeListener == null ? CodeTemplateManagerOperation.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener) != objectArray[i]) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void run() {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getMimeType()));
        Lookup.Result result = lookup.lookup(new Lookup.Template(CodeTemplateProcessorFactory.class));
        this.processorFactories = result.allInstances();
        result = lookup.lookup(new Lookup.Template(CodeTemplateFilter.Factory.class));
        this.filterFactories = result.allInstances();
        this.setDescriptions(Lookup.EMPTY.lookup(new Lookup.Template(CodeTemplateDescription.class)));
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        this.rebuildCodeTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDescriptions(Lookup.Result result) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.descriptions = result;
            this.rebuildCodeTemplates();
            this.fireStateChanged(new ChangeEvent(this.manager));
            this.listenerList.notifyAll();
        }
    }

    private Collection updateDescriptionInstances(Collection arrayList) {
        arrayList = new ArrayList<CodeTemplateDescription>();
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)this.mimeType));
        BaseOptions baseOptions = (BaseOptions)lookup.lookup(BaseOptions.class);
        if (baseOptions != null) {
            Map map = baseOptions.getAbbrevMap();
            if (map != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    String string3 = string2.replaceAll("([^|]+)[|]([^|]+)", "$1\\${cursor}$2");
                    string3.replaceAll("[|][|]", "[|]");
                    String string4 = string2;
                    int n = string2.indexOf(10);
                    if (n != -1) {
                        string4 = string2.substring(0, n) + "...";
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    ParametrizedTextParser parametrizedTextParser = new ParametrizedTextParser(null, string4);
                    parametrizedTextParser.parse();
                    parametrizedTextParser.appendHtmlText(stringBuffer);
                    string4 = stringBuffer.toString();
                    CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(string, string4, string3, null);
                    arrayList.add(codeTemplateDescription);
                }
            }
            if (!this.settingsListeningInitialized) {
                this.settingsListeningInitialized = true;
                Settings.addSettingsChangeListener((SettingsChangeListener)this);
            }
        }
        return arrayList;
    }

    private void rebuildCodeTemplates() {
        Collection collection = this.descriptions.allInstances();
        collection = this.updateDescriptionInstances(collection);
        ArrayList<CodeTemplate> arrayList = new ArrayList<CodeTemplate>(collection.size());
        this.selectionTemplates = new ArrayList(collection.size());
        CodeTemplateApiPackageAccessor codeTemplateApiPackageAccessor = CodeTemplateApiPackageAccessor.get();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CodeTemplateDescription codeTemplateDescription = (CodeTemplateDescription)iterator.next();
            CodeTemplate codeTemplate = codeTemplateApiPackageAccessor.createCodeTemplate(this, codeTemplateDescription.getAbbreviation(), codeTemplateDescription.getDescription(), codeTemplateDescription.getParametrizedText());
            arrayList.add(codeTemplate);
            if (codeTemplateDescription.getParametrizedText().toLowerCase().indexOf("${selection") <= -1) continue;
            this.selectionTemplates.add(codeTemplate);
        }
        this.refreshMaps(arrayList);
    }

    private void refreshMaps(List list) {
        this.abbrev2template = new HashMap(list.size());
        this.sortedTemplatesByAbbrev = new ArrayList(list.size());
        this.unmodSortedTemplatesByAbbrev = Collections.unmodifiableList(this.sortedTemplatesByAbbrev);
        this.sortedTemplatesByParametrizedText = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CodeTemplate codeTemplate = (CodeTemplate)iterator.next();
            String string = codeTemplate.getAbbreviation();
            this.abbrev2template.put(string, codeTemplate);
            this.sortedTemplatesByAbbrev.add(codeTemplate);
            this.sortedTemplatesByParametrizedText.add(codeTemplate);
        }
        Collections.sort(this.sortedTemplatesByAbbrev, CodeTemplateComparator.BY_ABBREVIATION_IGNORE_CASE);
        Collections.sort(this.sortedTemplatesByParametrizedText, CodeTemplateComparator.BY_PARAMETRIZED_TEXT_IGNORE_CASE);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.rebuildCodeTemplates();
    }

    public void testInstallProcessorFactory(CodeTemplateProcessorFactory codeTemplateProcessorFactory) {
        this.processorFactories = Collections.singletonList(codeTemplateProcessorFactory);
    }

    static {
        $assertionsDisabled = !CodeTemplateManagerOperation.class.desiredAssertionStatus();
        mime2operation = new HashMap(8);
    }
}

