/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.AnnotationViewData;
import org.netbeans.modules.editor.errorstripe.AnnotationViewDataImpl;
import org.netbeans.modules.editor.errorstripe.caret.CaretMark;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AnnotationView
extends JComponent
implements FoldHierarchyListener,
MouseListener,
MouseMotionListener,
DocumentListener,
PropertyChangeListener,
Accessible {
    static final ErrorManager ERR;
    static final ErrorManager TIMING_ERR;
    private static final int STATUS_BOX_SIZE = 7;
    private static final int THICKNESS = 13;
    static final int PIXELS_FOR_LINE = 3;
    static final int LINE_SEPARATOR_SIZE = 1;
    static final int HEIGHT_OFFSET = 20;
    static final int UPPER_HANDLE = 4;
    static final int LOWER_HANDLE = 4;
    private BaseDocument doc;
    private JTextComponent pane;
    private static final Color STATUS_UP_PART_COLOR;
    private static final Color STATUS_DOWN_PART_COLOR;
    private static final int QUIET_TIME = 100;
    private final RequestProcessor.Task repaintTask;
    private final RepaintTask repaintTaskRunnable;
    private AnnotationViewData data;
    private static Icon busyIcon;
    private static final Color GLOBAL_RED;
    private static final Color GLOBAL_YELLOW;
    private static final Color GLOBAL_GREEN;
    private int[] modelToViewCache = null;
    private int lines = -1;
    private int height = -1;
    private static final int VIEW_TO_MODEL_IMPORTANCE = 1;
    private static String[] c;
    private static String[] tags;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnnotationView(JTextComponent jTextComponent) {
        this.pane = jTextComponent;
        this.setName("errorStripe");
        FoldHierarchy.get((JTextComponent)jTextComponent).addFoldHierarchyListener((FoldHierarchyListener)this);
        jTextComponent.addPropertyChangeListener(this);
        this.repaintTaskRunnable = new RepaintTask();
        this.repaintTask = RequestProcessor.getDefault().create((Runnable)this.repaintTaskRunnable);
        this.data = new AnnotationViewDataImpl(this, jTextComponent);
        this.updateForNewDocument();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(true);
        this.setToolTipText(NbBundle.getBundle((Class)AnnotationView.class).getString("TP_ErrorStripe"));
    }

    AnnotationViewData getData() {
        return this.data;
    }

    private synchronized void updateForNewDocument() {
        this.data.unregister();
        Document document = this.pane.getDocument();
        if (this.doc != null) {
            this.doc.removeDocumentListener((DocumentListener)this);
            this.doc = null;
        }
        if (document instanceof BaseDocument) {
            this.doc = (BaseDocument)this.pane.getDocument();
            this.doc.addDocumentListener((DocumentListener)this);
        }
        this.data.register(this.doc);
    }

    int[] getLinesSpan(int n) {
        int n2;
        double d = this.modelToView(n);
        if (d == -1.0) {
            return new int[]{n, n};
        }
        int n3 = n;
        for (n2 = n; d == this.modelToView(n2 - 1) && n2 > 0; --n2) {
        }
        while (n3 + 1 < Utilities.getRowCount((BaseDocument)this.doc) && d == this.modelToView(n3 + 1)) {
            ++n3;
        }
        return new int[]{n2, n3};
    }

    private void drawOneColorGlobalStatus(Graphics graphics, Color color) {
        graphics.setColor(color);
        int n = 3;
        int n2 = (this.topOffset() - 7) / 2;
        graphics.fillRect(n, n2, 7, 7);
        graphics.setColor(STATUS_DOWN_PART_COLOR);
        graphics.drawLine(n - 1, n2 - 1, n + 7, n2 - 1);
        graphics.drawLine(n - 1, n2 - 1, n - 1, n2 + 7);
        graphics.setColor(STATUS_UP_PART_COLOR);
        graphics.drawLine(n - 1, n2 + 7, n + 7, n2 + 7);
        graphics.drawLine(n + 7, n2 - 1, n + 7, n2 + 7);
    }

    private void drawInProgressGlobalStatus(Graphics graphics, Color color) {
        int n = 3;
        int n2 = (this.topOffset() - 7) / 2;
        busyIcon.paintIcon(this, graphics, n, n2);
        graphics.setColor(STATUS_DOWN_PART_COLOR);
        graphics.drawLine(n - 1, n2 - 1, n + 7, n2 - 1);
        graphics.drawLine(n - 1, n2 - 1, n - 1, n2 + 7);
        graphics.setColor(STATUS_UP_PART_COLOR);
        graphics.drawLine(n - 1, n2 + 7, n + 7, n2 + 7);
        graphics.drawLine(n + 7, n2 - 1, n + 7, n2 + 7);
    }

    private Color getColorForGlobalStatus(Status status) {
        if (Status.STATUS_ERROR == status) {
            return GLOBAL_RED;
        }
        if (Status.STATUS_WARNING == status) {
            return GLOBAL_YELLOW;
        }
        return GLOBAL_GREEN;
    }

    private void drawGlobalStatus(Graphics graphics) {
        UpToDateStatus upToDateStatus = this.data.computeTotalStatusType();
        if (upToDateStatus == UpToDateStatus.UP_TO_DATE_DIRTY) {
            this.drawOneColorGlobalStatus(graphics, UIManager.getColor("Panel.background"));
        } else if (upToDateStatus == UpToDateStatus.UP_TO_DATE_PROCESSING) {
            this.drawInProgressGlobalStatus(graphics, null);
        } else if (upToDateStatus == UpToDateStatus.UP_TO_DATE_OK) {
            Status status = this.data.computeTotalStatus();
            this.drawOneColorGlobalStatus(graphics, this.getColorForGlobalStatus(status));
        } else {
            throw new IllegalStateException("Unknown up-to-date type: " + upToDateStatus);
        }
    }

    private int getCurrentLine() {
        int n = this.pane.getCaretPosition();
        Document document = this.pane.getDocument();
        int n2 = -1;
        if (document instanceof StyledDocument) {
            n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)n);
        }
        return n2;
    }

    public void paintComponent(Graphics graphics) {
        long l = System.currentTimeMillis();
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(UIManager.getColor("Panel.background"));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.getCurrentLine();
        int n2 = this.data.findNextUsedLine(-1);
        while (n2 != Integer.MAX_VALUE) {
            int n3;
            int[] nArray = this.getLinesSpan(n2);
            int n4 = nArray[0];
            Mark mark = this.data.getMainMarkForBlock(n4, n3 = nArray[1]);
            if (mark != null) {
                Status status = mark.getStatus();
                double d = this.modelToView(n2);
                if (status != null) {
                    Color color2 = mark.getEnhancedColor();
                    if (color2 == null) {
                        color2 = Status.getDefaultColor(status);
                    }
                    if (!$assertionsDisabled && color2 == null) {
                        throw new AssertionError();
                    }
                    graphics.setColor(color2);
                    if (mark.getType() != 2) {
                        graphics.fillRect(1, (int)d, 11, 3);
                    }
                    if (n4 <= n && n <= n3 || mark.getType() == 2) {
                        this.drawCurrentLineMark(graphics, (int)d);
                    }
                }
            }
            n2 = this.data.findNextUsedLine(n3);
        }
        this.drawGlobalStatus(graphics);
        graphics.setColor(color);
        long l2 = System.currentTimeMillis();
        if (TIMING_ERR.isLoggable(1)) {
            TIMING_ERR.log("AnnotationView.paintComponent consumed: " + (l2 - l));
        }
    }

    private void drawCurrentLineMark(Graphics graphics, int n) {
        graphics.setColor(CaretMark.getCaretMarkColor());
        graphics.drawLine(2, n + 1, 10, n + 1);
        graphics.fillRect(5, n, 3, 3);
        graphics.draw3DRect(5, n, 2, 2, true);
    }

    void fullRepaint() {
        this.fullRepaint(false);
    }

    void fullRepaint(boolean bl) {
        this.fullRepaint(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fullRepaint(boolean bl, boolean bl2) {
        RepaintTask repaintTask = this.repaintTaskRunnable;
        synchronized (repaintTask) {
            this.repaintTaskRunnable.setClearMarksCache(bl);
            this.repaintTaskRunnable.setClearModelToViewCache(bl2);
            this.repaintTask.schedule(100);
        }
    }

    private void documentChange() {
        this.fullRepaint(this.lines != Utilities.getRowCount((BaseDocument)this.doc));
    }

    private double getComponentHeight() {
        return this.pane.getUI().getRootView(this.pane).getPreferredSpan(1);
    }

    double getUsableHeight() {
        Container container = this.pane.getParent();
        if (container != null && !(container instanceof JScrollPane)) {
            container = container.getParent();
        }
        Insets insets = UIManager.getInsets("Nb.Editor.ErrorStripe.ScrollBar.Insets");
        if (container == null || !(container instanceof JScrollPane) || insets == null) {
            return this.getHeight() - 20;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        int n = jScrollPane.getViewport().getExtentSize().height;
        int n2 = this.topOffset();
        int n3 = insets.bottom;
        return n - n2 - n3;
    }

    int topOffset() {
        Insets insets = UIManager.getInsets("Nb.Editor.ErrorStripe.ScrollBar.Insets");
        if (insets == null) {
            return 20;
        }
        return (20 > insets.top ? 20 : insets.top) + 3;
    }

    private int getYFromPos(int n) throws BadLocationException {
        int n2;
        TextUI textUI = this.pane.getUI();
        if (textUI instanceof BaseTextUI) {
            n2 = ((BaseTextUI)textUI).getYFromPos(n);
        } else {
            Rectangle rectangle = this.pane.modelToView(n);
            int n3 = n2 = rectangle != null ? rectangle.y : 0;
        }
        if (n2 == 0) {
            return -1;
        }
        return n2;
    }

    private synchronized int getModelToViewImpl(int n) throws BadLocationException {
        int n2 = Utilities.getRowCount((BaseDocument)this.doc);
        if (this.modelToViewCache == null || this.height != this.pane.getHeight() || this.lines != n2) {
            this.modelToViewCache = new int[Utilities.getRowCount((BaseDocument)this.doc) + 2];
            this.lines = Utilities.getRowCount((BaseDocument)this.doc);
            this.height = this.pane.getHeight();
        }
        if (n >= n2) {
            return -1;
        }
        int n3 = this.modelToViewCache[n + 1];
        if (n3 == 0) {
            int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.pane.getDocument()), (int)n);
            this.modelToViewCache[n + 1] = n3 = this.getYFromPos(n4);
        }
        if (n3 == -1) {
            n3 = 0;
        }
        return n3;
    }

    double modelToView(int n) {
        try {
            int n2 = this.getModelToViewImpl(n);
            if (n2 == -1) {
                return -1.0;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "AnnotationView.modelToView: line=" + n);
                ERR.log(1, "AnnotationView.modelToView: r=" + n2);
                ERR.log(1, "AnnotationView.modelToView: getComponentHeight()=" + this.getComponentHeight());
                ERR.log(1, "AnnotationView.modelToView: getUsableHeight()=" + this.getUsableHeight());
            }
            if (this.getComponentHeight() <= this.getUsableHeight()) {
                return n2 + this.topOffset();
            }
            double d = (double)n2 / this.getComponentHeight();
            int n3 = (int)(this.getUsableHeight() / 4.0);
            int n4 = (int)(d * (double)n3);
            return n4 * 4 + this.topOffset();
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return -1.0;
        }
    }

    int[] viewToModel(double d) {
        try {
            if (this.getComponentHeight() <= this.getUsableHeight()) {
                double d2;
                int n = this.pane.viewToModel(new Point(1, (int)(d - (double)this.topOffset())));
                int n2 = Utilities.getLineOffset((BaseDocument)this.doc, (int)n);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "AnnotationView.viewToModel: line=" + n2);
                }
                if (d < (d2 = this.modelToView(n2)) || d >= d2 + 3.0) {
                    return null;
                }
                return this.getLinesSpan(n2);
            }
            int n = (int)(this.getUsableHeight() / 4.0);
            int n3 = (int)((d - (double)this.topOffset()) / 4.0);
            double d3 = this.getComponentHeight() * (double)n3 / (double)n;
            if (d3 == (double)((int)d3)) {
                d3 -= 1.0;
            }
            int n4 = this.pane.viewToModel(new Point(0, (int)d3));
            int n5 = Utilities.getLineOffset((BaseDocument)this.doc, (int)n4) + 1;
            int[] nArray = this.getLinesSpan(n5);
            double d4 = this.modelToView(nArray[0]);
            if (ERR.isLoggable(1)) {
                ERR.log(1, "AnnotationView.viewToModel: offset=" + d);
                ERR.log(1, "AnnotationView.viewToModel: block=" + n3);
                ERR.log(1, "AnnotationView.viewToModel: blocksCount=" + n);
                ERR.log(1, "AnnotationView.viewToModel: pane.getHeight()=" + this.pane.getHeight());
                ERR.log(1, "AnnotationView.viewToModel: yPos=" + d3);
                ERR.log(1, "AnnotationView.viewToModel: positionOffset=" + n4);
                ERR.log(1, "AnnotationView.viewToModel: line=" + n5);
                ERR.log(1, "AnnotationView.viewToModel: normalizedOffset=" + d4);
            }
            if (d < d4 || d >= d4 + 3.0) {
                return null;
            }
            if (n3 < 0) {
                return null;
            }
            return nArray;
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return null;
        }
    }

    private Mark getMarkForPointImpl(double d) {
        int[] nArray = this.viewToModel(d);
        if (nArray == null) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (n != -1) {
            return this.data.getMainMarkForBlock(n, n2);
        }
        return null;
    }

    Mark getMarkForPoint(double d) {
        d = (int)(d / 4.0) * 4;
        Mark mark = this.getMarkForPointImpl(d);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "AnnotationView.getAnnotationForPoint: point=" + d);
            ERR.log(1, "AnnotationView.getAnnotationForPoint: a=" + mark);
        }
        int n = Math.max(5, 5);
        for (int n2 = 1; n2 < n && mark == null; n2 = (int)((short)(n2 + 1))) {
            if (n2 <= 4) {
                mark = this.getMarkForPointImpl(d + (double)n2);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "AnnotationView.getAnnotationForPoint: a=" + mark);
                    ERR.log(1, "AnnotationView.getAnnotationForPoint: relative=" + n2);
                }
            }
            if (n2 > 4 || mark != null) continue;
            mark = this.getMarkForPointImpl(d - (double)n2);
            if (!ERR.isLoggable(1)) continue;
            ERR.log(1, "AnnotationView.getAnnotationForPoint: a=" + mark);
            ERR.log(1, "AnnotationView.getAnnotationForPoint: relative=-" + n2);
        }
        return mark;
    }

    public Dimension getMaximumSize() {
        return new Dimension(13, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(13, Integer.MIN_VALUE);
    }

    public Dimension getPreferredSize() {
        return new Dimension(13, Integer.MAX_VALUE);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.resetCursor();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.resetCursor();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.checkCursor(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.resetCursor();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.checkCursor(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.resetCursor();
        Mark mark = this.getMarkForPoint(mouseEvent.getPoint().getY());
        if (mark != null) {
            this.pane.setCaretPosition(Utilities.getRowStartFromLineOffset((BaseDocument)this.doc, (int)mark.getAssignedLines()[0]));
        }
    }

    private void resetCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void checkCursor(MouseEvent mouseEvent) {
        Mark mark = this.getMarkForPoint(mouseEvent.getPoint().getY());
        if (mark == null) {
            this.resetCursor();
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        int n;
        if (ERR.isLoggable(1)) {
            ERR.log(1, "getToolTipText: event=" + mouseEvent);
        }
        if ((n = mouseEvent.getY()) <= this.topOffset()) {
            int[] nArray = this.data.computeErrorsAndWarnings();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (n2 == 0 && n3 == 0) {
                return NbBundle.getBundle((Class)AnnotationView.class).getString("TP_NoErrors");
            }
            if (n2 == 0 && n3 != 0) {
                return MessageFormat.format(NbBundle.getBundle((Class)AnnotationView.class).getString("TP_X_warning(s)"), new Integer(n3));
            }
            if (n2 != 0 && n3 == 0) {
                return MessageFormat.format(NbBundle.getBundle((Class)AnnotationView.class).getString("TP_X_error(s)"), new Integer(n2));
            }
            return MessageFormat.format(NbBundle.getBundle((Class)AnnotationView.class).getString("TP_X_error(s)_Y_warning(s)"), new Integer(n2), new Integer(n3));
        }
        Mark mark = this.getMarkForPoint(n);
        if (mark != null && (string = mark.getShortDescription()) != null) {
            return "<html><body>" + this.translate(string);
        }
        return null;
    }

    private String translate(String string) {
        for (int i = 0; i < c.length; ++i) {
            string = string.replaceAll(c[i], tags[i]);
        }
        return string;
    }

    public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
        this.fullRepaint(false, true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChange();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.pane && "document".equals(propertyChangeEvent.getPropertyName())) {
            this.updateForNewDocument();
            return;
        }
        this.fullRepaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage((Class)AnnotationView.class, (String)"ACSN_AnnotationView"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage((Class)AnnotationView.class, (String)"ACSD_AnnotationView"));
        }
        return this.accessibleContext;
    }

    static /* synthetic */ int[] access$302(AnnotationView annotationView, int[] nArray) {
        annotationView.modelToViewCache = nArray;
        return nArray;
    }

    static {
        $assertionsDisabled = !AnnotationView.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.editor.errorstripe.AnnotationView");
        TIMING_ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.editor.errorstripe.AnnotationView.timing");
        STATUS_UP_PART_COLOR = Color.WHITE;
        STATUS_DOWN_PART_COLOR = new Color(13486779);
        busyIcon = new ImageIcon(AnnotationView.class.getResource("resources/hodiny.gif"));
        GLOBAL_RED = new Color(16722460);
        GLOBAL_YELLOW = new Color(14789120);
        GLOBAL_GREEN = new Color(0x65B56B);
        c = new String[]{"&", "<", ">", "\n", "\""};
        tags = new String[]{"&amp;", "&lt;", "&gt;", "<br>", "&quot;"};
    }

    private class RepaintTask
    implements Runnable {
        private boolean clearMarksCache;
        private boolean clearModelToViewCache;

        private RepaintTask() {
        }

        public void setClearMarksCache(boolean bl) {
            this.clearMarksCache |= bl;
        }

        public void setClearModelToViewCache(boolean bl) {
            this.clearModelToViewCache |= bl;
        }

        private synchronized boolean readAndDestroyClearMarksCache() {
            boolean bl = this.clearMarksCache;
            this.clearMarksCache = false;
            return bl;
        }

        private synchronized boolean readAndDestroyClearModelToViewCache() {
            boolean bl = this.clearModelToViewCache;
            this.clearModelToViewCache = false;
            return bl;
        }

        public void run() {
            final boolean bl = this.readAndDestroyClearMarksCache();
            final boolean bl2 = this.readAndDestroyClearModelToViewCache();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AnnotationView annotationView = AnnotationView.this;
                    synchronized (annotationView) {
                        if (bl) {
                            AnnotationView.this.data.clear();
                        }
                        if (bl2) {
                            AnnotationView.access$302(AnnotationView.this, null);
                        }
                    }
                    AnnotationView.this.invalidate();
                    AnnotationView.this.repaint();
                }
            });
        }
    }
}

