/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.errorstripe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.errorstripe.AnnotationMark;
import org.netbeans.modules.editor.errorstripe.AnnotationView;
import org.netbeans.modules.editor.errorstripe.AnnotationViewData;
import org.netbeans.modules.editor.errorstripe.apimodule.SPIAccessor;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProviderCreator;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

final class AnnotationViewDataImpl
implements PropertyChangeListener,
AnnotationViewData,
Annotations.AnnotationsListener {
    private static final ErrorManager ERR = AnnotationView.ERR;
    private AnnotationView view;
    private JTextComponent pane;
    private BaseDocument document;
    private List providers = new ArrayList();
    private List upToDateStatusProviders = new ArrayList();
    private List currentMarks = null;
    private SortedMap marksMap = null;

    public AnnotationViewDataImpl(AnnotationView annotationView, JTextComponent jTextComponent) {
        this.view = annotationView;
        this.pane = jTextComponent;
        this.document = null;
    }

    public void register(BaseDocument baseDocument) {
        this.document = baseDocument;
        this.gatherProviders(this.pane);
        this.addListenersToProviders();
        if (baseDocument != null) {
            baseDocument.getAnnotations().addAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.currentMarks = null;
        this.marksMap = null;
    }

    public void unregister() {
        if (this.document != null) {
            this.document.getAnnotations().removeAnnotationsListener((Annotations.AnnotationsListener)this);
        }
        this.removeListenersFromProviders();
        this.document = null;
    }

    private void gatherProviders(JTextComponent jTextComponent) {
        long l = System.currentTimeMillis();
        try {
            Object object;
            Object object2;
            Lookup lookup;
            DataObject dataObject;
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            if (baseKit == null) {
                return;
            }
            String string = baseKit.getContentType();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/text/base/UpToDateStatusProvider");
            FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string + "/UpToDateStatusProvider");
            if (ERR.isLoggable(1)) {
                ERR.log(1, "baseFolder = " + fileObject);
            }
            DataObject dataObject2 = dataObject = fileObject != null ? DataObject.find((FileObject)fileObject) : null;
            if (ERR.isLoggable(1)) {
                ERR.log(1, "baseDO = " + dataObject);
            }
            Lookup lookup2 = lookup = fileObject != null ? new FolderLookup((DataObject.Container)((DataFolder)dataObject)).getLookup() : Lookup.EMPTY;
            if (ERR.isLoggable(1)) {
                ERR.log(1, "contentFolder = " + fileObject2);
            }
            DataObject dataObject3 = fileObject2 != null ? DataObject.find((FileObject)fileObject2) : null;
            Lookup lookup3 = fileObject2 != null ? new FolderLookup((DataObject.Container)((DataFolder)dataObject3)).getLookup() : Lookup.EMPTY;
            ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{lookup, lookup3});
            Lookup.Result result = proxyLookup.lookup(new Lookup.Template(MarkProviderCreator.class));
            ArrayList<MarkProvider> arrayList = new ArrayList<MarkProvider>();
            Lookup.Result result2 = result.allInstances().iterator();
            while (result2.hasNext()) {
                object2 = (MarkProviderCreator)result2.next();
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "creator = " + object2);
                }
                if ((object = object2.createMarkProvider(jTextComponent)) == null) continue;
                arrayList.add((MarkProvider)object);
            }
            this.providers = arrayList;
            result2 = proxyLookup.lookup(new Lookup.Template(UpToDateStatusProviderFactory.class));
            object2 = new ArrayList();
            object = result2.allInstances().iterator();
            while (object.hasNext()) {
                UpToDateStatusProvider upToDateStatusProvider;
                UpToDateStatusProviderFactory upToDateStatusProviderFactory = (UpToDateStatusProviderFactory)object.next();
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "creator = " + upToDateStatusProviderFactory);
                }
                if ((upToDateStatusProvider = upToDateStatusProviderFactory.createUpToDateStatusProvider(jTextComponent.getDocument())) == null) continue;
                object2.add(upToDateStatusProvider);
            }
            this.upToDateStatusProviders = object2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        long l2 = System.currentTimeMillis();
        if (AnnotationView.TIMING_ERR.isLoggable(1)) {
            AnnotationView.TIMING_ERR.log(1, "gather providers took: " + (l2 - l));
        }
    }

    private void addListenersToProviders() {
        Object object;
        Iterator iterator = this.upToDateStatusProviders.iterator();
        while (iterator.hasNext()) {
            object = (UpToDateStatusProvider)iterator.next();
            SPIAccessor.getDefault().addPropertyChangeListener((UpToDateStatusProvider)object, (PropertyChangeListener)this);
        }
        iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            object = (MarkProvider)iterator.next();
            ((MarkProvider)object).addPropertyChangeListener(this);
        }
    }

    private void removeListenersFromProviders() {
        Object object;
        Iterator iterator = this.upToDateStatusProviders.iterator();
        while (iterator.hasNext()) {
            object = (UpToDateStatusProvider)iterator.next();
            SPIAccessor.getDefault().removePropertyChangeListener((UpToDateStatusProvider)object, (PropertyChangeListener)this);
        }
        iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            object = (MarkProvider)iterator.next();
            ((MarkProvider)object).removePropertyChangeListener(this);
        }
    }

    static List createMergedMarks(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MarkProvider markProvider = (MarkProvider)iterator.next();
            arrayList.addAll(markProvider.getMarks());
        }
        return arrayList;
    }

    synchronized List getMergedMarks() {
        if (this.currentMarks == null) {
            this.currentMarks = AnnotationViewDataImpl.createMergedMarks(this.providers);
        }
        return this.currentMarks;
    }

    static List getStatusesForLineImpl(int n, SortedMap sortedMap) {
        List list = (List)sortedMap.get(new Integer(n));
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public Mark getMainMarkForBlock(int n, int n2) {
        Mark mark = AnnotationViewDataImpl.getMainMarkForBlockImpl(n, n2, this.getMarkMap());
        Mark mark2 = this.getMainMarkForBlockAnnotations(n, n2);
        if (mark == null) {
            return mark2;
        }
        if (mark2 == null) {
            return mark;
        }
        if (AnnotationViewDataImpl.isMoreImportant(mark, mark2)) {
            return mark;
        }
        return mark2;
    }

    static Mark getMainMarkForBlockImpl(int n, int n2, SortedMap sortedMap) {
        int n3 = n - 1;
        Mark mark = null;
        while ((n3 = AnnotationViewDataImpl.findNextUsedLine(n3, sortedMap)) != Integer.MAX_VALUE && n3 <= n2) {
            Iterator iterator = AnnotationViewDataImpl.getStatusesForLineImpl(n3, sortedMap).iterator();
            while (iterator.hasNext()) {
                Mark mark2 = (Mark)iterator.next();
                if (mark != null && !AnnotationViewDataImpl.isMoreImportant(mark2, mark)) continue;
                mark = mark2;
            }
        }
        return mark;
    }

    private static boolean isMoreImportant(Mark mark, Mark mark2) {
        int n = mark.getStatus().compareTo(mark2.getStatus());
        if (n == 0) {
            return mark.getPriority() < mark2.getPriority();
        }
        return n > 0;
    }

    private boolean isMoreImportant(AnnotationDesc annotationDesc, AnnotationDesc annotationDesc2) {
        AnnotationType annotationType = annotationDesc.getAnnotationTypeInstance();
        AnnotationType annotationType2 = annotationDesc2.getAnnotationTypeInstance();
        int n = annotationType.getSeverity().compareTo((Object)annotationType2.getSeverity());
        if (n == 0) {
            return annotationType.getPriority() < annotationType2.getPriority();
        }
        return n > 0;
    }

    private boolean isValidForErrorStripe(AnnotationDesc annotationDesc) {
        return annotationDesc.getAnnotationTypeInstance().getSeverity() != AnnotationType.Severity.STATUS_NONE;
    }

    private Mark getMainMarkForBlockAnnotations(int n, int n2) {
        int n3 = n;
        AnnotationDesc annotationDesc = null;
        Annotations annotations = this.document.getAnnotations();
        while ((n3 = annotations.getNextLineWithAnnotation(n3)) <= n2 && n3 != -1) {
            AnnotationDesc annotationDesc2 = annotations.getActiveAnnotation(n3);
            if (annotationDesc2 != null && (annotationDesc == null || this.isMoreImportant(annotationDesc2, annotationDesc)) && this.isValidForErrorStripe(annotationDesc2)) {
                annotationDesc = annotationDesc2;
            }
            if (annotations.getNumberOfAnnotations(n3) > 1) {
                AnnotationDesc[] annotationDescArray = annotations.getPasiveAnnotations(n3);
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    if (annotationDesc != null && !this.isMoreImportant(annotationDescArray[i], annotationDesc) || !this.isValidForErrorStripe(annotationDescArray[i])) continue;
                    annotationDesc = annotationDescArray[i];
                }
            }
            ++n3;
        }
        if (annotationDesc != null) {
            return new AnnotationMark(annotationDesc);
        }
        return null;
    }

    public int findNextUsedLine(int n) {
        int n2 = AnnotationViewDataImpl.findNextUsedLine(n, this.getMarkMap());
        int n3 = this.document.getAnnotations().getNextLineWithAnnotation(n + 1);
        if (n3 == -1) {
            n3 = Integer.MAX_VALUE;
        }
        return n2 < n3 ? n2 : n3;
    }

    static int findNextUsedLine(int n, SortedMap sortedMap) {
        SortedMap sortedMap2 = sortedMap.tailMap(new Integer(n + 1));
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.findNextUsedLine from: " + n);
            ERR.log("AnnotationView.findNextUsedLine marks: " + sortedMap);
            ERR.log("AnnotationView.findNextUsedLine next: " + sortedMap2);
        }
        if (sortedMap2.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        Integer n2 = sortedMap2.firstKey();
        return n2;
    }

    private void registerMark(Mark mark) {
        int[] nArray = mark.getAssignedLines();
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.registerMark mark: " + mark);
            ERR.log("AnnotationView.registerMark lines from-to: " + nArray[0] + "-" + nArray[1]);
        }
        for (int i = nArray[0]; i <= nArray[1]; ++i) {
            Integer n = new Integer(i);
            ArrayList<Mark> arrayList = (ArrayList<Mark>)this.marksMap.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<Mark>();
                this.marksMap.put(n, arrayList);
            }
            arrayList.add(mark);
        }
    }

    private void unregisterMark(Mark mark) {
        int[] nArray = mark.getAssignedLines();
        if (ERR.isLoggable(1)) {
            ERR.log("AnnotationView.unregisterMark mark: " + mark);
            ERR.log("AnnotationView.unregisterMark lines from-to: " + nArray[0] + "-" + nArray[1]);
        }
        for (int i = nArray[0]; i <= nArray[1]; ++i) {
            Integer n = new Integer(i);
            List list = (List)this.marksMap.get(n);
            if (list == null) continue;
            list.remove(mark);
            if (list.size() != 0) continue;
            this.marksMap.remove(n);
        }
    }

    synchronized SortedMap getMarkMap() {
        if (this.marksMap == null) {
            List list = this.getMergedMarks();
            this.marksMap = new TreeMap();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Mark mark = (Mark)iterator.next();
                this.registerMark(mark);
            }
        }
        return this.marksMap;
    }

    public Status computeTotalStatus() {
        Status status;
        Status status2 = Status.STATUS_OK;
        List list = this.getMergedMarks();
        Annotations annotations = list.iterator();
        while (annotations.hasNext()) {
            Mark mark = (Mark)annotations.next();
            status = mark.getStatus();
            status2 = Status.getCompoundStatus(status, status2);
        }
        annotations = this.document.getAnnotations();
        int n = -1;
        while ((n = annotations.getNextLineWithAnnotation(n)) != -1) {
            AnnotationDesc[] annotationDescArray;
            status = annotations.getActiveAnnotation(n);
            if (status != null && (annotationDescArray = AnnotationViewDataImpl.get(status.getAnnotationTypeInstance())) != null) {
                status2 = Status.getCompoundStatus((Status)annotationDescArray, status2);
            }
            if (annotations.getNumberOfAnnotations(n) > 1) {
                annotationDescArray = annotations.getPasiveAnnotations(n);
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    Status status3 = AnnotationViewDataImpl.get(annotationDescArray[i].getAnnotationTypeInstance());
                    if (status3 == null) continue;
                    status2 = Status.getCompoundStatus(status3, status2);
                }
            }
            ++n;
        }
        return status2;
    }

    public UpToDateStatus computeTotalStatusType() {
        if (this.upToDateStatusProviders.isEmpty()) {
            return UpToDateStatus.UP_TO_DATE_DIRTY;
        }
        UpToDateStatus upToDateStatus = UpToDateStatus.UP_TO_DATE_OK;
        Iterator iterator = this.upToDateStatusProviders.iterator();
        while (iterator.hasNext()) {
            UpToDateStatusProvider upToDateStatusProvider = (UpToDateStatusProvider)iterator.next();
            UpToDateStatus upToDateStatus2 = upToDateStatusProvider.getUpToDate();
            if (upToDateStatus2.compareTo((Object)upToDateStatus) <= 0) continue;
            upToDateStatus = upToDateStatus2;
        }
        return upToDateStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("marks".equals(propertyChangeEvent.getPropertyName())) {
            AnnotationViewDataImpl annotationViewDataImpl = this;
            synchronized (annotationViewDataImpl) {
                Collection collection = (Collection)propertyChangeEvent.getNewValue();
                Collection collection2 = (Collection)propertyChangeEvent.getOldValue();
                if (collection == null && propertyChangeEvent.getSource() instanceof MarkProvider) {
                    collection = ((MarkProvider)propertyChangeEvent.getSource()).getMarks();
                }
                if (collection2 != null && collection != null) {
                    ArrayList arrayList = new ArrayList(collection);
                    ArrayList arrayList2 = new ArrayList(collection2);
                    arrayList.removeAll(collection2);
                    arrayList2.removeAll(collection);
                    if (this.marksMap != null) {
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            this.unregisterMark((Mark)iterator.next());
                        }
                        iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            this.registerMark((Mark)iterator.next());
                        }
                    }
                    if (this.currentMarks != null) {
                        this.currentMarks.removeAll(arrayList2);
                        this.currentMarks.addAll(arrayList);
                    }
                    this.view.fullRepaint();
                } else {
                    ErrorManager.getDefault().log(16, "For performance reasons, the providers should fill both old and new value in property changes. Problematic event: " + propertyChangeEvent);
                    this.clear();
                    this.view.fullRepaint();
                }
                return;
            }
        }
        if ("upToDate".equals(propertyChangeEvent.getPropertyName())) {
            this.view.fullRepaint(false);
            return;
        }
    }

    public void clear() {
        this.currentMarks = null;
        this.marksMap = null;
    }

    public int[] computeErrorsAndWarnings() {
        Status status;
        int n = 0;
        int n2 = 0;
        List list = this.getMergedMarks();
        Annotations annotations = list.iterator();
        while (annotations.hasNext()) {
            Mark mark = (Mark)annotations.next();
            status = mark.getStatus();
            n += status == Status.STATUS_ERROR ? 1 : 0;
            n2 += status == Status.STATUS_WARNING ? 1 : 0;
        }
        annotations = this.document.getAnnotations();
        int n3 = -1;
        while ((n3 = annotations.getNextLineWithAnnotation(n3)) != -1) {
            AnnotationDesc[] annotationDescArray;
            status = annotations.getActiveAnnotation(n3);
            if (status != null && (annotationDescArray = AnnotationViewDataImpl.get(status.getAnnotationTypeInstance())) != null) {
                n += annotationDescArray == Status.STATUS_ERROR ? 1 : 0;
                n2 += annotationDescArray == Status.STATUS_WARNING ? 1 : 0;
            }
            if (annotations.getNumberOfAnnotations(n3) > 1) {
                annotationDescArray = annotations.getPasiveAnnotations(n3);
                for (int i = 0; i < annotationDescArray.length; ++i) {
                    Status status2 = AnnotationViewDataImpl.get(annotationDescArray[i].getAnnotationTypeInstance());
                    if (status2 == null) continue;
                    n += status2 == Status.STATUS_ERROR ? 1 : 0;
                    n2 += status2 == Status.STATUS_WARNING ? 1 : 0;
                }
            }
            ++n3;
        }
        return new int[]{n, n2};
    }

    public void changedLine(int n) {
        this.changedAll();
    }

    public void changedAll() {
        this.view.fullRepaint(false);
    }

    static Status get(AnnotationType.Severity severity) {
        if (severity == AnnotationType.Severity.STATUS_ERROR) {
            return Status.STATUS_ERROR;
        }
        if (severity == AnnotationType.Severity.STATUS_WARNING) {
            return Status.STATUS_WARNING;
        }
        if (severity == AnnotationType.Severity.STATUS_OK) {
            return Status.STATUS_OK;
        }
        return null;
    }

    static Status get(AnnotationType annotationType) {
        return AnnotationViewDataImpl.get(annotationType.getSeverity());
    }
}

