/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure;

import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public class DocumentModelProviderFactory {
    static final String FOLDER_NAME = "DocumentModel";
    private Map<String, DocumentModelProvider> mime2provider = new WeakHashMap<String, DocumentModelProvider>();
    private static DocumentModelProviderFactory defaultProvider = null;

    public static DocumentModelProviderFactory getDefault() {
        if (defaultProvider == null) {
            defaultProvider = new DocumentModelProviderFactory();
        }
        return defaultProvider;
    }

    private DocumentModelProviderFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentModelProvider getDocumentModelProvider(String string) {
        DocumentModelProvider documentModelProvider = null;
        if (string != null) {
            documentModelProvider = this.mime2provider.get(string);
            if (documentModelProvider != null) return documentModelProvider;
            MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)string);
            Collection collection = mimeLookup.lookup(new Lookup.Template(DocumentModelProvider.class)).allInstances();
            if (collection.size() > 1) {
                ErrorManager.getDefault().log(1, "Only one DocumentModelProvider can be registered for one mimetype!");
            }
            if (collection.size() == 0) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("There isn't any DocumentModelProvider registered for " + string + " mimetype!"));
            }
            documentModelProvider = collection.size() > 0 ? (DocumentModelProvider)collection.iterator().next() : null;
            this.mime2provider.put(string, documentModelProvider);
            return documentModelProvider;
        } else {
            ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("mimeType cannot be null!"));
        }
        return documentModelProvider;
    }
}

