/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.editor.structure.api.DocumentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentElement {
    private String name;
    private String type;
    private Position startPos;
    private Position endPos;
    private int startSectionLength;
    private int endSectionLength;
    private DocumentModel model;
    private Attributes attributes;
    private int elementEmpty;
    private boolean isRootElement;
    private static final int ELEMENT_EMPTY_UNSET = 0;
    private static final int ELEMENT_EMPTY_TRUE = 1;
    private static final int ELEMENT_EMPTY_FALSE = 2;
    private HashSet<DocumentElementListener> deListeners = new HashSet();
    private final int PRINT_MAX_CHARS = 10;

    DocumentElement(String string, String string2, Map map, int n, int n2, DocumentModel documentModel) throws BadLocationException {
        this.name = string;
        this.model = documentModel;
        this.startSectionLength = this.startSectionLength;
        this.endSectionLength = this.endSectionLength;
        this.type = string2;
        this.attributes = new Attributes(this, map);
        this.elementEmpty = 0;
        this.isRootElement = false;
        this.setStartPosition(n);
        this.setEndPosition(n2);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Document getDocument() {
        return this.model.getDocument();
    }

    public DocumentElement getElement(int n) {
        return this.getChildren().get(n);
    }

    public int getElementCount() {
        return this.getChildren().size();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    public int getElementIndex(int n) {
        Iterator<DocumentElement> iterator = this.getChildren().iterator();
        int n2 = Integer.MAX_VALUE;
        DocumentElement documentElement = null;
        while (iterator.hasNext()) {
            int n3;
            DocumentElement documentElement2 = iterator.next();
            if (documentElement2.getStartOffset() <= n && documentElement2.getEndOffset() > n) {
                documentElement = documentElement2;
                break;
            }
            int n4 = Math.abs(documentElement2.getStartOffset() - n);
            int n5 = Math.min(n4, n3 = Math.abs(documentElement2.getEndOffset() - n));
            if (n2 <= n5) continue;
            documentElement = documentElement2;
            n2 = n5;
        }
        if (documentElement == null) {
            return -1;
        }
        return this.getChildren().indexOf(documentElement);
    }

    public String getName() {
        return this.name;
    }

    public DocumentElement getParentElement() {
        return this.model.getParent(this);
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    void setAttributes(Map map) {
        this.attributes = new Attributes(this, map);
    }

    void setElementIsEmptyState(boolean bl) {
        this.elementEmpty = bl ? 1 : 2;
    }

    boolean isEmpty() {
        if (this.elementEmpty == 0) {
            this.elementEmpty = DocumentModel.isEmpty(this) ? 1 : 2;
        }
        return this.elementEmpty == 1;
    }

    public DocumentModel getDocumentModel() {
        return this.model;
    }

    public String getType() {
        return this.type;
    }

    public List<DocumentElement> getChildren() {
        return this.model.getChildren(this);
    }

    public void addDocumentElementListener(DocumentElementListener documentElementListener) {
        this.deListeners.add(documentElementListener);
    }

    public void removeDocumentElementListener(DocumentElementListener documentElementListener) {
        this.deListeners.remove(documentElementListener);
    }

    synchronized void setRootElement(boolean bl) {
        this.isRootElement = bl;
    }

    boolean isRootElement() {
        return this.isRootElement;
    }

    void setStartPosition(int n) throws BadLocationException {
        this.startPos = this.model.getDocument().createPosition(n);
    }

    void setEndPosition(int n) throws BadLocationException {
        this.endPos = this.model.getDocument().createPosition(n);
    }

    String getContent() throws BadLocationException {
        return this.model.getDocument().getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
    }

    private void fireDocumentElementEvent(DocumentElementEvent documentElementEvent) {
        for (DocumentElementListener documentElementListener : this.deListeners) {
            switch (documentElementEvent.getType()) {
                case 2: {
                    documentElementListener.elementAdded(documentElementEvent);
                    break;
                }
                case 3: {
                    documentElementListener.elementRemoved(documentElementEvent);
                    break;
                }
                case 1: {
                    documentElementListener.contentChanged(documentElementEvent);
                    break;
                }
                case 5: {
                    documentElementListener.attributesChanged(documentElementEvent);
                }
            }
        }
    }

    void childAdded(DocumentElement documentElement) {
        this.fireDocumentElementEvent(new DocumentElementEvent(2, this, documentElement));
    }

    void childRemoved(DocumentElement documentElement) {
        this.fireDocumentElementEvent(new DocumentElementEvent(3, this, documentElement));
    }

    void contentChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(1, this, null));
    }

    void attributesChanged() {
        this.fireDocumentElementEvent(new DocumentElementEvent(5, this, null));
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocumentElement)) {
            return false;
        }
        DocumentElement documentElement = (DocumentElement)object;
        return documentElement.getName().equals(this.getName()) && documentElement.getType().equals(this.getType()) && documentElement.getStartOffset() == this.getStartOffset() && documentElement.getEndOffset() == this.getEndOffset();
    }

    public String toString() {
        String string = "";
        try {
            string = this.getContent().trim().length() > 10 ? this.getContent().trim().substring(0, 10) + "..." : this.getContent().trim();
        }
        catch (BadLocationException badLocationException) {
            string = "error:" + badLocationException.getMessage();
        }
        return "DE (" + this.hashCode() + ")[\"" + this.getName() + "\" (" + this.getType() + ") <" + this.getStartOffset() + "-" + this.getEndOffset() + "> '" + this.encodeNewLines(string) + "']";
    }

    private String encodeNewLines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Attributes
    implements AttributeSet {
        private Map attrs;
        private DocumentElement de;

        Attributes(DocumentElement documentElement, Map map) {
            this.de = documentElement;
            this.attrs = map;
        }

        @Override
        public int getAttributeCount() {
            return this.attrs.size();
        }

        @Override
        public boolean isDefined(Object object) {
            return this.attrs.containsKey(object);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            if (this.getAttributeCount() != attributeSet.getAttributeCount()) {
                return false;
            }
            return this.containsAttributes(attributeSet);
        }

        @Override
        public AttributeSet copyAttributes() {
            HashMap hashMap = new HashMap(this.getAttributeCount());
            hashMap.putAll(this.attrs);
            return new Attributes(this.de, hashMap);
        }

        @Override
        public Object getAttribute(Object object) {
            return this.attrs.get(object);
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return Collections.enumeration(this.attrs.keySet());
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object obj = enumeration.nextElement();
                if (this.containsAttribute(obj, object = attributeSet.getAttribute(obj))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Enumeration<?> enumeration = this.getAttributeNames();
            StringBuffer stringBuffer = new StringBuffer();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = this.getAttribute(obj);
                stringBuffer.append(obj);
                stringBuffer.append('=');
                stringBuffer.append(object);
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.de.getParentElement() != null ? this.de.getParentElement().getAttributes() : null;
        }

        public int compareTo(AttributeSet attributeSet) {
            return this.toString().compareTo(attributeSet.toString());
        }
    }
}

