/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.structure.DocumentModelProviderFactory;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentModel {
    private static int MODEL_UPDATE_TIMEOUT = 500;
    private BaseDocument doc;
    private DocumentModelProvider provider;
    private DocumentChangesWatcher changesWatcher;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private TreeSet<DocumentElement> elements = new TreeSet<DocumentElement>(ELEMENTS_COMPARATOR);
    private DocumentElement rootElement;
    private DocumentModelModificationTransaction modelUpdateTransaction = null;
    boolean documentDirty = true;
    private Hashtable<DocumentElement, List<DocumentElement>> childrenCache = null;
    private Hashtable<DocumentElement, DocumentElement> parentsCache = null;
    private int numReaders = 0;
    private int numWriters = 0;
    private Thread currWriter = null;
    private Thread currReader = null;
    private HashSet<DocumentModelListener> dmListeners = new HashSet();
    private static final int ELEMENT_ADDED = 1;
    private static final int ELEMENT_REMOVED = 2;
    private static final int ELEMENT_CHANGED = 3;
    private static final int ELEMENT_ATTRS_CHANGED = 4;
    private static Map<Document, Object> locks = new WeakHashMap<Document, Object>();
    private static final Comparator<DocumentElement> ELEMENTS_COMPARATOR = new Comparator<DocumentElement>(){

        @Override
        public int compare(DocumentElement documentElement, DocumentElement documentElement2) {
            if (documentElement.isRootElement() && !documentElement2.isRootElement()) {
                return -1;
            }
            if (!documentElement.isRootElement() && documentElement2.isRootElement()) {
                return 1;
            }
            if (documentElement2.isRootElement() && documentElement.isRootElement()) {
                return 0;
            }
            int n = documentElement.getStartOffset() - documentElement2.getStartOffset();
            if (n != 0) {
                return n;
            }
            int n2 = documentElement2.getEndOffset() - documentElement.getEndOffset();
            if (n2 != 0) {
                return documentElement.isEmpty() || documentElement2.isEmpty() ? -n2 : n2;
            }
            int n3 = documentElement.getType().compareTo(documentElement2.getType());
            if (n3 != 0) {
                return n3;
            }
            int n4 = documentElement.getName().compareTo(documentElement2.getName());
            if (n4 != 0) {
                return n4;
            }
            int n5 = ((DocumentElement.Attributes)documentElement.getAttributes()).compareTo(documentElement2.getAttributes());
            if (n5 != 0) {
                return n5;
            }
            return documentElement.isEmpty() ? documentElement2.hashCode() - documentElement.hashCode() : 0;
        }

        @Override
        public boolean equals(Object object) {
            return object.equals(ELEMENTS_COMPARATOR);
        }
    };
    private static final String DOCUMENT_ROOT_ELEMENT_TYPE = "ROOT_ELEMENT";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.editor.model.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.editor.model.measure");
    private static final String GENERATING_MODEL_PROPERTY = "generating_document_model";

    DocumentModel(Document document, DocumentModelProvider documentModelProvider) throws DocumentModelException {
        this.doc = (BaseDocument)document;
        this.provider = documentModelProvider;
        this.childrenCache = new Hashtable();
        this.parentsCache = new Hashtable();
        this.requestProcessor = new RequestProcessor(DocumentModel.class.getName());
        this.task = null;
        this.addRootElement();
        this.initDocumentModel();
        this.changesWatcher = new DocumentChangesWatcher();
        this.getDocument().addDocumentListener(WeakListeners.document((DocumentListener)this.changesWatcher, (Object)document));
    }

    public static DocumentModel getDocumentModel(Document document) throws DocumentModelException {
        Object object = DocumentModel.getLock(document);
        synchronized (object) {
            DocumentModel documentModel;
            if (!(document instanceof BaseDocument)) {
                throw new ClassCastException("Currently it is necessary to pass org.netbeans.editor.BaseDocument instance into the DocumentModel.getDocumentProvider(j.s.t.Document) method.");
            }
            WeakReference weakReference = (WeakReference)document.getProperty(DocumentModel.class);
            DocumentModel documentModel2 = documentModel = weakReference == null ? null : (DocumentModel)weakReference.get();
            if (documentModel != null) {
                return documentModel;
            }
            Class clazz = ((BaseDocument)document).getKitClass();
            BaseKit baseKit = BaseKit.getKit((Class)clazz);
            if (baseKit != null) {
                String string = baseKit.getContentType();
                DocumentModelProvider documentModelProvider = DocumentModelProviderFactory.getDefault().getDocumentModelProvider(string);
                if (documentModelProvider != null) {
                    DocumentModel documentModel3 = new DocumentModel(document, documentModelProvider);
                    document.putProperty(DocumentModel.class, new WeakReference<DocumentModel>(documentModel3));
                    return documentModel3;
                }
                return null;
            }
            throw new IllegalStateException("No editor kit for document " + document + "!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(Document document) {
        Map<Document, Object> map = locks;
        synchronized (map) {
            Object object = locks.get(document);
            if (object == null) {
                object = new Object();
                locks.put(document, object);
            }
            return object;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentElement getRootElement() {
        return this.rootElement;
    }

    public void addDocumentModelListener(DocumentModelListener documentModelListener) {
        this.dmListeners.add(documentModelListener);
    }

    public void removeDocumentModelListener(DocumentModelListener documentModelListener) {
        this.dmListeners.remove(documentModelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescendantOf(DocumentElement documentElement, DocumentElement documentElement2) {
        this.readLock();
        try {
            if (documentElement == documentElement2) {
                if (debug) {
                    System.out.println("ERROR in " + documentElement);
                }
                this.debugElements();
                throw new IllegalArgumentException("ancestor == descendant!!!");
            }
            if (documentElement == this.getRootElement()) {
                boolean bl = true;
                return bl;
            }
            int n = documentElement.getStartOffset();
            int n2 = documentElement2.getStartOffset();
            int n3 = documentElement.getEndOffset();
            int n4 = documentElement2.getEndOffset();
            if (!documentElement2.isEmpty() && (n == n2 && n3 > n4 || n3 == n4 && n < n2)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = n < n2 && n3 > n4;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentElement getLeafElementForOffset(int n) {
        this.readLock();
        try {
            DocumentElement documentElement;
            if (this.getDocument().getLength() == 0) {
                DocumentElement documentElement2 = this.getRootElement();
                return documentElement2;
            }
            Iterator<DocumentElement> iterator = this.getElementsSet().iterator();
            DocumentElement documentElement3 = null;
            while (iterator.hasNext() && (documentElement = iterator.next()).getStartOffset() <= n) {
                if (documentElement.getEndOffset() < n) continue;
                if (documentElement.getStartOffset() == documentElement.getEndOffset() && documentElement.getStartOffset() == n) break;
                documentElement3 = documentElement;
            }
            if (documentElement3 == null) {
                documentElement3 = this.getRootElement();
            }
            documentElement = documentElement3;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    static void setModelUpdateTimout(int n) {
        MODEL_UPDATE_TIMEOUT = n;
    }

    private synchronized TreeSet<DocumentElement> getElementsSet() {
        if (this.documentDirty) {
            this.resortAndMarkEmptyElements();
        }
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getDocumentElement(int n, int n2) throws BadLocationException {
        this.readLock();
        try {
            DocumentElement documentElement2;
            for (DocumentElement documentElement2 : this.getElementsSet()) {
                if (documentElement2.getStartOffset() == n && documentElement2.getEndOffset() == n2) {
                    DocumentElement documentElement3 = documentElement2;
                    return documentElement3;
                }
                if (documentElement2.getStartOffset() <= n) continue;
                break;
            }
            documentElement2 = null;
            return documentElement2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getDocumentElements(int n) throws BadLocationException {
        this.readLock();
        try {
            ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
            for (DocumentElement object2 : this.getElementsSet()) {
                if (object2.getStartOffset() == n) {
                    arrayList.add(object2);
                }
                if (object2.getStartOffset() <= n) continue;
                break;
            }
            ArrayList<DocumentElement> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentModelModificationTransaction createTransaction(boolean bl) {
        return new DocumentModelModificationTransaction(bl);
    }

    private void initDocumentModel() throws DocumentModelException {
        block2: {
            try {
                DocumentModelModificationTransaction documentModelModificationTransaction = this.createTransaction(true);
                this.provider.updateModel(documentModelModificationTransaction, this, new DocumentChange[]{new DocumentChange(this.getDocument().getStartPosition(), this.getDocument().getLength(), 0)});
                documentModelModificationTransaction.commit();
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    private void requestModelUpdate() {
        if (this.modelUpdateTransaction != null) {
            this.modelUpdateTransaction.setTransactionCancelled();
        }
        if (this.requestProcessor == null) {
            return;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        Runnable runnable = new Runnable(){

            public void run() {
                DocumentModel.this.updateModel();
            }
        };
        this.task = this.requestProcessor.post(runnable, MODEL_UPDATE_TIMEOUT);
    }

    private void updateModel() {
        block8: {
            this.modelUpdateTransaction = this.createTransaction(false);
            DocumentChange[] documentChangeArray = this.changesWatcher.getDocumentChanges();
            if (debug) {
                this.debugElements();
            }
            try {
                this.provider.updateModel(this.modelUpdateTransaction, this, documentChangeArray);
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DocumentModel.this.writeLock();
                                DocumentModel.this.modelUpdateTransaction.commit();
                                DocumentModel.this.changesWatcher.clearChanges();
                                DocumentModel.this.modelUpdateTransaction = null;
                            }
                            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify(4096, (Throwable)exception);
                            }
                            finally {
                                DocumentModel.this.writeUnlock();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (DocumentModelException documentModelException) {
                if (debug) {
                    System.err.println("[DocumentModelUpdate] " + documentModelException.getMessage());
                }
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if (!debug) break block8;
                System.out.println("[document model] update transaction cancelled.");
            }
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortAndMarkEmptyElements() {
        this.writeLock();
        try {
            this.doc.readLock();
            try {
                ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>(this.elements);
                this.elements.clear();
                for (DocumentElement documentElement : arrayList) {
                    if (DocumentModel.isEmpty(documentElement)) {
                        documentElement.setElementIsEmptyState(true);
                    }
                    this.elements.add(documentElement);
                }
            }
            finally {
                this.doc.readUnlock();
            }
        }
        finally {
            this.writeUnlock();
        }
        this.documentDirty = false;
        this.clearChildrenCache();
        this.clearParentsCache();
    }

    private void addRootElement() {
        block3: {
            try {
                DocumentModelModificationTransaction documentModelModificationTransaction = this.createTransaction(false);
                this.rootElement = documentModelModificationTransaction.addDocumentElement("root", DOCUMENT_ROOT_ELEMENT_TYPE, Collections.EMPTY_MAP, 0, this.getDocument().getLength());
                this.rootElement.setRootElement(true);
                documentModelModificationTransaction.commit();
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException("Adding of root document element failed - strange!");
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getChildren(DocumentElement documentElement) {
        SequencedCollection<Object> sequencedCollection;
        List<DocumentElement> list = this.getCachedChildren(documentElement);
        if (list != null) {
            return list;
        }
        this.readLock();
        try {
            Object object;
            if (!this.getElementsSet().contains(documentElement)) {
                if (debug) {
                    System.out.println("Warning: DocumentModel.getChildren(...) called for " + documentElement + " which has already been removed!");
                }
                List<DocumentElement> list2 = Collections.emptyList();
                return list2;
            }
            if (!documentElement.isRootElement() && documentElement.isEmpty()) {
                List<DocumentElement> list3 = Collections.emptyList();
                return list3;
            }
            if (documentElement.isRootElement() && documentElement.isEmpty()) {
                ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>((Collection)this.getElementsSet().clone());
                arrayList.remove(documentElement);
                ArrayList<DocumentElement> arrayList2 = arrayList;
                return arrayList2;
            }
            ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
            sequencedCollection = this.getElementsSet().tailSet(documentElement);
            Iterator iterator = sequencedCollection.iterator();
            iterator.next();
            if (iterator.hasNext()) {
                DocumentElement documentElement2;
                object = (DocumentElement)iterator.next();
                arrayList.add((DocumentElement)object);
                if (!this.isDescendantOf(documentElement, (DocumentElement)object)) {
                    List<DocumentElement> list4 = this.cacheChildrenList(documentElement, Collections.<DocumentElement>emptyList());
                    return list4;
                }
                Object object2 = object;
                while (iterator.hasNext() && (documentElement2 = (DocumentElement)iterator.next()).getStartOffset() <= documentElement.getEndOffset()) {
                    if (documentElement2.getStartOffset() < ((DocumentElement)object2).getEndOffset()) continue;
                    arrayList.add(documentElement2);
                    object2 = documentElement2;
                }
            }
            assert (!arrayList.contains(documentElement)) : "getChildren(de) contains the de itself!";
            object = this.cacheChildrenList(documentElement, arrayList);
            return object;
        }
        catch (Exception exception) {
            System.err.println("Error in getCHildren!!!! for " + documentElement);
            this.debugElements();
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
            exception.printStackTrace();
            sequencedCollection = Collections.emptyList();
            return sequencedCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    private List<DocumentElement> getCachedChildren(DocumentElement documentElement) {
        return this.childrenCache.get(documentElement);
    }

    private List<DocumentElement> cacheChildrenList(DocumentElement documentElement, List<DocumentElement> list) {
        this.childrenCache.put(documentElement, list);
        return list;
    }

    private void clearChildrenCache() {
        this.childrenCache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getParent(DocumentElement documentElement) {
        DocumentElement documentElement2 = this.getCachedParent(documentElement);
        if (documentElement2 != null) {
            return documentElement2;
        }
        this.readLock();
        try {
            if (!this.getElementsSet().contains(documentElement)) {
                this.debugElements();
                throw new IllegalArgumentException("getParent() called for " + documentElement + " which is not in the elements list!");
            }
            if (documentElement.isRootElement()) {
                DocumentElement documentElement3 = null;
                return documentElement3;
            }
            SortedSet<DocumentElement> sortedSet = this.getElementsSet().headSet(documentElement);
            if (sortedSet.isEmpty()) {
                DocumentElement documentElement4 = null;
                return documentElement4;
            }
            DocumentElement[] documentElementArray = sortedSet.toArray(new DocumentElement[0]);
            for (int i = documentElementArray.length - 1; i >= 0; --i) {
                DocumentElement documentElement5 = documentElementArray[i];
                if (documentElement5.isEmpty() || !this.isDescendantOf(documentElement5, documentElement) || documentElement5.getStartOffset() >= documentElement.getStartOffset()) continue;
                DocumentElement documentElement6 = this.cacheParent(documentElement, documentElement5);
                return documentElement6;
            }
            DocumentElement documentElement7 = this.cacheParent(documentElement, this.getRootElement());
            return documentElement7;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentElement getCachedParent(DocumentElement documentElement) {
        return this.parentsCache.get(documentElement);
    }

    private DocumentElement cacheParent(DocumentElement documentElement, DocumentElement documentElement2) {
        this.parentsCache.put(documentElement, documentElement2);
        return documentElement2;
    }

    private void clearParentsCache() {
        this.parentsCache = new Hashtable();
    }

    private void generateParentsCache() {
        Stack<DocumentElement> stack = new Stack<DocumentElement>();
        block0: for (DocumentElement documentElement : this.getElementsSet()) {
            if (stack.empty()) {
                stack.push(documentElement);
                continue;
            }
            DocumentElement documentElement2 = (DocumentElement)stack.pop();
            while (true) {
                if (this.isDescendantOf(documentElement2, documentElement)) {
                    this.cacheParent(documentElement, documentElement2);
                    stack.push(documentElement2);
                    stack.push(documentElement);
                    continue block0;
                }
                documentElement2 = (DocumentElement)stack.pop();
            }
        }
    }

    private DocumentElement createDocumentElement(String string, String string2, Map map, int n, int n2) throws BadLocationException {
        return new DocumentElement(string, string2, map, n, n2, this);
    }

    private void fireDocumentModelEvent(DocumentElement documentElement, int n) {
        for (DocumentModelListener documentModelListener : this.dmListeners) {
            switch (n) {
                case 1: {
                    documentModelListener.documentElementAdded(documentElement);
                    break;
                }
                case 2: {
                    documentModelListener.documentElementRemoved(documentElement);
                    break;
                }
                case 3: {
                    documentModelListener.documentElementChanged(documentElement);
                    break;
                }
                case 4: {
                    documentModelListener.documentElementAttributesChanged(documentElement);
                }
            }
        }
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            this.currReader = Thread.currentThread();
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        assert (this.numReaders > 0) : "Bad read lock state!";
        --this.numReaders;
        if (this.numReaders == 0) {
            this.currReader = null;
        }
        this.notify();
    }

    private final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    ++this.numWriters;
                    return;
                }
                if (Thread.currentThread() == this.currReader) {
                    return;
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    private final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currWriter = null;
            this.notifyAll();
        }
    }

    void debugElements() {
        System.out.println("DEBUG ELEMENTS:");
        Iterator<DocumentElement> iterator = this.getElementsSet().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        System.out.println("*****\n");
    }

    static final boolean isEmpty(DocumentElement documentElement) {
        return documentElement.getStartOffset() == documentElement.getEndOffset();
    }

    public class DocumentChange {
        public static final int INSERT = 0;
        public static final int REMOVE = 1;
        private Position changeStart;
        private int changeLength;
        private int type;

        DocumentChange(Position position, int n, int n2) {
            this.changeStart = position;
            this.changeLength = n;
            this.type = n2;
        }

        public Position getChangeStart() {
            return this.changeStart;
        }

        public int getChangeLength() {
            return this.changeLength;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "Change[" + this.getChangeStart().getOffset() + "-" + (this.getChangeStart().getOffset() + this.getChangeLength()) + "-" + (this.type == 0 ? "INSERT" : "REMOVE") + "] text: " + this.getChangeText();
        }

        private String getChangeText() {
            try {
                String string = DocumentModel.this.getDocument().getText(this.getChangeStart().getOffset(), this.getChangeLength());
                if (this.type == 0) {
                    return string;
                }
                if (this.type == 1) {
                    return "[cannot provide removed text]; the text on remove offset: " + string;
                }
                assert (false) : "Wrong document change type!";
            }
            catch (BadLocationException badLocationException) {
                return "BadLocationException thrown: " + badLocationException.getMessage();
            }
            return null;
        }
    }

    private final class DocumentChangesWatcher
    implements DocumentListener {
        private ArrayList<DocumentChange> documentChanges = new ArrayList();

        private DocumentChangesWatcher() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            DocumentModel.this.documentDirty = true;
            try {
                if (DocumentModel.this.getRootElement().getStartOffset() > 0 || DocumentModel.this.getRootElement().getEndOffset() < DocumentModel.this.getDocument().getLength()) {
                    DocumentModel.this.getRootElement().setStartPosition(0);
                    DocumentModel.this.getRootElement().setEndPosition(DocumentModel.this.getDocument().getLength());
                }
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                int n3 = documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) ? 1 : 0;
                DocumentChange documentChange = new DocumentChange(DocumentModel.this.getDocument().createPosition(n), n2, n3);
                this.documentChanges.add(documentChange);
                if (debug) {
                    System.out.println(documentChange);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            DocumentModel.this.requestModelUpdate();
        }

        public DocumentChange[] getDocumentChanges() {
            List list = (List)this.documentChanges.clone();
            return list.toArray(new DocumentChange[0]);
        }

        public void clearChanges() {
            this.documentChanges.clear();
        }
    }

    public final class DocumentModelModificationTransaction {
        private ArrayList<DocumentModelModification> modifications = new ArrayList();
        private boolean transactionCancelled = false;
        private boolean init;

        DocumentModelModificationTransaction(boolean bl) {
            this.init = bl;
        }

        public DocumentElement addDocumentElement(String string, String string2, Map map, int n, int n2) throws BadLocationException, DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentElement documentElement = DocumentModel.this.createDocumentElement(string, string2, map, n, n2);
            if (!DocumentModel.this.getElementsSet().contains(documentElement)) {
                if (debug) {
                    System.out.println("# ADD " + documentElement + " adding into transaction");
                }
                DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 1);
                this.modifications.add(documentModelModification);
            }
            return documentElement;
        }

        public void removeDocumentElement(DocumentElement documentElement, boolean bl) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            if (documentElement.isRootElement()) {
                if (debug) {
                    System.out.println("WARNING: root element cannot be removed!");
                }
                return;
            }
            if (debug) {
                System.out.println("# REMOVE " + documentElement + " adding into transaction ");
            }
            if (bl) {
                for (DocumentElement documentElement2 : DocumentModel.this.getChildren(documentElement)) {
                    this.removeDocumentElement(documentElement2, true);
                }
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 2);
            this.modifications.add(documentModelModification);
        }

        public void updateDocumentElementText(DocumentElement documentElement) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 3);
            if (!this.modifications.contains(documentModelModification)) {
                this.modifications.add(documentModelModification);
            }
        }

        public void updateDocumentElementAttribs(DocumentElement documentElement, Map map) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 4, map);
            if (!this.modifications.contains(documentModelModification)) {
                this.modifications.add(documentModelModification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() throws DocumentModelTransactionCancelledException {
            long l = System.currentTimeMillis();
            DocumentModel.this.writeLock();
            try {
                Object object;
                if (this.transactionCancelled) {
                    throw new DocumentModelTransactionCancelledException();
                }
                long l2 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting REMOVEs");
                }
                Iterator<DocumentModelModification> iterator = this.modifications.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    DocumentModelModification documentModelModification = iterator.next();
                    if (documentModelModification.type != 2) continue;
                    this.removeDE(documentModelModification.de);
                    ++n;
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + n + " removes commited in " + (System.currentTimeMillis() - l2));
                }
                DocumentModel.this.getRootElement().setElementIsEmptyState(false);
                long l3 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting ADDs");
                }
                iterator = this.modifications.iterator();
                TreeSet<DocumentElement> treeSet = new TreeSet<DocumentElement>(ELEMENTS_COMPARATOR);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((DocumentModelModification)object).type != 1) continue;
                    treeSet.add(((DocumentModelModification)object).de);
                }
                object = new ArrayList(treeSet.size());
                int n2 = treeSet.size();
                for (DocumentElement object2 : treeSet) {
                    if (!this.addDE(object2)) continue;
                    ((ArrayList)object).add(object2);
                }
                DocumentModel.this.clearChildrenCache();
                DocumentModel.this.clearParentsCache();
                if (!this.init) {
                    DocumentModel.this.generateParentsCache();
                    Iterator l4 = ((ArrayList)object).iterator();
                    while (l4.hasNext()) {
                        DocumentElement documentElement = (DocumentElement)l4.next();
                        this.fireElementAddedEvent(documentElement);
                    }
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + n2 + " adds commited in " + (System.currentTimeMillis() - l3));
                }
                long l4 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting text UPDATESs");
                }
                for (DocumentModelModification documentModelModification : this.modifications) {
                    if (documentModelModification.type != 3) continue;
                    this.updateDEText(documentModelModification.de);
                }
                if (debug) {
                    System.out.println("\n# commiting attribs UPDATESs");
                }
                for (DocumentModelModification documentModelModification : this.modifications) {
                    if (documentModelModification.type != 4) continue;
                    this.updateDEAttrs(documentModelModification.de, documentModelModification.attrs);
                }
                if (measure) {
                    System.out.println("[xmlmodel] updates commit done in " + (System.currentTimeMillis() - l4));
                }
            }
            finally {
                DocumentModel.this.writeUnlock();
            }
            if (debug) {
                System.out.println("# commit finished\n");
            }
            if (measure) {
                System.out.println("[xmlmodel] commit done in " + (System.currentTimeMillis() - l));
            }
        }

        private void updateDEText(DocumentElement documentElement) {
            DocumentModel.this.fireDocumentModelEvent(documentElement, 3);
            documentElement.contentChanged();
        }

        private void updateDEAttrs(DocumentElement documentElement, Map map) {
            documentElement.setAttributes(map);
            DocumentModel.this.fireDocumentModelEvent(documentElement, 4);
            documentElement.attributesChanged();
        }

        private boolean addDE(DocumentElement documentElement) {
            return DocumentModel.this.getElementsSet().add(documentElement);
        }

        private void fireElementAddedEvent(DocumentElement documentElement) {
            List<DocumentElement> list = documentElement.getChildren();
            DocumentElement documentElement2 = documentElement.getParentElement();
            if (documentElement2 != null) {
                documentElement2.childAdded(documentElement);
                for (DocumentElement documentElement3 : list) {
                    documentElement2.childRemoved(documentElement3);
                    documentElement.childAdded(documentElement3);
                }
            }
            DocumentModel.this.fireDocumentModelEvent(documentElement, 1);
        }

        private void removeDE(DocumentElement documentElement) {
            if (debug) {
                System.out.println("[DTM] removing " + documentElement);
            }
            DocumentElement documentElement2 = null;
            if (documentElement.isRootElement()) {
                return;
            }
            if (!DocumentModel.this.getElementsSet().contains(documentElement)) {
                return;
            }
            documentElement2 = DocumentModel.this.getParent(documentElement);
            Iterator<DocumentElement> iterator = documentElement.getChildren().iterator();
            if (debug) {
                System.out.println("[DMT] removed element " + documentElement + " ;parent = " + documentElement2);
            }
            if (documentElement2 == null) {
                if (debug) {
                    System.out.println("[DTM] WARNING: element has no parent (no events are fired to it!!!) " + documentElement);
                }
                if (debug) {
                    System.out.println("[DTM] Trying to recover by returning root element...");
                }
                documentElement2 = DocumentModel.this.getRootElement();
            }
            DocumentModel.this.clearChildrenCache();
            DocumentModel.this.clearParentsCache();
            DocumentModel.this.getElementsSet().remove(documentElement);
            while (iterator.hasNext()) {
                DocumentElement documentElement3 = iterator.next();
                if (debug) {
                    System.out.println("switching child " + documentElement3 + "from removed " + documentElement + "to parent " + documentElement2);
                }
                documentElement.childRemoved(documentElement3);
                documentElement2.childAdded(documentElement3);
            }
            if (documentElement2 != null) {
                documentElement2.childRemoved(documentElement);
            }
            DocumentModel.this.fireDocumentModelEvent(documentElement, 2);
        }

        private void setTransactionCancelled() {
            this.transactionCancelled = true;
        }

        private final class DocumentModelModification {
            public static final int ELEMENT_ADD = 1;
            public static final int ELEMENT_REMOVED = 2;
            public static final int ELEMENT_CHANGED = 3;
            public static final int ELEMENT_ATTRS_CHANGED = 4;
            public int type;
            public DocumentElement de;
            public Map attrs = null;

            public DocumentModelModification(DocumentElement documentElement, int n) {
                this.de = documentElement;
                this.type = n;
            }

            public DocumentModelModification(DocumentElement documentElement, int n, Map map) {
                this(documentElement, n);
                this.attrs = map;
            }

            public boolean equals(Object object) {
                if (!(object instanceof DocumentModelModification)) {
                    return false;
                }
                DocumentModelModification documentModelModification = (DocumentModelModification)object;
                return documentModelModification.type == this.type && documentModelModification.de.equals(this.de);
            }
        }
    }

    public final class DocumentModelTransactionCancelledException
    extends Exception {
    }
}

