/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagBasedLexerFormatter
extends ExtFormatter {
    private static final Logger logger = Logger.getLogger(TagBasedLexerFormatter.class.getName());

    public TagBasedLexerFormatter(Class clazz) {
        super(clazz);
    }

    protected abstract boolean isClosingTag(TokenHierarchy var1, int var2);

    protected abstract boolean isUnformattableToken(TokenHierarchy var1, int var2);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(TokenHierarchy var1, int var2);

    protected abstract String extractTagName(TokenHierarchy var1, int var2);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(TokenHierarchy var1, int var2);

    protected abstract int getTagEndingAtPosition(TokenHierarchy var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(TokenHierarchy var1, int var2);

    protected boolean isWSTag(Token token) {
        char[] cArray;
        for (char c : cArray = ((Object)token.text()).toString().toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected int getIndentForTagParameter(TokenHierarchy<?> tokenHierarchy, int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)tokenHierarchy.mutableInputSource();
        int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            int n3 = tokenSequence.offset();
            if (this.isWSTag(token) && n2 == Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3)) continue;
            if (this.isWSTag(token) || n2 != Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3)) break;
            return n3 - Utilities.getRowIndent((BaseDocument)baseDocument, (int)n3) - Utilities.getRowStart((BaseDocument)baseDocument, (int)n3);
        }
        return this.getShiftWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer reformat(BaseDocument baseDocument, int n, int n2, boolean bl) throws BadLocationException, IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ArrayList<TagIndentationData> arrayList = new ArrayList<TagIndentationData>();
        baseDocument.atomicLock();
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        if (tokenHierarchy == null) {
            logger.severe("Could not retrieve TokenHierarchy for document " + baseDocument);
            return null;
        }
        try {
            int n3;
            int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)baseDocument.getLength());
            int n5 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
            int n6 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
            int n7 = -1;
            boolean[] blArray = new boolean[n4 + 1];
            int[] nArray = new int[n4 + 1];
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.moveStart();
            boolean bl2 = tokenSequence.moveNext();
            if (tokenSequence != null) {
                do {
                    boolean bl3;
                    int n8;
                    boolean bl4 = this.isOpeningTag(tokenHierarchy, tokenSequence.offset());
                    boolean bl5 = this.isClosingTag(tokenHierarchy, tokenSequence.offset());
                    if (bl4 || bl5) {
                        int n9;
                        Object object;
                        String string = this.extractTagName(tokenHierarchy, tokenSequence.offset());
                        n3 = this.getTagEndOffset(tokenHierarchy, tokenSequence.offset());
                        n8 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
                        if (bl4) {
                            object = new TagIndentationData(string, n8);
                            linkedList.add(object);
                            int n10 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset());
                            if (n10 < n8) {
                                n9 = this.getIndentForTagParameter(tokenHierarchy, tokenSequence.offset());
                                for (int i = n10 + 1; i <= n8; ++i) {
                                    nArray[i] = n9;
                                }
                                bl2 &= tokenSequence.moveNext();
                                while (Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset()) < n8 || this.isWSTag(tokenSequence.token())) {
                                    tokenSequence.moveNext();
                                }
                                if (tokenSequence.offset() == n3) {
                                    nArray[n8] = 0;
                                }
                            }
                        } else {
                            object = new LinkedList();
                            while (!linkedList.isEmpty()) {
                                TagIndentationData tagIndentationData = (TagIndentationData)linkedList.removeLast();
                                if (this.areTagNamesEqual(string, tagIndentationData.getTagName())) {
                                    tagIndentationData.setClosedOnLine(n8);
                                    arrayList.add(tagIndentationData);
                                    if (this.isUnformattableTag(string)) {
                                        for (n9 = n8 - 1; n9 > tagIndentationData.getLine(); --n9) {
                                            blArray[n9] = true;
                                        }
                                    }
                                    ((LinkedList)object).clear();
                                    break;
                                }
                                ((LinkedList)object).add(tagIndentationData);
                            }
                            linkedList.addAll((Collection<Object>)object);
                        }
                    }
                    if ((bl3 = this.isUnformattableToken(tokenHierarchy, tokenSequence.offset())) && n7 == -1) {
                        n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset());
                    }
                    if (n7 <= -1 || bl3 && (bl2 &= tokenSequence.moveNext())) continue;
                    n3 = bl2 ? Utilities.getLineOffset((BaseDocument)baseDocument, (int)(tokenSequence.offset() - 1)) : n4;
                    for (n8 = n7 + 1; n8 < n3; ++n8) {
                        blArray[n8] = true;
                    }
                    n7 = -1;
                } while (bl2);
            }
            int[] nArray2 = new int[n4 + 1];
            Arrays.fill(nArray2, 0);
            for (TagIndentationData tagIndentationData : arrayList) {
                n3 = tagIndentationData.getLine() + 1;
                while (n3 <= tagIndentationData.getClosedOnLine() - 1) {
                    int n11 = n3++;
                    nArray2[n11] = nArray2[n11] + 1;
                }
            }
            InitialIndentData initialIndentData = new InitialIndentData(baseDocument, nArray2, nArray, n5, n6);
            for (int i = n5; i <= n6; ++i) {
                n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                if (blArray[i] || !initialIndentData.isEligibleToIndent(i)) continue;
                this.changeRowIndent(baseDocument, n3, initialIndentData.getIndent(i));
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
        return null;
    }

    protected void enterPressed(JTextComponent jTextComponent, int n) throws BadLocationException {
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        int n3 = this.getInitialIndentFromPreviousLine(baseDocument, n2);
        int n4 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
        n4 = n4 == -1 ? 0 : n4;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        if (n2 == Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4)) {
            return;
        }
        int n5 = this.getTagEndingAtPosition(tokenHierarchy, n4);
        if (this.isOpeningTag(tokenHierarchy, n5)) {
            int n6 = this.getNextClosingTagOffset(tokenHierarchy, n + 1);
            if (n6 != -1) {
                int n7;
                int n8 = this.getMatchingOpeningTagStart(tokenHierarchy, n6);
                if (n5 == n8) {
                    n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n5);
                    int n9 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n6);
                    if (n9 == Utilities.getLineOffset((BaseDocument)baseDocument, (int)n)) {
                        if (n7 == n9 - 1) {
                            Position position = baseDocument.createPosition(this.getOpeningSymbolOffset(tokenHierarchy, n6));
                            this.changeRowIndent(baseDocument, n, n3 + this.getShiftWidth());
                            baseDocument.insertString(position.getOffset(), "\n", null);
                            int n10 = position.getOffset() - 1;
                            this.changeRowIndent(baseDocument, position.getOffset() + 1, n3);
                            n10 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n10);
                            jTextComponent.setCaretPosition(n10);
                        } else {
                            this.changeRowIndent(baseDocument, n, n3);
                        }
                    }
                }
                n7 = n3;
                if (this.isClosingTagRequired(baseDocument, this.extractTagName(tokenHierarchy, n5))) {
                    n7 += this.getShiftWidth();
                }
                this.changeRowIndent(baseDocument, n, n7);
            }
        } else {
            int n11 = n3;
            if (this.isJustBeforeClosingTag(tokenHierarchy, n)) {
                n11 = (n11 -= this.getShiftWidth()) < 0 ? 0 : n11;
            }
            this.changeRowIndent(baseDocument, n, n11);
        }
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)jTextComponent.getDocument());
        if (tokenHierarchy == null) {
            logger.severe("Could not retrieve TokenHierarchy for document " + jTextComponent.getDocument());
            return null;
        }
        char c = string.charAt(string.length() - 1);
        try {
            int n = jTextComponent.getCaret().getDot();
            if (c == '>') {
                int n2;
                BaseDocument baseDocument;
                int n3;
                int n4;
                int n5 = this.getTagEndingAtPosition(tokenHierarchy, n - 1);
                if (this.isClosingTag(tokenHierarchy, n5) && (n4 = this.getMatchingOpeningTagStart(tokenHierarchy, n5)) != -1 && (n3 = Utilities.getLineOffset((BaseDocument)(baseDocument = Utilities.getDocument((JTextComponent)jTextComponent)), (int)n4)) != (n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n))) {
                    return new int[]{n5, n};
                }
            } else if (c == '\n') {
                this.enterPressed(jTextComponent, n);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Exception during code formatting", exception);
        }
        return null;
    }

    protected int getMatchingOpeningTagStart(TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        String string = this.extractTagName(tokenHierarchy, n);
        int n2 = 0;
        while (tokenSequence.movePrevious()) {
            int n3 = tokenSequence.offset();
            if (!this.areTagNamesEqual(string, this.extractTagName(tokenHierarchy, n3))) continue;
            if (this.isOpeningTag(tokenHierarchy, n3)) {
                if (n2 == 0) {
                    return n3;
                }
                --n2;
                continue;
            }
            if (!this.isClosingTag(tokenHierarchy, n3)) continue;
            ++n2;
        }
        return -1;
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int n3;
        int n4 = 0;
        if (n > 0 && (n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)(n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n)))) > 0) {
            n4 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n3);
        }
        return n4;
    }

    private int getInitialIndentFromNextLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = 0;
        int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
        int n5 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n4);
        if (n5 > 0) {
            n2 = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n5, (boolean)true);
        }
        return n2;
    }

    protected static int getNumberOfLines(BaseDocument baseDocument) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)baseDocument, (int)(baseDocument.getLength() - 1)) + 1;
    }

    protected int getNextClosingTagOffset(TokenHierarchy tokenHierarchy, int n) throws BadLocationException {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        while (tokenSequence.moveNext()) {
            int n2 = tokenSequence.offset();
            if (!this.isClosingTag(tokenHierarchy, n2)) continue;
            return n2;
        }
        return -1;
    }

    protected boolean isJustBeforeClosingTag(TokenHierarchy tokenHierarchy, int n) throws BadLocationException {
        return this.isClosingTag(tokenHierarchy, n);
    }

    protected Token getTokenAtOffset(TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (tokenSequence.moveNext()) {
                return tokenSequence.token();
            }
        }
        return null;
    }

    protected class InitialIndentData {
        private final int indentLevelBias;
        private final int indentBias;
        private final int[] indentLevels;
        private final int[] indentsWithinTags;

        public InitialIndentData(BaseDocument baseDocument, int[] nArray, int[] nArray2, int n, int n2) throws BadLocationException {
            int n3 = TagBasedLexerFormatter.this.getInitialIndentFromPreviousLine(baseDocument, n);
            int n4 = n3 / TagBasedLexerFormatter.this.getShiftWidth() - (n > 0 ? nArray[n - 1] : 0);
            int n5 = TagBasedLexerFormatter.this.getInitialIndentFromNextLine(baseDocument, n2);
            int n6 = n5 / TagBasedLexerFormatter.this.getShiftWidth() - (n2 < TagBasedLexerFormatter.getNumberOfLines(baseDocument) - 1 ? nArray[n2 + 1] : 0);
            if (n6 > n4) {
                this.indentLevelBias = n6;
                n3 = n5;
            } else {
                this.indentLevelBias = n4;
            }
            this.indentBias = n3 % TagBasedLexerFormatter.this.getShiftWidth();
            this.indentLevels = nArray;
            this.indentsWithinTags = nArray2;
        }

        public boolean isEligibleToIndent(int n) {
            return this.getActualIndentLevel(n) >= 0;
        }

        public int getIndent(int n) {
            return this.indentBias + this.indentsWithinTags[n] + this.getActualIndentLevel(n) * TagBasedLexerFormatter.this.getShiftWidth();
        }

        private int getActualIndentLevel(int n) {
            return this.indentLevels[n] + this.indentLevelBias;
        }
    }

    protected static class TagIndentationData {
        private final String tagName;
        private final int line;
        private int closedOnLine;

        public TagIndentationData(String string, int n) {
            this.tagName = string;
            this.line = n;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int n) {
            this.closedOnLine = n;
        }
    }
}

