/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.awt.Image;
import java.io.File;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ChangeCVSRootAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.checkout.CheckoutAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.ExcludeFromCommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ExportDiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.ignore.IgnoreAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.AnnotationsAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.AddToRepositoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.project.UpdateWithDependenciesAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.status.StatusAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.BranchesMenu;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.MergeBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.TagAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class Annotator {
    private static MessageFormat uptodateFormat = Annotator.getFormat("uptodateFormat");
    private static MessageFormat newLocallyFormat = Annotator.getFormat("newLocallyFormat");
    private static MessageFormat addedLocallyFormat = Annotator.getFormat("addedLocallyFormat");
    private static MessageFormat modifiedLocallyFormat = Annotator.getFormat("modifiedLocallyFormat");
    private static MessageFormat removedLocallyFormat = Annotator.getFormat("removedLocallyFormat");
    private static MessageFormat deletedLocallyFormat = Annotator.getFormat("deletedLocallyFormat");
    private static MessageFormat newInRepositoryFormat = Annotator.getFormat("newInRepositoryFormat");
    private static MessageFormat modifiedInRepositoryFormat = Annotator.getFormat("modifiedInRepositoryFormat");
    private static MessageFormat removedInRepositoryFormat = Annotator.getFormat("removedInRepositoryFormat");
    private static MessageFormat conflictFormat = Annotator.getFormat("conflictFormat");
    private static MessageFormat mergeableFormat = Annotator.getFormat("mergeableFormat");
    private static MessageFormat excludedFormat = Annotator.getFormat("excludedFormat");
    private static final int STATUS_TEXT_ANNOTABLE = 6622;
    private static final Pattern lessThan = Pattern.compile("<");
    private final FileStatusCache cache;
    private String lastAnnotationsFormat;
    private MessageFormat lastMessageFormat;
    private String lastEmptyAnnotation;
    private static final int STATUS_BADGEABLE = 12;

    Annotator(CvsVersioningSystem cvsVersioningSystem) {
        this.cache = cvsVersioningSystem.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        Field[] fieldArray = Annotator.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = fieldArray[i].getName();
            if (!string.endsWith("Format")) continue;
            this.initDefaultColor(string.substring(0, string.length() - 6));
        }
    }

    private void initDefaultColor(String string) {
        String string2 = System.getProperty("cvs.color." + string);
        if (string2 == null) {
            return;
        }
        this.setAnnotationColor(string, string2);
    }

    private void setAnnotationColor(String string, String string2) {
        try {
            Field field = Annotator.class.getDeclaredField(string + "Format");
            MessageFormat messageFormat = new MessageFormat("<font color=\"" + string2 + "\">{0}</font><font color=\"#999999\">{1}</font>");
            field.set(null, messageFormat);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid color name");
        }
    }

    public String annotateNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        boolean bl = CvsModuleConfig.getDefault().getPreferences().getBoolean("textAnnotationsVisible", false);
        if (bl && file != null && (n & 0x19DE) != 0) {
            string2 = this.formatAnnotation(fileInformation, file);
            if (string2.equals(this.lastEmptyAnnotation)) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        switch (n) {
            case 0: 
            case 1: {
                return string;
            }
            case 8: {
                return uptodateFormat.format(new Object[]{string, string2});
            }
            case 16: {
                return modifiedLocallyFormat.format(new Object[]{string, string2});
            }
            case 4: {
                return newLocallyFormat.format(new Object[]{string, string2});
            }
            case 256: {
                return removedLocallyFormat.format(new Object[]{string, string2});
            }
            case 2048: {
                return deletedLocallyFormat.format(new Object[]{string, string2});
            }
            case 512: {
                return newInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 32: {
                return modifiedInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 1024: {
                return removedInRepositoryFormat.format(new Object[]{string, string2});
            }
            case 4096: {
                return addedLocallyFormat.format(new Object[]{string, string2});
            }
            case 128: {
                return mergeableFormat.format(new Object[]{string, string2});
            }
            case 64: {
                return conflictFormat.format(new Object[]{string, string2});
            }
            case 2: {
                return excludedFormat.format(new Object[]{string, string2});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private String formatAnnotation(FileInformation fileInformation, File file) {
        String string;
        this.updateMessageFormat();
        String string2 = "";
        int n = fileInformation.getStatus();
        if (n != 8) {
            string2 = fileInformation.getShortStatusText();
        }
        String string3 = "";
        String string4 = "";
        Entry entry = fileInformation.getEntry(file);
        if (entry != null) {
            string3 = entry.getRevision();
            string4 = entry.getOptions();
            if (!"-kb".equals(string4)) {
                string4 = "";
            }
        }
        string = (string = Utils.getSticky(file)) != null ? string.substring(1) : "";
        Object[] objectArray = new Object[]{string3, string2, string, string4};
        return this.lastMessageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString().trim();
    }

    private void updateMessageFormat() {
        String string = CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]");
        if (this.lastMessageFormat == null || !string.equals(this.lastAnnotationsFormat)) {
            while (true) {
                this.lastAnnotationsFormat = string;
                string = string.replaceAll("\\{revision}", "{0}").replaceAll("\\{status}", "{1}").replaceAll("\\{tag}", "{2}").replaceAll("\\{binary}", "{3}");
                try {
                    this.lastMessageFormat = new MessageFormat(string);
                    this.lastEmptyAnnotation = this.lastMessageFormat.format(new Object[]{"", "", "", ""});
                }
                catch (Exception exception) {
                    Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, this.lastAnnotationsFormat, exception);
                    string = "[{status}; {tag}]";
                    continue;
                }
                break;
            }
        }
    }

    private String annotateFolderNameHtml(String string, FileInformation fileInformation, File file) {
        String string2;
        string = this.htmlEncode(string);
        int n = fileInformation.getStatus();
        boolean bl = CvsModuleConfig.getDefault().getPreferences().getBoolean("textAnnotationsVisible", false);
        if (bl && file != null && (n & 0xFFFFFFFE) != 0) {
            string2 = this.formatAnnotation(fileInformation, file);
            if (string2.equals(this.lastEmptyAnnotation)) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = NbBundle.getMessage(Annotator.class, (String)"textAnnotation", (Object)string2);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: 
            case 1024: 
            case 2048: {
                return string;
            }
            case 4: 
            case 8: 
            case 4096: {
                return uptodateFormat.format(new Object[]{string, string2});
            }
            case 2: {
                return excludedFormat.format(new Object[]{string, string2});
            }
        }
        throw new IllegalArgumentException("Unknown status: " + n);
    }

    private String htmlEncode(String string) {
        if (string.indexOf(60) == -1) {
            return string;
        }
        return lessThan.matcher(string).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation fileInformation) {
        return this.annotateNameHtml(file.getName(), fileInformation, file);
    }

    public String annotateNameHtml(String string, VCSContext vCSContext, int n) {
        FileInformation fileInformation = null;
        File file = null;
        boolean bl = false;
        for (File file2 : vCSContext.getRootFiles()) {
            FileInformation fileInformation2 = this.cache.getStatus(file2);
            int n2 = fileInformation2.getStatus();
            if ((n2 & n) == 0 || !this.isMoreImportant(fileInformation2, fileInformation)) continue;
            fileInformation = fileInformation2;
            file = file2;
            bl = file2.isDirectory();
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (fileInformation == null) {
            return null;
        }
        return bl ? this.annotateFolderNameHtml(string, fileInformation, file) : this.annotateNameHtml(string, fileInformation, file);
    }

    private boolean isMoreImportant(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation2 == null) {
            return true;
        }
        if (fileInformation == null) {
            return false;
        }
        return Utils.getComparableStatus(fileInformation.getStatus()) < Utils.getComparableStatus(fileInformation2.getStatus());
    }

    Image annotateFolderIcon(Set set, Image image) {
        CvsModuleConfig cvsModuleConfig = CvsModuleConfig.getDefault();
        boolean bl = true;
        boolean bl2 = false;
        Map<File, FileInformation> map = this.cache.getAllModifiedFiles();
        HashMap hashMap = new HashMap();
        for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if (fileInformation.isDirectory() || (fileInformation.getStatus() & 0x19D4) == 0) continue;
            hashMap.put(file, fileInformation);
        }
        for (File file : set) {
            int n;
            FileInformation fileInformation;
            if (file instanceof FlatFolder) {
                for (File file2 : hashMap.keySet()) {
                    if (!file2.getParentFile().equals(file) || (fileInformation = (FileInformation)hashMap.get(file2)).isDirectory()) continue;
                    n = fileInformation.getStatus();
                    if (n == 64) {
                        Image image2 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)9);
                    }
                    bl2 = true;
                    bl &= cvsModuleConfig.isExcludedFromCommit(file2);
                }
                continue;
            }
            for (File file2 : hashMap.keySet()) {
                if (!Utils.isParentOrEqual(file, file2)) continue;
                fileInformation = (FileInformation)hashMap.get(file2);
                n = fileInformation.getStatus();
                if (n == 64) {
                    Image image3 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)image, (Image)image3, (int)16, (int)9);
                }
                bl2 = true;
                bl &= cvsModuleConfig.isExcludedFromCommit(file2);
            }
        }
        if (bl2 && !bl) {
            Image image4 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)image, (Image)image4, (int)16, (int)9);
        }
        return null;
    }

    public static Action[] getActions(VCSContext vCSContext, VCSAnnotator.ActionDestination actionDestination) {
        ResourceBundle resourceBundle = NbBundle.getBundle(Annotator.class);
        Node[] nodeArray = vCSContext.getNodes();
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        Lookup lookup = vCSContext.getNodes() != null ? Lookups.fixed((Object[])vCSContext.getNodes()) : null;
        boolean bl = Annotator.isNothingVersioned(fileArray);
        boolean bl2 = Annotator.onlyFolders(fileArray);
        boolean bl3 = Annotator.onlyProjects(vCSContext.getNodes());
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        if (actionDestination == VCSAnnotator.ActionDestination.MainMenu) {
            arrayList.add(SystemAction.get(CheckoutAction.class));
            arrayList.add(SystemAction.get(AddToRepositoryAction.class));
            arrayList.add(new ChangeCVSRootAction(resourceBundle.getString("CTL_MenuItem_ChangeCVSRoot"), vCSContext));
            arrayList.add(null);
            arrayList.add(SystemAction.get(UpdateWithDependenciesAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(StatusAction.class));
            arrayList.add(SystemAction.get(DiffAction.class));
            arrayList.add(SystemAction.get(UpdateAction.class));
            arrayList.add(SystemAction.get(CommitAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(ExportDiffAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(TagAction.class));
            arrayList.add(new BranchesMenu());
            arrayList.add(null);
            arrayList.add(SystemAction.get(AnnotationsAction.class));
            arrayList.add(new ViewRevisionAction(vCSContext));
            arrayList.add(SystemAction.get(SearchHistoryAction.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(GetCleanAction.class));
            arrayList.add(SystemAction.get(ResolveConflictsAction.class));
            arrayList.add(SystemAction.get(IgnoreAction.class));
            arrayList.add(new ExcludeFromCommitAction(vCSContext));
        } else if (bl) {
            arrayList.add(SystemActionBridge.createAction((Action)((AddToRepositoryAction)SystemAction.get(AddToRepositoryAction.class)).createContextAwareInstance(lookup), (String)resourceBundle.getString("CTL_PopupMenuItem_Import"), (Lookup)lookup));
        } else {
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Status"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Diff"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(UpdateAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Update"), (Lookup)lookup));
            if (bl3) {
                arrayList.add(new SystemActionBridge((Action)SystemAction.get(UpdateWithDependenciesAction.class), resourceBundle.getString("CTL_PopupMenuItem_UpdateWithDeps")));
            }
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Commit"), (Lookup)lookup));
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(TagAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Tag"), (Lookup)lookup));
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(BranchAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_Branch"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(SwitchBranchAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_SwitchBranch"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(MergeBranchAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_MergeBranch"), (Lookup)lookup));
            arrayList.add(null);
            if (!bl2) {
                arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(AnnotationsAction.class), (String)(((AnnotationsAction)SystemAction.get(AnnotationsAction.class)).visible(nodeArray) ? resourceBundle.getString("CTL_PopupMenuItem_HideAnnotations") : resourceBundle.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)lookup));
            }
            arrayList.add(new ViewRevisionAction(resourceBundle.getString("CTL_PopupMenuItem_ViewRevision"), vCSContext));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)lookup));
            arrayList.add(null);
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(GetCleanAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_GetClean"), (Lookup)lookup));
            arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)resourceBundle.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)lookup));
            if (!bl3) {
                arrayList.add(SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)(((IgnoreAction)SystemAction.get(IgnoreAction.class)).getActionStatus(nodeArray) == 2 ? resourceBundle.getString("CTL_PopupMenuItem_Unignore") : resourceBundle.getString("CTL_PopupMenuItem_Ignore")), (Lookup)lookup));
            }
            arrayList.add(new ExcludeFromCommitAction(vCSContext));
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private static boolean isNothingVersioned(File[] fileArray) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file : fileArray) {
            if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProjects(Node[] nodeArray) {
        if (nodeArray == null) {
            return false;
        }
        for (Node node : nodeArray) {
            if (node.getLookup().lookup(Project.class) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyFolders(File[] fileArray) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                return false;
            }
            if (fileArray[i].exists() || fileStatusCache.getStatus(fileArray[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private static MessageFormat getFormat(String string) {
        String string2 = NbBundle.getMessage(Annotator.class, (String)string);
        return new MessageFormat(string2);
    }

    public Image annotateIcon(Image image, VCSContext vCSContext) {
        boolean bl = false;
        for (File file : vCSContext.getRootFiles()) {
            if (!file.isDirectory()) continue;
            bl = true;
            break;
        }
        if (!bl && vCSContext.getRootFiles().size() > 1) {
            boolean bl2 = bl = !org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]));
        }
        if (!bl) {
            return null;
        }
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        boolean bl3 = false;
        for (File file : vCSContext.getRootFiles()) {
            if ((fileStatusCache.getStatus(file).getStatus() & 0xC) == 0) continue;
            bl3 = true;
            break;
        }
        if (!bl3) {
            return null;
        }
        CvsModuleConfig cvsModuleConfig = CvsModuleConfig.getDefault();
        boolean bl4 = true;
        boolean bl5 = false;
        Map<File, FileInformation> map = fileStatusCache.getAllModifiedFiles();
        HashMap hashMap = new HashMap();
        for (Map.Entry<File, FileInformation> object : map.entrySet()) {
            FileInformation fileInformation = object.getValue();
            if (fileInformation.isDirectory() || (fileInformation.getStatus() & 0x19D4) == 0) continue;
            hashMap.put(object.getKey(), fileInformation);
        }
        for (File file : vCSContext.getRootFiles()) {
            int n;
            FileInformation fileInformation;
            if (file instanceof FlatFolder) {
                for (File file2 : hashMap.keySet()) {
                    if (!file2.getParentFile().equals(file) || (fileInformation = (FileInformation)hashMap.get(file2)).isDirectory()) continue;
                    n = fileInformation.getStatus();
                    if (n == 64) {
                        Image image2 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                        return Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)9);
                    }
                    bl5 = true;
                    bl4 &= cvsModuleConfig.isExcludedFromCommit(file2);
                }
                continue;
            }
            for (File file2 : hashMap.keySet()) {
                if (!Utils.isParentOrEqual(file, file2)) continue;
                fileInformation = (FileInformation)hashMap.get(file2);
                n = fileInformation.getStatus();
                if (n == 64) {
                    Image image3 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/conflicts-badge.png", (boolean)true);
                    return Utilities.mergeImages((Image)image, (Image)image3, (int)16, (int)9);
                }
                bl5 = true;
                bl4 &= cvsModuleConfig.isExcludedFromCommit(file2);
            }
        }
        if (bl5 && !bl4) {
            Image image4 = Utilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/resources/icons/modified-badge.png", (boolean)true);
            return Utilities.mergeImages((Image)image, (Image)image4, (int)16, (int)9);
        }
        return null;
    }
}

