/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ExtConnection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.PasswordsFile;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.CommandRunnable;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.IllegalCommandException;
import org.netbeans.modules.versioning.system.cvss.SSHConnection;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public class ClientRuntime {
    private final String cvsRoot;
    private String cvsRootDisplay;
    private RequestProcessor requestProcessor;
    private InputOutput log;

    ClientRuntime(String string) {
        this.cvsRoot = string;
        this.cvsRootDisplay = string;
        try {
            int n;
            CVSRoot cVSRoot = CVSRoot.parse((String)this.cvsRoot);
            if (cVSRoot.getPassword() != null && (n = string.indexOf(cVSRoot.getPassword())) != -1) {
                this.cvsRootDisplay = this.cvsRoot.substring(0, n - 1) + this.cvsRoot.substring(n + cVSRoot.getPassword().length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestProcessor = new RequestProcessor("CVS: " + this.cvsRootDisplay);
    }

    private void ensureValidCommand(File[] fileArray) throws IllegalCommandException {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            try {
                String string = Utils.getCVSRootFor(file);
                if (string.equals(this.cvsRoot)) continue;
                throw new IllegalCommandException("#63547 command includes files from different CVS root.\n Expected: " + this.cvsRoot + "\nGot:     " + string);
            }
            catch (IOException iOException) {
                throw new IllegalCommandException("Missing or invalid CVS/Root for: " + file);
            }
        }
    }

    public RequestProcessor.Task createTask(Command command, GlobalOptions globalOptions, final ExecutorSupport executorSupport) throws IllegalCommandException {
        String string;
        Object object;
        File[] fileArray = this.getCommandFiles(command);
        if (!(command instanceof CheckoutCommand) && !(command instanceof RlogCommand)) {
            this.ensureValidCommand(fileArray);
        }
        if (globalOptions.getCVSRoot() == null) {
            globalOptions = (GlobalOptions)globalOptions.clone();
            globalOptions.setCVSRoot(this.cvsRoot);
        }
        Client client = this.createClient();
        if (!(command instanceof RlogCommand)) {
            if (command instanceof CheckoutCommand) {
                object = (BasicCommand)command;
                if (object.getFiles() != null) {
                    string = object.getFiles()[0].getAbsolutePath();
                    client.setLocalPath(string);
                } else {
                    client.setLocalPath(System.getProperty("user.dir"));
                }
            } else if (command instanceof ImportCommand) {
                client.setLocalPath(((ImportCommand)command).getImportDirectory());
            } else {
                this.setLocalDirectory(client, fileArray);
            }
        }
        client.getEventManager().addCVSListener((CVSListener)executorSupport);
        object = new CommandRunnable(client, globalOptions, command, executorSupport);
        executorSupport.commandEnqueued((CommandRunnable)object);
        string = this.requestProcessor.create((Runnable)object);
        string.addTaskListener(new TaskListener((CommandRunnable)object){
            final /* synthetic */ CommandRunnable val$cr;
            {
                this.val$cr = commandRunnable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                try {
                    executorSupport.commandTerminated(new TerminationEvent((Object)new Result(this.val$cr)));
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(16, throwable);
                }
                finally {
                    ClientRuntime.this.flushLog();
                }
            }
        });
        return string;
    }

    public void log(String string) {
        this.log(string, null);
    }

    public void log(String string, OutputListener outputListener) {
        this.openLog();
        if (outputListener != null) {
            try {
                this.log.getOut().println(string, outputListener);
            }
            catch (IOException iOException) {
                this.log.getOut().write(string);
            }
        } else {
            this.log.getOut().write(string);
        }
    }

    private void openLog() {
        if (this.log == null || this.log.isClosed()) {
            this.log = IOProvider.getDefault().getIO(this.cvsRootDisplay, false);
            try {
                this.log.getOut().reset();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify((Throwable)iOException);
            }
        }
    }

    public void logError(Throwable throwable) {
        this.openLog();
        throwable.printStackTrace((PrintWriter)this.log.getOut());
    }

    void focusLog() {
        if (this.log != null) {
            this.log.select();
        }
    }

    public void flushLog() {
        if (this.log != null) {
            this.log.getOut().close();
        }
    }

    private File[] getCommandFiles(Command command) {
        if (command instanceof AddCommand) {
            AddCommand addCommand = (AddCommand)command;
            return addCommand.getFiles();
        }
        if (command instanceof BasicCommand) {
            BasicCommand basicCommand = (BasicCommand)command;
            return basicCommand.getFiles();
        }
        return new File[0];
    }

    private void setLocalDirectory(Client client, File[] fileArray) throws IllegalCommandException {
        if (fileArray.length == 0) {
            return;
        }
        File file = fileArray[0].isDirectory() ? fileArray[0] : fileArray[0].getParentFile();
        for (int i = 1; i < fileArray.length; ++i) {
            if (Utils.isParentOrEqual(file, fileArray[i])) continue;
            do {
                if ((file = file.getParentFile()) != null) continue;
                throw new IllegalCommandException("Files do not have common parent!");
            } while (!Utils.isParentOrEqual(file, fileArray[i]));
        }
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            FileInformation fileInformation = fileStatusCache.getStatus(file2);
            if (fileInformation.getStatus() != 8) continue;
            file = file2;
            break;
        }
        client.setLocalPath(file.getAbsolutePath());
    }

    private Client createClient() {
        Connection connection = ClientRuntime.setupConnection(CVSRoot.parse((String)this.cvsRoot));
        Client client = new Client(connection, CvsVersioningSystem.getInstance().getAdminHandler());
        client.setUncompressedFileHandler(CvsVersioningSystem.getInstance().getFileHandler());
        client.setGzipFileHandler(CvsVersioningSystem.getInstance().getGzippedFileHandler());
        return client;
    }

    public static Connection setupConnection(CVSRoot cVSRoot) throws IllegalArgumentException {
        String string = System.getProperty("netbeans.t9y.cvs.connection.CVSROOT");
        CVSRoot cVSRoot2 = cVSRoot;
        if (string != null && string.length() > 0) {
            int n = string.indexOf(44);
            if (n != -1) {
                System.setProperty("netbeans.t9y.cvs.connection.CVSROOT", string.substring(n + 1));
                string = string.substring(0, n);
            }
            try {
                cVSRoot2 = CVSRoot.parse((String)string);
                assert (cVSRoot2.getRepository().equals(cVSRoot.getRepository()));
                assert (cVSRoot2.getHostName() == cVSRoot.getHostName() || cVSRoot2.getHostName().equals(cVSRoot.getHostName()));
                ErrorManager.getDefault().log(1, "CVS.ClientRuntime: using patched CVSROOT " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, "While parsing: " + string);
                ErrorManager.getDefault().notify((Throwable)illegalArgumentException);
            }
        }
        if (cVSRoot.isLocal()) {
            LocalConnection localConnection = new LocalConnection();
            localConnection.setRepository(cVSRoot.getRepository());
            return localConnection;
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        String string2 = cVSRoot.getMethod();
        if ("pserver".equals(string2)) {
            PServerConnection pServerConnection = new PServerConnection(cVSRoot2, socketFactory);
            String string3 = PasswordsFile.findPassword((String)cVSRoot.toString());
            pServerConnection.setEncodedPassword(string3);
            return pServerConnection;
        }
        if ("ext".equals(string2)) {
            CvsModuleConfig.ExtSettings extSettings = CvsModuleConfig.getDefault().getExtSettingsFor(cVSRoot);
            String string4 = cVSRoot.getUserName();
            String string5 = cVSRoot.getHostName();
            if (extSettings.extUseInternalSsh) {
                int n = cVSRoot2.getPort();
                n = n == 0 ? 22 : n;
                String string6 = extSettings.extPassword;
                if (string6 == null) {
                    string6 = "\n";
                }
                SSHConnection sSHConnection = new SSHConnection(socketFactory, string5, n, string4, string6);
                sSHConnection.setRepository(cVSRoot.getRepository());
                return sSHConnection;
            }
            String string7 = extSettings.extCommand;
            String string8 = System.getenv("CVS_SERVER");
            string8 = string8 != null ? string8 + " server" : "cvs server";
            String string9 = "";
            if (string4 != null) {
                string9 = " -l " + string4;
            }
            string7 = string7 + " " + string5 + string9 + " " + string8;
            ExtConnection extConnection = new ExtConnection(string7);
            extConnection.setRepository(cVSRoot.getRepository());
            return extConnection;
        }
        throw new IllegalArgumentException("Unrecognized CVS Root: " + cVSRoot);
    }

    public String toString() {
        return "ClientRuntime queue=" + this.cvsRootDisplay + " processor=" + this.requestProcessor;
    }

    public static class Result {
        private final CommandRunnable runnable;

        public Result(CommandRunnable commandRunnable) {
            this.runnable = commandRunnable;
        }

        public Throwable getError() {
            return this.runnable.getFailure();
        }

        public boolean isAborted() {
            return this.runnable.isAborted();
        }
    }
}

