/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

class CommandRunnable
implements Runnable,
Cancellable {
    private final Client client;
    private final GlobalOptions options;
    private final Command cmd;
    private Throwable failure;
    private boolean aborted;
    private Thread interruptibleThread;
    private ExecutorSupport support;
    private static boolean testRetry = Boolean.getBoolean("netbeans.debug.cvs.io.retry");

    public CommandRunnable(Client client, GlobalOptions globalOptions, Command command, ExecutorSupport executorSupport) {
        this.client = client;
        this.options = globalOptions;
        this.cmd = command;
        this.support = executorSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Runnable runnable = this;
        synchronized (runnable) {
            if (this.isAborted()) {
                return;
            }
            this.support.commandStarted(this);
        }
        this.interruptibleThread = Thread.currentThread();
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CounterRunnable counterRunnable = new CounterRunnable();
                RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)counterRunnable);
                counterRunnable.initTask(task);
                try {
                    task.schedule(500);
                    if (testRetry && !((CommandRunnable)CommandRunnable.this).support.t9yRetryFlag) {
                        ((CommandRunnable)CommandRunnable.this).support.t9yRetryFlag = true;
                        String string = "Testing retry logic. Retry attempt will be OK. (-Dnetbeans.debug.cvs.io.retry=true)";
                        throw new AuthenticationException(string, string);
                    }
                    CommandRunnable.this.client.executeCommand(CommandRunnable.this.cmd, CommandRunnable.this.options);
                }
                catch (Throwable throwable) {
                    CommandRunnable.this.failure = throwable;
                }
                finally {
                    task.cancel();
                    try {
                        CommandRunnable.this.client.getConnection().close();
                    }
                    catch (Throwable throwable) {
                        ErrorManager.getDefault().notify(16, throwable);
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "CVS I/O Worker ");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)interruptedException, "Passing interrupt to possibly uninterruptible nested thread: " + thread + "\nCVS command: " + this.cmd.getCVSCommand());
            thread.interrupt();
            errorManager.notify(1, (Throwable)interruptedException);
            Thread.currentThread().interrupt();
            try {
                thread.join(2000L);
            }
            catch (InterruptedException interruptedException2) {
                // empty catch block
            }
        }
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized boolean cancel() {
        if (this.aborted) {
            return false;
        }
        this.aborted = true;
        this.client.abort();
        if (this.interruptibleThread != null) {
            this.interruptibleThread.interrupt();
        }
        return true;
    }

    public String toString() {
        return "CommandRunnable command=" + this.cmd.getCVSCommand();
    }

    private class CounterRunnable
    implements Runnable {
        private RequestProcessor.Task task;
        private long counter;

        private CounterRunnable() {
        }

        public void run() {
            long l = CommandRunnable.this.client.getCounter();
            long l2 = l - this.counter;
            this.counter = l;
            CommandRunnable.this.support.increaseDataCounter(l2);
            this.task.schedule(500);
        }

        void initTask(RequestProcessor.Task task) {
            this.task = task;
        }
    }
}

