/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CvsVisibilityQuery
implements VisibilityQueryImplementation,
VersioningListener {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public CvsVisibilityQuery() {
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
    }

    public boolean isVisible(FileObject fileObject) {
        if (fileObject.isData()) {
            return true;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        return file == null || !CvsVisibilityQuery.isHiddenFolder(file);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.add(changeListener);
        this.listeners = arrayList;
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        arrayList.remove(changeListener);
        this.listeners = arrayList;
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)versioningEvent.getParams()[0];
            if (file == null) {
                return;
            }
            File file2 = file.getParentFile();
            if (file2 == null) {
                return;
            }
            File file3 = new File(file2, "CVS/.nb-removed");
            if (file3.exists()) {
                this.fireVisibilityChanged();
            }
        }
    }

    static boolean isHiddenFolder(File file) {
        File file2 = new File(file, "CVS/.nb-removed");
        if (file2.exists()) {
            File[] fileArray;
            for (File file3 : fileArray = file.listFiles()) {
                if (file3.lastModified() <= file2.lastModified() || "CVS".equals(file3.getName())) continue;
                file2.delete();
                return false;
            }
            return true;
        }
        return false;
    }

    private void fireVisibilityChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

