/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private static Thread ignoredThread;

    public FilesystemHandler(CvsVersioningSystem cvsVersioningSystem) {
        this.cache = cvsVersioningSystem.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return false;
        }
        return Utils.isPartOfCVSMetadata(file) || file.isDirectory() && this.hasMetadata(file);
    }

    public void doDelete(File file) throws IOException {
        if (file.isDirectory() && this.hasMetadata(file)) {
            new File(file, "CVS/.nb-removed").createNewFile();
            this.cache.refresh(file, 0, true);
            return;
        }
        if (!Utils.isPartOfCVSMetadata(file) && !file.delete()) {
            throw new IOException("Failed to delete file: " + file.getAbsolutePath());
        }
    }

    public void afterDelete(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(file);
            }
        });
    }

    public boolean beforeMove(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file != null && file3 != null && file.isDirectory()) {
            FileInformation fileInformation = this.cache.getStatus(file);
            return (fileInformation.getStatus() & 0xFFFFFFFE) != 0;
        }
        return false;
    }

    public void doMove(File file, File file2) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.moveRecursively(arrayList, file, file2);
        this.cvsRemoveRecursively(file);
        this.refresh(arrayList);
    }

    private void moveRecursively(List<File> list, File file, File file2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                File file4;
                String string = file3.getName();
                if (file3.isDirectory()) {
                    if (string.equals("CVS")) {
                        new File(file3, ".nb-removed").createNewFile();
                        continue;
                    }
                    file4 = new File(file2, string);
                    this.moveRecursively(list, file3, file4);
                    list.add(file3);
                    list.add(file4);
                    continue;
                }
                file2.mkdirs();
                file4 = new File(file2, string);
                file3.renameTo(file4);
                list.add(file3);
                list.add(file4);
            }
        }
    }

    private void cvsRemoveRecursively(File file) {
        Object[] objectArray;
        StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
        Entry[] entryArray = null;
        try {
            entryArray = standardAdminHandler.getEntriesAsArray(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (entryArray != null) {
            objectArray = entryArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Entry entry = objectArray[i];
                if (entry == null || entry.isDirectory() || entry.isUserFileToBeRemoved()) continue;
                Object object = new File(file, entry.getName());
                this.cvsRemoveLocally((AdminHandler)standardAdminHandler, (File)object, entry);
            }
        }
        for (Object object : objectArray = file.listFiles()) {
            if (!object.isDirectory()) continue;
            this.cvsRemoveRecursively((File)object);
        }
    }

    public void afterMove(final File file, final File file2) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(file);
                FilesystemHandler.this.fileCreatedImpl(file2);
            }
        });
    }

    public boolean beforeCreate(File file, boolean bl) {
        if (FilesystemHandler.ignoringEvents()) {
            return false;
        }
        if (file.getName().equals("CVS")) {
            if (file.isDirectory()) {
                File file2 = new File(file, "invalid-metadata");
                try {
                    file2.createNewFile();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(65536, "Unable to create marker: " + file2.getAbsolutePath());
                }
            }
            return true;
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
        file.mkdir();
        File file2 = new File(file, "invalid-metadata");
        try {
            file2.createNewFile();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(65536, "Unable to create marker: " + file2.getAbsolutePath());
        }
    }

    public void afterCreate(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileCreatedImpl(file);
            }
        });
    }

    public void afterChange(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.cache.refreshCached(file, 0);
                if (file.getName().equals(".cvsignore")) {
                    FilesystemHandler.this.cache.directoryContentChanged(file.getParentFile());
                }
            }
        });
    }

    private void fileCreatedImpl(File file) {
        if (file == null) {
            return;
        }
        int n = this.cache.refresh(file, 0).getStatus();
        if ((n & 0xFFFFFFFE) == 0) {
            return;
        }
        if (n == 256) {
            StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
            Entry entry = null;
            try {
                entry = standardAdminHandler.getEntry(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (entry != null && !entry.isDirectory() && entry.isUserFileToBeRemoved()) {
                this.cvsUndoRemoveLocally((AdminHandler)standardAdminHandler, file, entry);
            }
            this.cache.refresh(file, 0);
        }
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
        if (file.isDirectory()) {
            this.cache.directoryContentChanged(file);
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        StandardAdminHandler standardAdminHandler = new StandardAdminHandler();
        Entry entry = null;
        try {
            entry = standardAdminHandler.getEntry(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (entry != null && !entry.isDirectory() && !entry.isUserFileToBeRemoved()) {
            this.cvsRemoveLocally((AdminHandler)standardAdminHandler, file, entry);
        }
        this.cache.refresh(file, 0);
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
    }

    private void cvsRemoveLocally(AdminHandler adminHandler, File file, Entry entry) {
        try {
            if (entry.isNewUserFile()) {
                adminHandler.removeEntry(file);
            } else {
                entry.setRevision("-" + entry.getRevision());
                entry.setConflict("dummy timestamp");
                adminHandler.setEntry(file, entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cvsUndoRemoveLocally(AdminHandler adminHandler, File file, Entry entry) {
        entry.setRevision(entry.getRevision().substring(1));
        entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(System.currentTimeMillis() - 1000L)));
        try {
            adminHandler.setEntry(file, entry);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refresh(List<File> list) {
        for (File file : list) {
            this.cache.refresh(file, 0, true);
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, "CVS/Repository").canRead();
    }

    static void ignoreEvents(boolean bl) {
        ignoredThread = bl ? Thread.currentThread() : null;
    }

    private static boolean ignoringEvents() {
        return ignoredThread == Thread.currentThread();
    }
}

