/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ModuleLifecycleManager
extends ModuleInstall
implements ErrorHandler,
EntityResolver {
    static final String[] vcsGenericModules = new String[]{"org.netbeans.modules.vcs.advanced", "org.netbeans.modules.vcs.profiles.cvsprofiles", "org.netbeans.modules.vcs.profiles.vss", "org.netbeans.modules.vcs.profiles.pvcs", "org.netbeans.modules.vcs.profiles.subversion", "org.netbeans.modules.vcs.profiles.teamware"};

    public void restored() {
        this.disableOldModules();
    }

    private void disableOldModules() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl = false;
                block17: for (int i = 0; i < vcsGenericModules.length; ++i) {
                    FileLock fileLock = null;
                    OutputStream outputStream = null;
                    try {
                        String string = vcsGenericModules[i];
                        String string2 = "Modules/" + string.replace('.', '-') + ".xml";
                        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string2);
                        if (fileObject == null) continue;
                        Document document = ModuleLifecycleManager.this.readModuleDocument(fileObject);
                        NodeList nodeList = document.getDocumentElement().getElementsByTagName("param");
                        int n = nodeList.getLength();
                        for (int j = 0; j < n; ++j) {
                            Element element = (Element)nodeList.item(j);
                            if (!"enabled".equals(element.getAttribute("name"))) continue;
                            Text text = (Text)element.getChildNodes().item(0);
                            String string3 = text.getNodeValue();
                            if (!"true".equals(string3)) continue block17;
                            text.setNodeValue("false");
                            break;
                        }
                        if (!bl) {
                            JOptionPane.showMessageDialog(null, NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning"), NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning_Title"), 2);
                            bl = true;
                        }
                        fileLock = fileObject.lock();
                        outputStream = fileObject.getOutputStream(fileLock);
                        XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
                        continue;
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(1, (Throwable)exception);
                        continue;
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private Document readModuleDocument(FileObject fileObject) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(this);
        documentBuilder.setErrorHandler(this);
        InputStream inputStream = fileObject.getInputStream();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        return document;
    }

    public void uninstalled() {
        CvsVersioningSystem.getInstance().shutdown();
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    public void error(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
    }
}

