/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.options;

import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.options.CvsOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

class CvsOptionsController
extends OptionsPanelController {
    private CvsOptionsPanel panel;

    CvsOptionsController() {
    }

    public void update() {
        this.panel.getExcludeNewFiles().setSelected(CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false));
        this.panel.getStatusLabelFormat().setText(CvsModuleConfig.getDefault().getPreferences().get("annotationsFormat", "[{status}; {tag}]"));
        int n = CvsModuleConfig.getDefault().getWrapCommitMessagelength();
        this.panel.getWrapCommitMessages().setSelected(n > 0);
        this.panel.getWrapCharCount().setText(n > 0 ? Integer.toString(n) : "");
    }

    public void applyChanges() {
        if (!this.isValid()) {
            return;
        }
        CvsModuleConfig.getDefault().getPreferences().putBoolean("excludeNewFiles", this.panel.getExcludeNewFiles().isSelected());
        CvsModuleConfig.getDefault().getPreferences().put("annotationsFormat", this.panel.getStatusLabelFormat().getText());
        int n = this.panel.getWrapCommitMessages().isSelected() ? Integer.parseInt(this.panel.getWrapCharCount().getText().trim()) : 0;
        CvsModuleConfig.getDefault().setWrapCommitMessagelength(n);
    }

    public void cancel() {
    }

    public boolean isValid() {
        try {
            return !this.panel.getWrapCommitMessages().isSelected() || Integer.parseInt(this.panel.getWrapCharCount().getText().trim()) > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isChanged() {
        return true;
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new CvsOptionsPanel();
        }
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CvsOptionsController.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

