/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.checkout;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ProjectUtilities {
    private static final String ProjectTab_ID_LOGICAL = "projectTabLogical_tc";
    private static final String NEW_PROJECT_ACTION = "Actions/Project/org-netbeans-modules-project-ui-NewProject.instance";
    private static final String INITIAL_SOURCE_ROOT = "EXISTING_SOURCES_CURRENT_DIRECTORY";

    ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){
            final ExplorerManager.Provider ptLogial = ProjectUtilities.access$000("projectTabLogical_tc");

            public void run() {
                Node node = this.ptLogial.getExplorerManager().getRootContext();
                Node node2 = node.getChildren().findChild(ProjectUtils.getInformation((Project)project).getName());
                if (node2 != null) {
                    try {
                        this.ptLogial.getExplorerManager().setSelectedNodes(new Node[]{node2});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static synchronized ExplorerManager.Provider findDefault(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        return (ExplorerManager.Provider)topComponent;
    }

    public static void newProjectWizard(File file) {
        Action action = CommonProjectActions.newProjectAction();
        if (action != null) {
            File file2 = ProjectChooser.getProjectsFolder();
            ProjectChooser.setProjectsFolder((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            action.putValue("existingSourcesFolder", fileObject);
            ProjectUtilities.performAction(action);
            ProjectChooser.setProjectsFolder((File)file2);
        }
    }

    public static List scanForProjects(FileObject fileObject) {
        return ProjectUtilities.scanForProjectsRecursively(fileObject, 5);
    }

    private static List scanForProjectsRecursively(FileObject fileObject, int n) {
        Enumeration enumeration;
        if (n <= 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Enumeration> linkedList = new LinkedList<Enumeration>();
        ProjectManager projectManager = ProjectManager.getDefault();
        if (fileObject.isFolder() && projectManager.isProject(fileObject)) {
            try {
                enumeration = projectManager.findProject(fileObject);
                if (enumeration != null) {
                    linkedList.add(enumeration);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, "CVS.PU: ignoring suspicious project folder...");
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.isFolder()) continue;
            List list = ProjectUtilities.scanForProjectsRecursively(fileObject2, n - 1);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private static Action findAction(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                Object object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null && (object = instanceCookie.instanceCreate()) instanceof Action) {
                    Action action = (Action)object;
                    action.putValue("PRESELECT_CATEGORY", "General");
                    action.putValue("PRESELECT_TEMPLATE", null);
                    return action;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    private static boolean performAction(Action action) {
        if (action == null) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(ProjectUtilities.class, 1001, "command");
        try {
            action.actionPerformed(actionEvent);
            return true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
            return false;
        }
    }

    static /* synthetic */ ExplorerManager.Provider access$000(String string) {
        return ProjectUtilities.findDefault(string);
    }
}

